/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.taskwizard;

import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Shell;

public class ErrorsManager {
    private static ErrorsManager thisInstance = null;
    public static final String YSERIESDATA = "YSeriesData";
    private String errorMessage = null;
    private WizardBase wizard = null;
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final int WIDTH_OFFSET = 100;

    public static ErrorsManager instance() {
        if (thisInstance == null) {
            thisInstance = new ErrorsManager();
        }
        return thisInstance;
    }

    private ErrorsManager() {
    }

    public void registerWizard(WizardBase wizard) {
        this.wizard = wizard;
    }

    public void showErrors(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.wizard.getDialog().getShell() == null || this.wizard.getDialog().getShell().isDisposed()) {
            return;
        }
        this.wizard.getDialog().setErrorMessage(ErrorsManager.addLineSeparator(this.wizard.getDialog().getShell(), errorMessage));
    }

    private static String addLineSeparator(Shell shell, String errorMessage) {
        char[] chars;
        if (errorMessage == null) {
            return null;
        }
        int width = shell.computeSize((int)-1, (int)-1).x - 100;
        GC gc = new GC((Drawable)shell);
        int maxChar = width / gc.getFontMetrics().getAverageCharWidth();
        StringBuilder sb = new StringBuilder();
        int currentLineLength = 0;
        char[] cArray = chars = errorMessage.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char tempChar = cArray[n2];
            sb.append(tempChar);
            ++currentLineLength;
            if (LINE_SEPARATOR.contains(new String(new char[]{tempChar}))) {
                currentLineLength = 0;
            }
            if (currentLineLength == maxChar) {
                sb.append(LINE_SEPARATOR.length() == 2 ? Character.valueOf(LINE_SEPARATOR.charAt(1)) : LINE_SEPARATOR);
                currentLineLength = 0;
            }
            ++n2;
        }
        return sb.toString();
    }

    public void removeErrors() {
        this.errorMessage = null;
        if (!this.wizard.isDisposed()) {
            this.wizard.getDialog().setErrorMessage(null);
        }
    }

    public String getErrors() {
        return this.errorMessage;
    }
}

