/*******************************************************************************
 *  Copyright (c) 2000, 2025 IBM Corporation and others.
 *
 *  This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  IBM - Initial API and implementation
 *  Mike Morearty - Bug 271411
 *******************************************************************************/
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.osgi.util.NLS;

public class ActionMessages extends NLS {
	private static final String BUNDLE_NAME = "org.eclipse.debug.internal.ui.actions.ActionMessages";//$NON-NLS-1$
	public static String AbstractLaunchHistoryAction_0;
	public static String AbstractLaunchHistoryAction_1;
	public static String AbstractLaunchHistoryAction_2;
	public static String AbstractLaunchHistoryAction_3;
	public static String AbstractLaunchHistoryAction_4;

	public static String AbstractLaunchHistoryAction_5;

	public static String AbstractLaunchHistoryAction_6;

	public static String AddToFavoritesAction_1;
	public static String AddToFavoritesAction_2;
	public static String AddToFavoritesAction_3;

	public static String ChangeVariableValue_errorDialogMessage;
	public static String ChangeVariableValue_errorDialogTitle;
	public static String ChangeVariableValue_title;
	public static String ChangeVariableValue_toolTipText;
	public static String ChangeVariableValue_1;
	public static String ChangeVariableValue_2;
	public static String ChangeVariableValue_3;
	public static String ChangeVariableValue_4;

	public static String CollapseAllAction_0;

	public static String ConfigureColumnsAction_0;
	public static String ConfigureColumnsAction_1;
	public static String ConfigureColumnsAction_2;

	public static String CopyToClipboardActionDelegate_Problem_Copying_to_Clipboard_1;
	public static String CopyToClipboardActionDelegate_There_was_a_problem_when_accessing_the_system_clipboard__Retry__2;

	public static String DebugLastAction_0;

	public static String DebugLastAction_1;
	public static String DebugLastAction_2;
	public static String DebugLastAction_3;

	public static String DetailPaneAssignValueAction_0;
	public static String DetailPaneAssignValueAction_1;
	public static String DetailPaneAssignValueAction_2;
	public static String DetailPaneAssignValueAction_3;
	public static String DetailPaneAssignValueAction_4;
	public static String DetailPaneWordWrapAction_0;
	public static String DetailPaneMaxLengthAction_0;

	public static String EditLaunchConfigurationAction_1;

	public static String EnableBreakpointAction_Enable_breakpoint_s__failed_2;
	public static String EnableBreakpointAction_Enabling_breakpoints_3;
	public static String EnableBreakpointAction_Exceptions_occurred_enabling_the_breakpoint_s___4;

	public static String LaunchConfigurationAction_0;

	public static String OpenBreakpointMarkerAction__Go_to_File_1;
	public static String OpenBreakpointMarkerAction_Exceptions_occurred_attempting_to_open_the_editor_for_the_breakpoint_resource_2;
	public static String OpenBreakpointMarkerAction_Go_to_Breakpoint_1;
	public static String OpenBreakpointMarkerAction_Go_to_File_for_Breakpoint_2;

	public static String OpenLaunchDialogAction_1;

	public static String PasteWatchExpressionsAction_0;

	public static String ProfileLastAction_0;

	public static String ProfileLastAction_1;
	public static String ProfileLastAction_2;
	public static String ProfileLastAction_3;

	public static String RelaunchActionDelegate_An_exception_occurred_while_launching_2;
	public static String RelaunchActionDelegate_Launch_Failed_1;
	public static String RelaunchLastAction_Cannot_relaunch_1;
	public static String RelaunchLastAction_Cannot_relaunch___0___because_it_does_not_support__2__mode_2;
	public static String RelaunchLastAction_Error_relaunching_3;
	public static String RelaunchLastAction_Error_encountered_attempting_to_relaunch_4;

	public static String RemoveAllBreakpointsAction_0;
	public static String RemoveAllBreakpointsAction_1;
	public static String RemoveAllBreakpointsAction_2;
	public static String RemoveAllBreakpointsAction_3;
	public static String RemoveAllBreakpointsAction_4;
	public static String RemoveBreakpointAction_0;
	public static String RemoveBreakpointAction_1;
	public static String RemoveBreakpointAction_2;
	public static String RemoveBreakpointAction_3;
	public static String RemoveBreakpointAction_4;
	public static String RemoveBreakpointAction_5;
	public static String RemoveBreakpointAction_6;
	public static String RemoveBreakpointAction_Exceptions_occurred_attempting_to_remove_a_breakpoint__5;
	public static String RemoveBreakpointAction_Removing_a_breakpoint_4;

	public static String RemoveAllTriggerPointsAction_0;
	public static String RemoveAllTriggerPointsAction_1;

	public static String DisableAllBreakPointsAction_0;
	public static String DisableAllBreakPointsAction_1;
	public static String DisableAllBreakPointsAction_2;

	public static String DeleteBreakpointOperationName;
	public static String DeleteBreakpointsOperationName;

	public static String RetargetRunToLineAction_0;

	public static String RunLastAction_0;

	public static String RunLastAction_1;
	public static String RunLastAction_2;
	public static String RunLastAction_3;

	public static String ShowSupportedBreakpointsAction_Show_For_Selected;
	public static String ShowSupportedBreakpointsAction_tooltip;

	public static String ShowTypesAction_Show__Type_Names_1;
	public static String ShowTypesAction_Show_Type_Names;

	public static String SkipAllBreakpointsAction_0;
	public static String SkipAllBreakpointsAction_2;

	public static String TerminateAndRelaunchAction_0;
	public static String TerminateAndRelaunchAction_3;
	public static String TerminateAndRelaunchAction_4;
	public static String TerminateAndRemoveAction_0;
	public static String TerminateAndRemoveAction_3;

	public static String ToggleDetailPaneAction_0;

	public static String ToggleDetailPaneAction_1;
	public static String ToggleDetailPaneAction_2;
	public static String ToggleDetailPaneAction_3;
	public static String ToggleDetailPaneAction_4;
	public static String ToggleDetailPaneAction_5;
	public static String ToggleDetailPaneAction_8;
	public static String ToggleBreakpointAction_0;
	public static String ToggleBreakpointAction_1;
	public static String ToggleBreakpointAction_2;

	public static String ToggleBreakpointAction_3;
	public static String ToggleStepFiltersAction_0;
	public static String ToggleStepFiltersAction_1;

	public static String WatchExpressionDialog_0;
	public static String WatchExpressionDialog_1;
	public static String WatchExpressionDialog_2;
	public static String WatchExpressionDialog_3;
	public static String WatchExpressionDialog_4;

	public static String WatchExpressionDialog_5;
	public static String WatchExpressionDialogMenu_0;
	public static String WatchExpressionDialogMenu_1;
	public static String WatchExpressionDialogMenu_2;
	public static String WatchAction_0;
	public static String WatchAction_1;

	public static String RunToLineAction_0;
	public static String RunToLineAction_1;
	public static String RunToLineAction_2;
	public static String RunToLineAction_3;
	public static String RunToLineHandler_0;
	public static String RunToLineActionDelegate_4;

	public static String RetargetAction_2;
	public static String RetargetAction_3;
	public static String ModifyWatchpointAction_0;
	public static String ModifyWatchpointAction_1;
	public static String RemoveAllExpressionsAction_0;
	public static String RemoveAllExpressionsAction_1;
	public static String LaunchShortcutsAction_1;
	public static String FindDialog_1;
	public static String FindDialog_3;
	public static String FindAction_0;

	static {
		// load message values from bundle file
		NLS.initializeMessages(BUNDLE_NAME, ActionMessages.class);
	}

	public static String AbstractDebugActionDelegate_0;

	public static String RetargetAddMemoryBlockAction_0;
	public static String RetargetAddMemoryBlockAction_1;
	public static String AddMemoryRenderingActionDelegate_0;
	public static String AddMemoryRenderingActionDelegate_1;
	public static String AddMemoryRenderingActionDelegate_2;

	public static String RulerEnableDisableBreakpointAction_0;
	public static String RulerEnableDisableBreakpointAction_1;
	public static String RulerEnableDisableBreakpointAction_2;
	public static String RulerEnableDisableBreakpointAction_3;

	public static String RulerEnableDisableBreakpointAction_4;

	public static String DisconnectAction_0;
	public static String DisconnectAction_3;
	public static String DropToFrameAction_0;
	public static String DropToFrameAction_3;
	public static String LaunchAction_0;

	public static String LaunchAction_1;

	public static String LaunchAction_2;

	public static String RestartCommandAction__text;

	public static String RestartCommandAction_tooltip;

	public static String ResumeAction_0;
	public static String ResumeAction_3;
	public static String StepIntoAction_0;
	public static String StepIntoAction_3;
	public static String StepOverAction_0;
	public static String StepOverAction_3;
	public static String StepReturnAction_2;
	public static String StepReturnAction_3;
	public static String SuspendAction_0;
	public static String SuspendAction_3;
	public static String TerminateAction_0;
	public static String TerminateAction_3;
	public static String TerminateAndLaunchFailure;
	public static String TerminateAllAction_2;
	public static String TerminateAllAction_3;

	public static String DeleteWorkingsetsMessageDialog_0;
	public static String DeleteWorkingsetsMessageDialog_1;

	public static String ShowTypesAction_0;

	public static String VirtualFindAction_0;
	public static String VirtualFindAction_1;

	public static String ToggleBreakpointsTargetManager_defaultToggleTarget_name;
	public static String ToggleBreakpointsTargetManager_defaultToggleTarget_description;
	public static String EnableAllBreakpointsAction_0;
	public static String EnableAllBreakpointsAction_1;
	public static String EnableAllBreakpointsAction_3;
	public static String BreakpointLabelDialog;

}