/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core.load;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.datatools.sqltools.data.internal.core.load.DataFormatException;

public class DataFileTokenizer {
    protected String filePath;
    protected String delims;
    protected static final String ENDL = System.getProperty("line.separator");
    protected BufferedReader reader;
    protected StringTokenizer st = null;
    protected String nextToken = null;

    public DataFileTokenizer(String filePath, String delims) {
        this.filePath = filePath;
        this.delims = delims;
    }

    public boolean bomEncoding() throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(this.filePath);
            boolean isBOM = false;
            int byteOne = fis.read();
            int byteTwo = fis.read();
            int byteThree = fis.read();
            if (byteOne == 239 && byteTwo == 187 && byteThree == 191) {
                isBOM = true;
            }
            boolean bl = isBOM;
            return bl;
        }
    }

    public void open() throws IOException {
        String line;
        FileInputStream fis = new FileInputStream(this.filePath);
        String encoding = ResourcesPlugin.getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        InputStreamReader isw = new InputStreamReader((InputStream)fis, encoding);
        this.reader = new BufferedReader(isw);
        if (this.bomEncoding()) {
            this.reader.skip(1L);
        }
        if ((line = this.reader.readLine()) != null) {
            this.st = new StringTokenizer(line, this.delims, true);
        }
    }

    public String peek() throws IOException {
        if (this.nextToken == null) {
            this.nextToken = this.nextToken();
        }
        return this.nextToken;
    }

    public void consume(String s) throws Exception {
        String token = this.nextToken();
        if (!token.equals(s)) {
            throw new DataFormatException("Unexpected token (found " + token + ", expected " + s + ")");
        }
    }

    public String nextToken() throws IOException {
        if (this.nextToken != null) {
            String s = this.nextToken;
            this.nextToken = null;
            return s;
        }
        if (this.st == null || !this.st.hasMoreTokens()) {
            String line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            this.st = new StringTokenizer(line, this.delims, true);
            return ENDL;
        }
        return this.st.nextToken();
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

