/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.ddl;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.ibm.db2.DB2PluginActivator;
import org.eclipse.datatools.enablement.ibm.db2.ddl.DB2DdlMessages;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Alias;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Column;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Function;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2IdentitySpecifier;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Index;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Jar;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Procedure;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Routine;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Table;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Trigger;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2UserDefinedFunction;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2View;
import org.eclipse.datatools.enablement.ibm.db2.model.DataCaptureType;
import org.eclipse.datatools.enablement.ibm.db2.model.GenerateType;
import org.eclipse.datatools.enablement.ibm.db2.model.OriginType;
import org.eclipse.datatools.enablement.ibm.ddl.DdlBuilder;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationUtility;
import org.eclipse.datatools.enablement.ibm.ddl.RoutineDdlBuilder;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.ArrayDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.routines.DataAccess;
import org.eclipse.datatools.modelbase.sql.routines.Function;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public abstract class DB2DdlBuilder
extends DdlBuilder {
    protected static final String DB2SQL = "DB2SQL";
    protected static final String MODE = "MODE";
    protected static final String CYCLE = "CYCLE";
    protected static final String CACHE = "CACHE";
    protected static final String IN = "IN";
    protected static final String OUT = "OUT";
    protected static final String INOUT = "INOUT";
    protected static final String LOCATOR = "LOCATOR";
    protected static final String RETURNS = "RETURNS";
    protected static final String CAST = "CAST";
    protected static final String SPECIFIC = "SPECIFIC";
    protected static final String EXTERNAL = "EXTERNAL";
    protected static final String COLUMN = "COLUMN";
    protected static final String NICKNAME = "NICKNAME";
    protected static final String TEMPLATE = "TEMPLATE";
    protected static final String LABEL = "LABEL";
    protected static final String PACKAGE = "PACKAGE";
    protected static final String MAXVALUE = "MAXVALUE ";
    protected static final String NO_MAXVALUE = "NO MAXVALUE ";
    protected static final String MINVALUE = "MINVALUE ";
    protected static final String NO_MINVALUE = "NO MINVALUE ";
    protected static final String INCREMENT_BY = "INCREMENT BY ";
    protected static final String START_WITH = "START WITH ";
    protected static final String SET_MAXVALUE = "SET MAXVALUE ";
    protected static final String SET_NO_MAXVALUE = "SET NO MAXVALUE ";
    protected static final String SET_MINVALUE = "SET MINVALUE ";
    protected static final String SET_NO_MINVALUE = "SET NO MINVALUE ";
    protected static final String SET_INCREMENT_BY = "SET INCREMENT BY ";
    protected static final String RESTART_WITH = "RESTART WITH ";
    protected static final String RESTART = "RESTART ";
    protected static final String EMPTY_STRING = "";
    protected static final String COMMA = ", ";
    protected static final String ORDER = "ORDER ";
    protected static final String SINGLE_QUOTED_EMPTY_STRING = "''";

    public String createAlias(DB2Alias alias, boolean quoteIdentifiers, boolean qualifyNames) {
        Table aliased = alias.getAliasedTable();
        if (aliased == null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(DB2DdlMessages.FE_ALIAS_TABLE_NOT_EXIST, this.getName(alias, false, true)));
            return null;
        }
        return "CREATE ALIAS " + this.getName(alias, quoteIdentifiers, qualifyNames) + " " + "FOR" + " " + this.getName(aliased, quoteIdentifiers, qualifyNames);
    }

    public String dropAlias(DB2Alias alias, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP ALIAS " + this.getName(alias, quoteIdentifiers, qualifyNames);
    }

    public String createSchema(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        return "CREATE SCHEMA " + this.getName(schema, quoteIdentifiers, qualifyNames);
    }

    public String dropSchema(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        return String.valueOf(super.dropSchema(schema, quoteIdentifiers, qualifyNames)) + " " + "RESTRICT";
    }

    public String createDistinctUserDefinedType(DistinctUserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        PredefinedDataType dataType = type.getPredefinedRepresentation();
        if (dataType == null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(DB2DdlMessages.FE_DISTINCT_TYPE_HAS_NO_SOURCE_TYPE, this.getName((UserDefinedType)type, false, true)));
            return null;
        }
        EObject root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)type);
        if (!(root instanceof Database)) {
            return null;
        }
        DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
        String dataTypeString = def.getPredefinedDataTypeFormattedName(dataType);
        String statement = "CREATE DISTINCT TYPE " + this.getName((UserDefinedType)type, quoteIdentifiers, qualifyNames) + " " + "AS" + " " + dataTypeString;
        if (!(dataTypeString.equals("BLOB") || dataTypeString.equals("CLOB") || dataTypeString.equals("DBCLOB") || dataTypeString.equals("LONG VARCHAR") || dataTypeString.equals("LONG VARGRAPHIC") || dataTypeString.equals("DATALINK"))) {
            statement = String.valueOf(statement) + " WITH COMPARISONS";
        }
        return statement;
    }

    public String createTrigger(DB2Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String c;
        String statement = "CREATE TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames) + " ";
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "AFTER";
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "NO" + " " + "CASCADE" + " " + "BEFORE";
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "INSTEAD OF";
        }
        statement = String.valueOf(statement) + " ";
        if (trigger.isDeleteType()) {
            statement = String.valueOf(statement) + "DELETE";
        } else if (trigger.isInsertType()) {
            statement = String.valueOf(statement) + "INSERT";
        } else if (trigger.isUpdateType()) {
            statement = String.valueOf(statement) + "UPDATE";
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = String.valueOf(statement) + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = String.valueOf(statement) + this.getName(column, quoteIdentifiers, false);
                    if (!it.hasNext()) continue;
                    statement = String.valueOf(statement) + ",  ";
                }
            }
        }
        statement = String.valueOf(statement) + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        String newTable = trigger.getNewTable();
        String oldTable = trigger.getOldTable();
        String referenceStr = EMPTY_STRING;
        if (newRow != null && newRow.length() != 0) {
            referenceStr = String.valueOf(referenceStr) + (referenceStr.equals(EMPTY_STRING) ? " " : String.valueOf(NEWLINE) + "\t" + "\t") + "NEW" + " " + "AS" + " " + newRow;
        }
        if (oldRow != null && oldRow.length() != 0) {
            referenceStr = String.valueOf(referenceStr) + (referenceStr.equals(EMPTY_STRING) ? " " : String.valueOf(NEWLINE) + "\t" + "\t") + "OLD" + " " + "AS" + " " + oldRow;
        }
        if (newTable != null && newTable.length() != 0) {
            referenceStr = String.valueOf(referenceStr) + (referenceStr.equals(EMPTY_STRING) ? " " : String.valueOf(NEWLINE) + "\t" + "\t") + this.getTriggerReferenceNewTable() + " " + "AS" + " " + newTable;
        }
        if (oldTable != null && oldTable.length() != 0) {
            referenceStr = String.valueOf(referenceStr) + (referenceStr.equals(EMPTY_STRING) ? " " : String.valueOf(NEWLINE) + "\t" + "\t") + this.getTriggerReferenceOldTable() + " " + "AS" + " " + oldTable;
        }
        if (!referenceStr.equals(EMPTY_STRING)) {
            statement = String.valueOf(statement) + "\tREFERENCING " + referenceStr + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? String.valueOf(statement) + "\tFOR EACH ROW" : String.valueOf(statement) + "\tFOR EACH STATEMENT";
        statement = String.valueOf(statement) + " MODE DB2SQL" + NEWLINE;
        SearchCondition condition = trigger.getWhen();
        if (condition != null && (c = condition.getSQL()) != null && c.trim().length() != 0 && DdlGenerationUtility.filterOutComments((String)c)) {
            statement = String.valueOf(statement) + "WHEN (" + DdlGenerationUtility.convertLineEndings((String)c, (String)NEWLINE) + ")" + NEWLINE;
        }
        String sqlBody = EMPTY_STRING;
        for (SQLStatement s : trigger.getActionStatement()) {
            sqlBody = String.valueOf(sqlBody) + s.getSQL();
        }
        if (sqlBody.equals(EMPTY_STRING) || !DdlGenerationUtility.filterOutComments((String)sqlBody)) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(DB2DdlMessages.FE_TRIGGER_ACTION_EMPTY, this.getName(trigger, quoteIdentifiers, qualifyNames)));
            return null;
        }
        statement = String.valueOf(statement) + DdlGenerationUtility.convertLineEndings((String)sqlBody, (String)NEWLINE);
        return statement;
    }

    public String createView(DB2View view, boolean quoteIdentifiers, boolean qualifyNames) {
        String viewDefinition = "CREATE VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames) + " ";
        String columns = this.getViewColumnList(view, quoteIdentifiers);
        if (columns != null) {
            viewDefinition = String.valueOf(viewDefinition) + "(" + columns + ")" + " ";
        }
        viewDefinition = String.valueOf(viewDefinition) + "AS" + NEWLINE;
        QueryExpression expression = view.getQueryExpression();
        if (expression == null || expression.getSQL() == null || expression.getSQL().length() == 0) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(DB2DdlMessages.FE_VIEW_HAS_NO_BODY, this.getName((Table)view, false, true)));
        } else {
            viewDefinition = String.valueOf(viewDefinition) + expression.getSQL();
        }
        CheckType checkType = view.getCheckType();
        if (checkType == CheckType.CASCADED_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + "WITH" + " " + "CASCADED" + " " + "CHECK" + " " + "OPTION";
        } else if (checkType == CheckType.LOCAL_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + "WITH" + " " + "LOCAL" + " " + "CHECK" + " " + "OPTION";
        }
        return viewDefinition;
    }

    public String createUserDefinedFunction(DB2UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database = function.getSchema().getDatabase();
        RoutineDdlBuilder routineDdlBuilder = DdlBuilder.getRoutineDdlBuilder((String)database.getVendor(), (String)database.getVersion());
        if (routineDdlBuilder != null && (ddl = routineDdlBuilder.buildCreateRoutineStatement((Routine)function, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        String language = function.getLanguage();
        if (language == null && function.getOrigin() == OriginType.NONE_LITERAL) {
            language = "SQL";
        }
        if (language.trim().equalsIgnoreCase("SQL")) {
            Source source = function.getSource();
            if (source != null) {
                return source.getBody();
            }
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(DB2DdlMessages.FE_ROUTINE_SOURCE_EMPTY, this.getName(function, false, true)));
            return null;
        }
        String text = "CREATE FUNCTION " + this.getName(function, quoteIdentifiers, qualifyNames) + " " + "(" + this.getParameters(function, qualifyNames) + ")" + NEWLINE + "\t" + this.getFunctionReturnsClause(function, qualifyNames);
        if (function.getOrigin() == OriginType.TEMPLATE_LITERAL) {
            text = String.valueOf(text) + NEWLINE + "\t" + "AS" + " " + TEMPLATE;
            text = String.valueOf(text) + this.getDeterministicOption(function);
            text = String.valueOf(text) + this.getExternalActionOption(function);
        } else {
            text = String.valueOf(text) + this.getSpecificOption(function, quoteIdentifiers, qualifyNames);
            text = String.valueOf(text) + this.getDeterministicOption(function);
            text = String.valueOf(text) + this.getDataAccessOption(function);
            text = String.valueOf(text) + this.getExternalActionOption(function);
            text = String.valueOf(text) + this.getNullCallOption((Function)function);
            text = String.valueOf(text) + this.getParallelOption(function);
            text = String.valueOf(text) + this.getFederatedOption(function);
            text = String.valueOf(text) + this.getLanguageOption(function);
            text = String.valueOf(text) + this.getCardinalityOption(function);
            text = String.valueOf(text) + this.getDBInfoOption(function);
            text = String.valueOf(text) + this.getExternalNameOption(function, quoteIdentifiers, qualifyNames);
            text = String.valueOf(text) + this.getFencedOption(function);
            text = String.valueOf(text) + this.getFinalCallOption(function);
            text = String.valueOf(text) + this.getParameterStyleOption(function);
            text = String.valueOf(text) + this.getParameterCcsidOption(function);
            text = String.valueOf(text) + this.getPredicatesOption(function);
            text = String.valueOf(text) + this.getScratchPadCallOption(function);
            text = String.valueOf(text) + this.getSecurityOption(function);
        }
        return text;
    }

    public String createProcedure(DB2Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database = procedure.getSchema().getDatabase();
        RoutineDdlBuilder routineDdlBuilder = DdlBuilder.getRoutineDdlBuilder((String)database.getVendor(), (String)database.getVersion());
        if (routineDdlBuilder != null && (ddl = routineDdlBuilder.buildCreateRoutineStatement((Routine)procedure, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        String language = procedure.getLanguage();
        if (language == null) {
            language = "SQL";
        }
        if (language.equalsIgnoreCase("SQL")) {
            Source source = procedure.getSource();
            if (source != null) {
                return source.getBody();
            }
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(DB2DdlMessages.FE_ROUTINE_SOURCE_EMPTY, this.getName(procedure, false, true)));
            return null;
        }
        String text = "CREATE PROCEDURE " + this.getName(procedure, quoteIdentifiers, qualifyNames) + " " + "(" + this.getParameters(procedure, qualifyNames) + ")";
        text = String.valueOf(text) + this.getSpecificOption(procedure, quoteIdentifiers, qualifyNames);
        text = String.valueOf(text) + this.getDataAccessOption(procedure);
        text = String.valueOf(text) + this.getDeterministicOption(procedure);
        text = String.valueOf(text) + this.getDynamicResultSetsOption(procedure);
        text = String.valueOf(text) + this.getFederatedOption(procedure);
        text = String.valueOf(text) + NEWLINE + "\t" + "LANGUAGE " + language;
        text = String.valueOf(text) + this.getFencedOption(procedure);
        text = String.valueOf(text) + this.getParameterStyleOption(procedure);
        text = String.valueOf(text) + this.getProgramTypeOption(procedure);
        text = String.valueOf(text) + this.getDBInfoOption(procedure);
        text = String.valueOf(text) + this.getExternalNameOption(procedure, quoteIdentifiers, qualifyNames);
        return text;
    }

    public String addCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String text = super.addCheckConstraint(constraint, quoteIdentifiers, qualifyNames);
        text = String.valueOf(text) + this.getEnforcedOption((Constraint)constraint);
        return text;
    }

    public String addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        String text = super.addForeignKey(foreignKey, quoteIdentifiers, qualifyNames);
        if (text == null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(DB2DdlMessages.FE_PARENT_TABLLE_OR_KEY_DO_NOT_EXIST, foreignKey.getName()));
            return null;
        }
        text = String.valueOf(text) + this.getEnforcedOption((Constraint)foreignKey);
        return text;
    }

    public String commentOn(DB2Alias alias, boolean quoteIdentifiers, boolean qualifyNames) {
        String comment = alias.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        return "COMMENT ON ALIAS " + this.getName(alias, quoteIdentifiers, qualifyNames) + " " + "IS" + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        String comment = column.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        Table table = column.getTable();
        if (!(table instanceof PersistentTable) && !(table instanceof ViewTable)) {
            return null;
        }
        String columnName = column.getName();
        String tableName = table.getName();
        String schemaName = column.getTable().getSchema().getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        columnName = qualifyNames ? String.valueOf(schemaName) + "." + tableName + "." + columnName : String.valueOf(tableName) + "." + columnName;
        return "COMMENT ON COLUMN " + columnName + " " + "IS" + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(DistinctUserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String comment = type.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        String name = this.getName((UserDefinedType)type, quoteIdentifiers, qualifyNames);
        return "COMMENT ON DISTINCT TYPE " + name + " " + "IS" + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String commentOn(ArrayDataType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String comment = type.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        String name = this.getName(type, quoteIdentifiers, qualifyNames);
        return "COMMENT ON TYPE " + name + " " + "IS" + NEWLINE + this.getSingleQuotedString(comment);
    }

    private String getName(ArrayDataType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String schemaName;
        String typeName = type.getName();
        String string = schemaName = ((UserDefinedType)type).getSchema() != null ? ((UserDefinedType)type).getSchema().getName() : null;
        if (schemaName == null) {
            DB2PluginActivator.getInstance().writeLog(4, 0, "User-defined type " + type + " does not have a schema. The user-defined type name will not be qualified in the DDL.", null);
        }
        if (quoteIdentifiers) {
            typeName = this.getDoubleQuotedString(typeName);
            if (schemaName != null) {
                schemaName = this.getDoubleQuotedString(schemaName);
            }
        }
        if (qualifyNames && schemaName != null) {
            typeName = String.valueOf(schemaName) + "." + typeName;
        }
        return typeName;
    }

    public String labelOn(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = column.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        Table table = column.getTable();
        if (!(table instanceof PersistentTable) && !(table instanceof ViewTable)) {
            return null;
        }
        String columnName = column.getName();
        String tableName = table.getName();
        String schemaName = column.getTable().getSchema().getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        columnName = qualifyNames ? String.valueOf(schemaName) + "." + tableName + "." + columnName : String.valueOf(tableName) + "." + columnName;
        return "LABEL ON COLUMN " + columnName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(DB2Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = procedure.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        String procedureName = procedure.getName();
        String schemaName = procedure.getSchema().getName();
        if (quoteIdentifiers) {
            procedureName = this.getDoubleQuotedString(procedureName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            procedureName = String.valueOf(schemaName) + "." + procedureName;
        }
        return "LABEL ON PROCEDURE " + procedureName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(DB2UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = function.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        String functionName = function.getName();
        String schemaName = function.getSchema().getName();
        if (quoteIdentifiers) {
            functionName = this.getDoubleQuotedString(functionName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            functionName = String.valueOf(schemaName) + "." + functionName;
        }
        return "LABEL ON FUNCTION " + functionName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(DB2Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = trigger.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        String triggerName = trigger.getName();
        String schemaName = trigger.getSchema().getName();
        if (quoteIdentifiers) {
            triggerName = this.getDoubleQuotedString(triggerName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            triggerName = String.valueOf(schemaName) + "." + triggerName;
        }
        return "LABEL ON TRIGGER " + triggerName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = constraint.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        String constraintName = constraint.getName();
        String tableName = constraint.getBaseTable().getName();
        String schemaName = constraint.getBaseTable().getSchema().getName();
        if (quoteIdentifiers) {
            constraintName = this.getDoubleQuotedString(constraintName);
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        constraintName = qualifyNames ? String.valueOf(schemaName) + "." + tableName + "." + constraintName : String.valueOf(tableName) + "." + constraintName;
        return "LABEL ON CONSTRAINT " + constraintName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(DB2Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = index.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        String indexName = index.getName();
        String schemaName = index.getSchema().getName();
        if (quoteIdentifiers) {
            indexName = this.getDoubleQuotedString(indexName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            indexName = String.valueOf(schemaName) + "." + indexName;
        }
        return "LABEL ON INDEX " + indexName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(DistinctUserDefinedType userDefinedType, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = userDefinedType.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        String userDefinedTypeName = userDefinedType.getName();
        String schemaName = userDefinedType.getSchema().getName();
        if (quoteIdentifiers) {
            userDefinedTypeName = this.getDoubleQuotedString(userDefinedTypeName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            userDefinedTypeName = String.valueOf(schemaName) + "." + userDefinedTypeName;
        }
        return "LABEL ON TYPE " + userDefinedTypeName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = sequence.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        String sequenceName = sequence.getName();
        String schemaName = sequence.getSchema().getName();
        if (quoteIdentifiers) {
            sequenceName = this.getDoubleQuotedString(sequenceName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            sequenceName = String.valueOf(schemaName) + "." + sequenceName;
        }
        return "LABEL ON SEQUENCE " + sequenceName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(Schema schema, boolean quoteIdentifiers) {
        String label = schema.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        String schemaName = schema.getName();
        if (quoteIdentifiers) {
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        return "LABEL ON SCHEMA " + schemaName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = table.getLabel();
        if (label == null) {
            return null;
        }
        if ((label = label.trim()).equals(EMPTY_STRING)) {
            return null;
        }
        String tableName = table.getName();
        String schemaName = table.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + "." + tableName;
        }
        return "LABEL ON TABLE " + tableName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String labelOn(DB2Alias alias, boolean quoteIdentifiers, boolean qualifyNames) {
        String label = alias.getLabel();
        if (label == null || label.equals(EMPTY_STRING)) {
            return null;
        }
        String aliasName = alias.getName();
        String schemaName = alias.getSchema().getName();
        if (quoteIdentifiers) {
            aliasName = this.getDoubleQuotedString(aliasName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            aliasName = String.valueOf(schemaName) + "." + aliasName;
        }
        return "LABEL ON ALIAS " + aliasName + " " + "IS" + NEWLINE + this.getSingleQuotedString(label);
    }

    public String alterTableAlterColumnIdentity(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (!(table instanceof BaseTable)) {
            return null;
        }
        DB2Column db2Column = (DB2Column)column;
        String columnName = db2Column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + " ALTER COLUMN " + columnName;
        DB2IdentitySpecifier identitySpecifier = (DB2IdentitySpecifier)db2Column.getIdentitySpecifier();
        if (identitySpecifier == null) {
            statement = String.valueOf(statement) + " DROP IDENTITY";
        } else {
            String columnString = EMPTY_STRING;
            GenerateType generateType = db2Column.getGenerationType();
            columnString = generateType == GenerateType.ALWAYS_LITERAL ? String.valueOf(columnString) + " SET GENERATED ALWAYS " : String.valueOf(columnString) + " SET GENERATED BY DEFAULT ";
            columnString = String.valueOf(columnString) + this.getIdentityAlterationString(identitySpecifier);
            statement = String.valueOf(statement) + columnString;
        }
        return statement;
    }

    protected String getIdentityString(DB2IdentitySpecifier identitySpecifier) {
        StringBuffer sb = new StringBuffer();
        if (identitySpecifier.getStartValue() != null) {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + START_WITH + identitySpecifier.getStartValue());
        }
        if (identitySpecifier.getIncrement() != null) {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + INCREMENT_BY + identitySpecifier.getIncrement());
        }
        if (identitySpecifier.getMinimum() != null) {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + MINVALUE + identitySpecifier.getMinimum());
        } else {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + NO_MINVALUE);
        }
        if (identitySpecifier.getMaximum() != null) {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + MAXVALUE + identitySpecifier.getMaximum());
        } else {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + NO_MAXVALUE);
        }
        if (identitySpecifier.isCycleOption()) {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + CYCLE);
        } else {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + "NO" + " " + CYCLE);
        }
        if (identitySpecifier.getCache() > 1) {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + CACHE + " " + identitySpecifier.getCache());
        } else {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + "NO" + " " + CACHE);
        }
        if (identitySpecifier.isOrder()) {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + ORDER);
        } else {
            sb.append(String.valueOf(NEWLINE) + "\t" + "\t" + "\t" + "NO" + " " + ORDER);
        }
        return sb.toString();
    }

    protected String getIdentityAlterationString(DB2IdentitySpecifier identitySpecifier) {
        StringBuffer sb = new StringBuffer();
        if (identitySpecifier.getStartValue() != null) {
            sb.append(" RESTART WITH " + identitySpecifier.getStartValue());
        }
        if (identitySpecifier.getIncrement() != null) {
            sb.append(" SET INCREMENT BY " + identitySpecifier.getIncrement());
        }
        if (identitySpecifier.getMinimum() != null) {
            sb.append(" SET MINVALUE " + identitySpecifier.getMinimum());
        }
        if (identitySpecifier.getMaximum() != null) {
            sb.append(" SET MAXVALUE " + identitySpecifier.getMaximum());
        }
        if (identitySpecifier.isCycleOption()) {
            sb.append(" SET CYCLE");
        } else {
            sb.append(" SET NO CYCLE");
        }
        if (identitySpecifier.getCache() > 1) {
            sb.append(" SET CACHE " + identitySpecifier.getCache());
        } else {
            sb.append(" SET NO CACHE");
        }
        return sb.toString();
    }

    protected String getParameters(Routine routine, boolean qualifyNames) {
        String parameters = EMPTY_STRING;
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            ParameterMode mode = p.getMode();
            if (mode == ParameterMode.INOUT_LITERAL) {
                parameters = String.valueOf(parameters) + "INOUT ";
            } else if (mode == ParameterMode.OUT_LITERAL) {
                parameters = String.valueOf(parameters) + "OUT ";
            }
            String name = p.getName();
            if (name != null && name.length() != 0) {
                parameters = String.valueOf(parameters) + p.getName() + " ";
            }
            parameters = String.valueOf(parameters) + this.getDataTypeString((TypedElement)p, routine.getSchema(), qualifyNames);
            if (p.isLocator()) {
                parameters = String.valueOf(parameters) + " AS LOCATOR";
            }
            if (!it.hasNext()) continue;
            parameters = String.valueOf(parameters) + COMMA + NEWLINE + "\t" + "\t";
        }
        return parameters;
    }

    protected String getFunctionReturnsClause(DB2UserDefinedFunction function, boolean qualifyNames) {
        if (function.getReturnScalar() != null) {
            Parameter scaler = function.getReturnScalar();
            String text = "RETURNS " + this.getDataTypeString((TypedElement)scaler, function.getSchema(), qualifyNames);
            if (function.getReturnCast() != null) {
                Parameter cast = function.getReturnCast();
                text = String.valueOf(text) + " CAST FROM " + this.getDataTypeString((TypedElement)cast, function.getSchema(), qualifyNames);
            }
            return text;
        }
        if (function.getReturnTable() != null) {
            RoutineResultTable resultTable = function.getReturnTable();
            String text = "RETURNS TABLE (";
            Iterator it = resultTable.getColumns().iterator();
            while (it.hasNext()) {
                Column c = (Column)it.next();
                text = String.valueOf(text) + c.getName() + " " + this.getDataTypeString((TypedElement)c, function.getSchema(), qualifyNames);
                if (!it.hasNext()) continue;
                text = String.valueOf(text) + ",  ";
            }
            text = String.valueOf(text) + ")";
            return text;
        }
        if (function.getReturnCast() != null) {
            Parameter cast = function.getReturnCast();
            String text = "RETURNS " + this.getDataTypeString((TypedElement)cast, function.getSchema(), qualifyNames);
            return text;
        }
        return function.getReturnClause();
    }

    protected String getSpecificOption(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String specificName = routine.getSpecificName();
        if (specificName != null && specificName.length() != 0) {
            String schemaName = routine.getSchema().getName();
            if (quoteIdentifiers) {
                specificName = this.getDoubleQuotedString(specificName);
                schemaName = this.getDoubleQuotedString(schemaName);
            }
            if (qualifyNames) {
                specificName = String.valueOf(schemaName) + "." + specificName;
            }
            return String.valueOf(NEWLINE) + "\t" + SPECIFIC + " " + specificName;
        }
        return EMPTY_STRING;
    }

    protected String getParameterStyleOption(Routine routine) {
        String parameterStyle = routine.getParameterStyle();
        if (parameterStyle == null || parameterStyle.trim().isEmpty()) {
            return EMPTY_STRING;
        }
        if (parameterStyle.trim().equals("GNRLNULL")) {
            parameterStyle = "GENERAL WITH NULLS";
        }
        return String.valueOf(NEWLINE) + "\t" + "PARAMETER STYLE " + parameterStyle;
    }

    protected String getDeterministicOption(Routine routine) {
        if (routine.isDeterministic()) {
            return String.valueOf(NEWLINE) + "\t" + "DETERMINISTIC";
        }
        return EMPTY_STRING;
    }

    protected String getLanguageOption(Routine routine) {
        String language = routine.getLanguage();
        if (language == null || language.trim().isEmpty()) {
            return EMPTY_STRING;
        }
        return String.valueOf(NEWLINE) + "\t" + "LANGUAGE " + language;
    }

    protected String getJarID(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        return null;
    }

    protected String getName(DB2Jar jar, boolean quoteIdentifiers, boolean qualifyNames) {
        String jarschema = null;
        String jarname = null;
        if (jar != null) {
            if (jar.getSchema() != null) {
                jarschema = jar.getSchema().getName();
            }
            jarname = jar.getName();
        }
        StringBuffer jaridbuf = new StringBuffer(50);
        if (jarname != null && jarname.length() > 0) {
            if (quoteIdentifiers) {
                jarname = this.getDoubleQuotedString(jarname);
            }
            jaridbuf.append(jarname);
        }
        if (jarschema != null && jarschema.length() > 0) {
            if (quoteIdentifiers) {
                jarschema = this.getDoubleQuotedString(jarschema);
            }
            jaridbuf.insert(0, '.');
            jaridbuf.insert(0, jarschema);
        }
        if (jaridbuf.length() == 0) {
            return null;
        }
        return jaridbuf.toString();
    }

    protected String getExternalNameOption(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String option = String.valueOf(NEWLINE) + "\t" + EXTERNAL;
        String externalName = routine.getExternalName();
        if (externalName != null && externalName.length() != 0) {
            routine.getSchema().getName();
            if (routine.getLanguage().equalsIgnoreCase("JAVA")) {
                String jarid = this.getJarID(routine, quoteIdentifiers, qualifyNames);
                if (jarid != null) {
                    externalName = String.valueOf(jarid) + ":" + externalName;
                }
                externalName = this.getSingleQuotedString(externalName);
            } else if (quoteIdentifiers) {
                externalName = this.getDoubleQuotedString(externalName);
            }
            option = String.valueOf(option) + " NAME " + externalName;
        }
        return option;
    }

    protected String getDataAccessOption(Routine routine) {
        DataAccess dataAccess = routine.getSqlDataAccess();
        if (dataAccess == DataAccess.CONTAINS_SQL_LITERAL) {
            return String.valueOf(NEWLINE) + "\t" + "CONTAINS SQL";
        }
        if (dataAccess == DataAccess.MODIFIES_SQL_DATA_LITERAL) {
            return String.valueOf(NEWLINE) + "\t" + "MODIFIES SQL DATA";
        }
        if (dataAccess == DataAccess.NO_SQL_LITERAL) {
            return String.valueOf(NEWLINE) + "\t" + "NO SQL";
        }
        if (dataAccess == DataAccess.READS_SQL_DATA_LITERAL) {
            return String.valueOf(NEWLINE) + "\t" + "READS SQL DATA";
        }
        return EMPTY_STRING;
    }

    protected String getSecurityOption(Routine routine) {
        String security = routine.getSecurity();
        if (security != null && security.length() != 0) {
            return String.valueOf(NEWLINE) + "\t" + "SECURITY " + security;
        }
        return EMPTY_STRING;
    }

    protected String getDBInfoOption(DB2Routine routine) {
        if (routine.isDbInfo()) {
            return String.valueOf(NEWLINE) + "\t" + "DBINFO";
        }
        return EMPTY_STRING;
    }

    protected String getParameterCcsidOption(DB2Routine routine) {
        String ccsid = routine.getParmCcsid();
        if (ccsid != null && ccsid.length() != 0) {
            return String.valueOf(NEWLINE) + "\t" + "PARAMETER CCSID " + ccsid;
        }
        return EMPTY_STRING;
    }

    protected String getProgramTypeOption(DB2Routine routine) {
        String programType = routine.getProgramType();
        if (programType != null && programType.length() != 0) {
            return String.valueOf(NEWLINE) + "\t" + "PROGRAM TYPE " + programType;
        }
        return EMPTY_STRING;
    }

    protected String getFederatedOption(DB2Routine routine) {
        if (routine.isFederated()) {
            return String.valueOf(NEWLINE) + "\t" + "FEDERATED";
        }
        return EMPTY_STRING;
    }

    protected String getFencedOption(DB2Routine routine) {
        String fenced = routine.getFenced();
        if (fenced == null) {
            fenced = "FENCED";
        }
        if (fenced.equalsIgnoreCase("FENCED")) {
            String threadsafe = routine.getThreadsafe();
            if (threadsafe == null) {
                threadsafe = "THREADSAFE";
            }
            fenced = String.valueOf(fenced) + " " + threadsafe;
        }
        return String.valueOf(NEWLINE) + "\t" + fenced;
    }

    protected String getNullCallOption(Function function) {
        if (function.isNullCall()) {
            return String.valueOf(NEWLINE) + "\t" + "CALLED ON NULL INPUT";
        }
        return EMPTY_STRING;
    }

    protected String getTransformGroupOption(Function function) {
        String transform = function.getTransformGroup();
        if (transform != null && transform.length() != 0) {
            return String.valueOf(NEWLINE) + "\t" + "TRANSFORM GROUP " + transform;
        }
        return EMPTY_STRING;
    }

    protected String getDynamicResultSetsOption(Procedure procedure) {
        int rs = procedure.getMaxResultSets();
        if (rs > 0) {
            return String.valueOf(NEWLINE) + "\t" + "DYNAMIC RESULT SETS " + rs;
        }
        return EMPTY_STRING;
    }

    protected String getExternalActionOption(DB2Function function) {
        if (!function.isExternalAction()) {
            return String.valueOf(NEWLINE) + "\t" + "NO EXTERNAL ACTION";
        }
        return EMPTY_STRING;
    }

    protected String getCardinalityOption(DB2Function function) {
        int c = function.getCardinality();
        if (c > 0) {
            return String.valueOf(NEWLINE) + "\t" + "CARDINALITY " + c;
        }
        return EMPTY_STRING;
    }

    protected String getParallelOption(DB2Function function) {
        if (function.isAllowParallel()) {
            return String.valueOf(NEWLINE) + "\t" + "ALLOW PARALLEL";
        }
        return String.valueOf(NEWLINE) + "\t" + "DISALLOW PARALLEL";
    }

    protected String getFinalCallOption(DB2Function function) {
        if (function.isFinalCall()) {
            return String.valueOf(NEWLINE) + "\t" + "FINAL CALL";
        }
        return EMPTY_STRING;
    }

    protected String getScratchPadCallOption(DB2Function function) {
        int scratch = function.getScratchPadLength();
        if (scratch > 0) {
            return String.valueOf(NEWLINE) + "\t" + "SCRATCHPAD " + scratch;
        }
        return EMPTY_STRING;
    }

    protected String getPredicatesOption(DB2Function function) {
        String predicates = function.getPredicate();
        if (predicates != null && predicates.length() != 0) {
            return String.valueOf(NEWLINE) + "\t" + "PREDICATES " + "(" + predicates + ")";
        }
        return EMPTY_STRING;
    }

    public String getEnforcedOption(Constraint constraint) {
        if (!constraint.isEnforced()) {
            return String.valueOf(NEWLINE) + "\t" + "NOT ENFORCED";
        }
        return EMPTY_STRING;
    }

    public String createRoutineStatement(DB2Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database = procedure.getSchema().getDatabase();
        RoutineDdlBuilder routineDdlBuilder = DdlBuilder.getRoutineDdlBuilder((String)database.getVendor(), (String)database.getVersion());
        if (routineDdlBuilder != null && (ddl = routineDdlBuilder.buildCreateRoutineStatement((Routine)procedure, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        String text = "CREATE PROCEDURE " + this.getName(procedure, quoteIdentifiers, qualifyNames) + " " + "(" + this.getParameters(procedure, qualifyNames) + ")";
        text = String.valueOf(text) + this.getSpecificOption(procedure, quoteIdentifiers, qualifyNames);
        text = String.valueOf(text) + this.getDataAccessOption(procedure);
        text = String.valueOf(text) + this.getDeterministicOption(procedure);
        text = String.valueOf(text) + this.getDynamicResultSetsOption(procedure);
        text = String.valueOf(text) + this.getFederatedOption(procedure);
        String language = procedure.getLanguage();
        if (language == null) {
            language = "SQL";
        }
        if (language.equalsIgnoreCase("SQL")) {
            text = String.valueOf(text) + "\tLANGUAGE " + language + NEWLINE;
            text = String.valueOf(text) + procedure.getSource().getBody();
        } else {
            text = String.valueOf(text) + NEWLINE + "\t" + "LANGUAGE " + language;
            text = String.valueOf(text) + this.getFencedOption(procedure);
            text = String.valueOf(text) + this.getParameterStyleOption(procedure);
            text = String.valueOf(text) + this.getProgramTypeOption(procedure);
            text = String.valueOf(text) + this.getDBInfoOption(procedure);
            text = String.valueOf(text) + this.getExternalNameOption(procedure, quoteIdentifiers, qualifyNames);
        }
        return text;
    }

    public String createRoutineStatement(DB2UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database = function.getSchema().getDatabase();
        RoutineDdlBuilder routineDdlBuilder = DdlBuilder.getRoutineDdlBuilder((String)database.getVendor(), (String)database.getVersion());
        if (routineDdlBuilder != null && (ddl = routineDdlBuilder.buildCreateRoutineStatement((Routine)function, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        String text = "CREATE FUNCTION " + this.getName(function, quoteIdentifiers, qualifyNames) + " " + "(" + this.getParameters(function, qualifyNames) + ")" + NEWLINE + "\t" + this.getFunctionReturnsClause(function, qualifyNames);
        text = String.valueOf(text) + this.getSpecificOption(function, quoteIdentifiers, qualifyNames);
        text = String.valueOf(text) + this.getDeterministicOption(function);
        text = String.valueOf(text) + this.getDataAccessOption(function);
        text = String.valueOf(text) + this.getExternalActionOption(function);
        text = String.valueOf(text) + this.getNullCallOption((Function)function);
        text = String.valueOf(text) + this.getParallelOption(function);
        text = String.valueOf(text) + this.getFederatedOption(function);
        String language = function.getLanguage();
        if (language == null) {
            language = "SQL";
        }
        if (language.equalsIgnoreCase("SQL")) {
            text = String.valueOf(text) + function.getSource().getBody();
        } else {
            text = String.valueOf(text) + NEWLINE + "\t" + "LANGUAGE " + language;
            text = String.valueOf(text) + this.getCardinalityOption(function);
            text = String.valueOf(text) + this.getDBInfoOption(function);
            text = String.valueOf(text) + this.getExternalNameOption(function, quoteIdentifiers, qualifyNames);
            text = String.valueOf(text) + this.getFencedOption(function);
            text = String.valueOf(text) + this.getFinalCallOption(function);
            text = String.valueOf(text) + this.getParameterStyleOption(function);
            text = String.valueOf(text) + this.getParameterCcsidOption(function);
            text = String.valueOf(text) + this.getPredicatesOption(function);
            text = String.valueOf(text) + this.getScratchPadCallOption(function);
            text = String.valueOf(text) + this.getSecurityOption(function);
        }
        return text;
    }

    protected String getTriggerReferenceNewTable() {
        return "NEW_TABLE";
    }

    protected String getTriggerReferenceOldTable() {
        return "OLD_TABLE";
    }

    protected String getDataCapture(DB2Table table) {
        DataCaptureType validProc = table.getDataCapture();
        if (validProc == DataCaptureType.NONE_LITERAL) {
            return String.valueOf(NEWLINE) + "\t" + "DATA CAPTURE NONE ";
        }
        return String.valueOf(NEWLINE) + "\t" + "DATA CAPTURE CHANGES ";
    }

    protected String getGrantUseOfStatement(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        String ret = String.valueOf(NEWLINE) + "GRANT" + " " + privilege.getAction() + " " + "OF" + " " + this.getPrivilegedObjectTypeString(privilege) + " " + this.getPrivilegedObjectName(privilege, quoteIdentifiers, qualifyNames) + " " + "TO" + " " + this.getGranteeSubstring(privilege.getGrantee(), quoteIdentifiers);
        if (privilege.isGrantable()) {
            ret = String.valueOf(ret) + " WITH GRANT OPTION";
        }
        return ret;
    }

    protected String getRevokeUseOfStatement(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        String ret = String.valueOf(NEWLINE) + "REVOKE" + " " + privilege.getAction() + " " + "OF" + " " + this.getPrivilegedObjectTypeString(privilege) + " " + this.getPrivilegedObjectName(privilege, quoteIdentifiers, qualifyNames) + " " + "FROM" + " " + this.getGranteeSubstring(privilege.getGrantee(), quoteIdentifiers);
        return ret;
    }
}

