/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.internal.ui.drivers;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.connectivity.ui.wizards.OptionalPropertiesPane;
import org.eclipse.datatools.enablement.ibm.db2.luw.internal.ui.util.ResourceLoader;
import org.eclipse.datatools.enablement.ibm.internal.ui.drivers.IBMJDBCDriverTracingOptionsPane;
import org.eclipse.datatools.enablement.ibm.internal.ui.drivers.IIBMJDBCDriverProvider;
import org.eclipse.datatools.enablement.ibm.internal.ui.drivers.Messages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class DB2LUWKerberosDriverUIContributor
implements IDriverUIContributor,
IIBMJDBCDriverProvider,
Listener {
    private static final String EMPTY = "";
    private String CUI_NEWCW_DATABASE_LBL_UI_ = ResourceLoader.CUI_NEWCW_DATABASE_LBL_UI_;
    private static final String CUI_NEWCW_HOST_LBL_UI_ = ResourceLoader.CUI_NEWCW_HOST_LBL_UI_;
    private static final String CUI_NEWCW_PORT_LBL_UI_ = ResourceLoader.CUI_NEWCW_PORT_LBL_UI_;
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = ResourceLoader.CUI_NEWCW_CONNECTIONURL_LBL_UI_;
    private static final String CUI_NEWCW_DEFAULT_SCHEMA_LBL_UI_ = ResourceLoader.CUI_NEWCW_DEFAULT_SCHEMA_LBL_UI_;
    private static final String CUI_NEWCW_DEFAULT_SCHEMA_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_DEFAULT_SCHEMA_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_DRIVER_OPTIONS_TAB_UI_ = Messages.getString((String)"CUI_NEWCW_DRIVER_OPTIONS_TAB_UI_");
    private static final String CUI_NEWCW_TRACING_OPTIONS_TAB_UI_ = Messages.getString((String)"CUI_NEWCW_TRACING_OPTIONS_TAB_UI_");
    private static final String SECURITY_MECHANISM_PROPERTY_NAME = "securityMechanism";
    private static final String SECURITY_MECHANISM_PROPERTY_VALUE = "11";
    private static final String CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_URL_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_URL_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_KERBOROS_KINIT_AUTHENTICATION_ = ResourceLoader.CUI_NEWCW_KERBOROS_KINIT_AUTHENTICATION;
    private static final String CUI_NEWCW_USERNAME_LBL_UI_ = ResourceLoader.CUI_NEWCW_USERNAME_LBL_UI_;
    private static final String CUI_NEWCW_PASSWORD_LBL_UI_ = ResourceLoader.CUI_NEWCW_PASSWORD_LBL_UI_;
    private static final String CUI_NEWCW_VALIDATE_USERID_REQ_UI_ = ResourceLoader.CUI_NEWCW_VALIDATE_USERID_REQ_UI_;
    private static final String CUI_NEWCW_VALIDATE_PASSWORD_REQ_UI_ = ResourceLoader.CUI_NEWCW_VALIDATE_PASSWORD_REQ_UI_;
    private IBMJDBCDriverTracingOptionsPane tracingOptionsComposite;
    private Label databaseLabel;
    private Text databaseText;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private String urlOptionalParameters = "";
    private Button kinitAuthenticationButton;
    private Button savePasswordButton;
    private Label userNameLabel;
    private Label passwordLabel;
    private Text userNameText;
    private Text passwordText;
    private Text portText;
    private Label defaultSchemaLabel;
    private Text defaultSchemaText;
    private Label urlLabel;
    private Text urlText;
    private DialogPage parentPage;
    private ScrolledComposite parentComposite;
    private IDriverUIContributorInformation contributorInformation;
    private Properties properties;
    private boolean isReadOnly = false;
    protected OptionalPropertiesPane optionalPropsComposite;

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            TabFolder tabComposite = new TabFolder((Composite)this.parentComposite, 128);
            TabItem driverOptionsTab = new TabItem(tabComposite, 0);
            driverOptionsTab.setText(CUI_NEWCW_DRIVER_OPTIONS_TAB_UI_);
            TabItem tracingOptionsTab = new TabItem(tabComposite, 0);
            tracingOptionsTab.setText(CUI_NEWCW_TRACING_OPTIONS_TAB_UI_);
            Composite driverOptionsComposite = new Composite((Composite)tabComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            driverOptionsComposite.setLayout((Layout)layout);
            driverOptionsTab.setControl((Control)driverOptionsComposite);
            this.tracingOptionsComposite = new IBMJDBCDriverTracingOptionsPane((Composite)tabComposite, 0, (IIBMJDBCDriverProvider)this, isReadOnly);
            tracingOptionsTab.setControl((Control)this.tracingOptionsComposite);
            this.databaseLabel = new Label(driverOptionsComposite, 0);
            this.databaseLabel.setText(this.CUI_NEWCW_DATABASE_LBL_UI_);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            this.databaseLabel.setLayoutData((Object)gd);
            this.databaseText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.databaseText.setLayoutData((Object)gd);
            this.hostLabel = new Label(driverOptionsComposite, 0);
            this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.portLabel = new Label(driverOptionsComposite, 0);
            this.portLabel.setText(CUI_NEWCW_PORT_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.portLabel.setLayoutData((Object)gd);
            this.portText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.portText.setLayoutData((Object)gd);
            this.kinitAuthenticationButton = new Button(driverOptionsComposite, 32);
            this.kinitAuthenticationButton.setText(CUI_NEWCW_KERBOROS_KINIT_AUTHENTICATION_);
            gd = new GridData();
            gd.horizontalSpan = 3;
            gd.verticalAlignment = 1;
            this.kinitAuthenticationButton.setLayoutData((Object)gd);
            this.userNameLabel = new Label(driverOptionsComposite, 0);
            this.userNameLabel.setText(CUI_NEWCW_USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.userNameLabel.setLayoutData((Object)gd);
            this.userNameText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.userNameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(driverOptionsComposite, 0);
            this.passwordLabel.setText(CUI_NEWCW_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(driverOptionsComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.savePasswordButton = new Button(driverOptionsComposite, 32);
            this.savePasswordButton.setText(ResourceLoader.CUI_NEWCW_SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.defaultSchemaLabel = new Label(driverOptionsComposite, 0);
            this.defaultSchemaLabel.setText(CUI_NEWCW_DEFAULT_SCHEMA_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.defaultSchemaLabel.setLayoutData((Object)gd);
            this.defaultSchemaText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.defaultSchemaText.setLayoutData((Object)gd);
            this.urlLabel = new Label(driverOptionsComposite, 0);
            this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(driverOptionsComposite, 2634);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            gd.widthHint = 190;
            gd.heightHint = 90;
            this.urlText.setLayoutData((Object)gd);
            this.parentComposite.setContent((Control)tabComposite);
            this.parentComposite.setMinSize(tabComposite.computeSize(-1, -1));
            TabItem optionalPropsTab = new TabItem(tabComposite, 0);
            optionalPropsTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.optionaltab"));
            this.optionalPropsComposite = this.createOptionalPropertiesPane((Composite)tabComposite, 0, isReadOnly);
            optionalPropsTab.setControl((Control)this.optionalPropsComposite);
            this.parentComposite.setContent((Control)tabComposite);
            this.parentComposite.setMinSize(tabComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    protected OptionalPropertiesPane createOptionalPropertiesPane(Composite parent, int style, boolean useReadOnlyControls) {
        return new OptionalPropertiesPane(parent, style, useReadOnlyControls);
    }

    private void enableUserProperties() {
        boolean selection = this.kinitAuthenticationButton.getSelection();
        this.userNameLabel.setEnabled(!selection);
        this.passwordLabel.setEnabled(!selection);
        this.userNameText.setEnabled(!selection);
        this.passwordText.setEnabled(!selection);
        this.savePasswordButton.setEnabled(!selection);
        if (selection) {
            String userName = this.userNameText.getText();
            String password = this.passwordText.getText();
            if (userName != null && !userName.equals(EMPTY) || password != null && !password.equals(EMPTY)) {
                this.userNameText.removeListener(24, (Listener)this);
                this.passwordText.removeListener(24, (Listener)this);
                this.savePasswordButton.removeListener(13, (Listener)this);
                this.userNameText.setText(EMPTY);
                this.passwordText.setText(EMPTY);
                this.savePasswordButton.setSelection(false);
                this.userNameText.addListener(24, (Listener)this);
                this.passwordText.addListener(24, (Listener)this);
                this.savePasswordButton.addListener(13, (Listener)this);
            }
        }
    }

    public void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.databaseText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.defaultSchema", this.defaultSchemaText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        if (!this.kinitAuthenticationButton.getSelection()) {
            this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.userNameText.getText());
            this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
            this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        } else {
            this.properties.remove("org.eclipse.datatools.connectivity.db.username");
            this.properties.remove("org.eclipse.datatools.connectivity.db.password");
            this.properties.remove("org.eclipse.datatools.connectivity.db.savePWD");
        }
        this.optionalPropsComposite.setConnectionInformation();
        this.contributorInformation.setProperties(this.properties);
    }

    public void updateURL() {
        String url = "jdbc:db2://" + this.formatNode(this.hostText.getText().trim()) + ":" + this.portText.getText().trim() + "/" + this.databaseText.getText().trim() + ":retrieveMessagesFromServerOnGetMessage=true;" + SECURITY_MECHANISM_PROPERTY_NAME + "=" + SECURITY_MECHANISM_PROPERTY_VALUE + ";" + this.tracingOptionsComposite.getTracingURLProperties();
        url = String.valueOf(url) + this.getURLOptionalParameters();
        this.urlText.setText(url);
    }

    private String formatNode(String node) {
        if (node.indexOf(":") > -1) {
            return "[" + node + "]";
        }
        return node;
    }

    private void removeListeners() {
        this.savePasswordButton.removeListener(13, (Listener)this);
        this.kinitAuthenticationButton.removeListener(13, (Listener)this);
        this.databaseText.removeListener(24, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.portText.removeListener(24, (Listener)this);
        this.userNameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.defaultSchemaText.removeListener(24, (Listener)this);
    }

    private void addListeners() {
        this.savePasswordButton.addListener(13, (Listener)this);
        this.kinitAuthenticationButton.addListener(13, (Listener)this);
        this.databaseText.addListener(24, (Listener)this);
        this.hostText.addListener(24, (Listener)this);
        this.portText.addListener(24, (Listener)this);
        this.userNameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.defaultSchemaText.addListener(24, (Listener)this);
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            }
        } else {
            this.enableUserProperties();
            this.updateURL();
            this.setConnectionInformation();
        }
    }

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.databaseText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(MessageFormat.format((String)ResourceLoader.CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_, (Object[])new Object[]{ResourceLoader.CUI_NEWCW_DEFDBNAME_VAL_UI_}));
            isComplete = false;
        } else if (this.hostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(ResourceLoader.CUI_NEWCW_VALIDATE_HOST_REQ_UI_);
            isComplete = false;
        } else if (this.portText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(ResourceLoader.CUI_NEWCW_VALIDATE_PORT_REQ_UI_);
            isComplete = false;
        } else if (!this.kinitAuthenticationButton.getSelection() && this.userNameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(CUI_NEWCW_VALIDATE_USERID_REQ_UI_);
            isComplete = false;
        } else if (!this.kinitAuthenticationButton.getSelection() && this.passwordText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(CUI_NEWCW_VALIDATE_PASSWORD_REQ_UI_);
            isComplete = false;
        } else if (!this.tracingOptionsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        } else if (!this.optionalPropsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
        this.optionalPropsComposite.setDriverUIContributorInformation(contributorInformation);
    }

    public void loadProperties() {
        this.removeListeners();
        String defaultSchema = this.properties.getProperty("org.eclipse.datatools.connectivity.db.defaultSchema");
        if (defaultSchema != null) {
            this.defaultSchemaText.setText(defaultSchema);
        }
        DB2JDBCURL url = new DB2JDBCURL(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.hostText.setText(url.getNode());
        this.portText.setText(url.getPort());
        this.databaseText.setText(url.getDatabaseName());
        this.tracingOptionsComposite.loadProperties(url.getProperties());
        String username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (username != null) {
            this.userNameText.setText(username);
            this.kinitAuthenticationButton.setSelection(false);
        } else {
            this.kinitAuthenticationButton.setSelection(true);
            this.userNameText.setEnabled(false);
        }
        String password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password");
        if (password != null) {
            this.passwordText.setText(password);
            String savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD");
            if (savePassword != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
                this.savePasswordButton.setSelection(true);
            }
        } else if (this.kinitAuthenticationButton.getSelection()) {
            this.passwordText.setEnabled(false);
            this.savePasswordButton.setEnabled(false);
        }
        this.optionalPropsComposite.loadProperties();
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_, this.databaseText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_, this.portText.getText().trim()});
        if (!this.kinitAuthenticationButton.getSelection()) {
            summaryData.add(new String[]{ResourceLoader.CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_, this.userNameText.getText().trim()});
            summaryData.add(new String[]{ResourceLoader.CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? ResourceLoader.CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : ResourceLoader.CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        }
        summaryData.add(new String[]{CUI_NEWCW_DEFAULT_SCHEMA_SUMMARY_DATA_TEXT_, this.defaultSchemaText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        return summaryData;
    }

    public void setURLOptionalParameters(String connProp) {
        this.urlOptionalParameters = connProp;
    }

    public String getURLOptionalParameters() {
        return this.urlOptionalParameters;
    }

    private class DB2JDBCURL {
        private String subprotocol = "";
        private String node = "";
        private String port = "";
        private String databaseName = "";
        private String properties = "";
        private String urlOptionalParameters = "";

        public DB2JDBCURL(String url) {
            if (url != null) {
                this.parseURL(url);
            }
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        private void parseURL(String url) {
            try {
                DB2LUWKerberosDriverUIContributor.this.setURLOptionalParameters(DB2LUWKerberosDriverUIContributor.EMPTY);
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 3);
                this.node = remainingURL.substring(0, remainingURL.indexOf(47));
                if (this.node.indexOf(91) > -1 && this.node.indexOf("]:") > -1) {
                    this.port = this.node.substring(this.node.indexOf("]:") + 2);
                    this.node = this.node.substring(1, this.node.indexOf("]:"));
                } else if (this.node.indexOf(58) > -1) {
                    this.port = this.node.substring(this.node.indexOf(58) + 1);
                    this.node = this.node.substring(0, this.node.indexOf(58));
                }
                remainingURL = remainingURL.substring(remainingURL.indexOf(47) + 1);
                if (remainingURL.indexOf(58) > -1) {
                    this.databaseName = remainingURL.substring(0, remainingURL.indexOf(58));
                    this.properties = remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                } else if (remainingURL.indexOf(59) > -1) {
                    this.databaseName = remainingURL.substring(0, remainingURL.indexOf(59));
                    remainingURL = remainingURL.substring(remainingURL.indexOf(59) + 1);
                } else {
                    this.databaseName = remainingURL;
                    remainingURL = DB2LUWKerberosDriverUIContributor.EMPTY;
                }
                String userOptionalParameters = DB2LUWKerberosDriverUIContributor.EMPTY;
                String userParameter = DB2LUWKerberosDriverUIContributor.EMPTY;
                if (remainingURL != null && remainingURL.length() > 0) {
                    StringTokenizer st = new StringTokenizer(remainingURL, ";");
                    int tokenLength = st.countTokens();
                    int i = 0;
                    while (i < tokenLength) {
                        userParameter = st.nextToken();
                        if (!(userParameter == null || userParameter.length() <= 0 || userParameter.startsWith("retrieveMessagesFromServerOnGetMessage") || userParameter.equals("securityMechanism=11") || userParameter.startsWith("traceFile") || userParameter.startsWith("traceFileAppend") || userParameter.startsWith("traceLevel") || userParameter.startsWith("traceDirectory"))) {
                            userOptionalParameters = String.valueOf(userOptionalParameters) + userParameter + ";";
                        }
                        ++i;
                    }
                    DB2LUWKerberosDriverUIContributor.this.setURLOptionalParameters(userOptionalParameters);
                }
            }
            catch (Exception exception) {}
        }

        public String getPort() {
            return this.port;
        }

        public String getProperties() {
            return this.properties;
        }
    }
}

