/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class DesignElementHandleTest
extends BaseTestCase {
    static final String INPUT3 = "Improved_test3.xml";

    public DesignElementHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(DesignElementHandleTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT3, INPUT3);
    }

    public void testcanContainGroupName() throws SemanticException {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = this.sessionHandle.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle table = factory.newTableItem("table", 1);
        TableGroupHandle tableGroup = factory.newTableGroup();
        tableGroup.setName("Group1");
        DesignElementHandleTest.assertTrue((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        table.getGroups().add((DesignElementHandle)tableGroup);
        DesignElementHandleTest.assertFalse((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        tableGroup = factory.newTableGroup();
        tableGroup.setName("Group2");
        DesignElementHandleTest.assertTrue((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        OdaDataSourceHandle dataSource = factory.newOdaDataSource(null, null);
        OdaDataSetHandle dataSet = factory.newOdaDataSet(null, null);
        dataSet.setDataSource(dataSource.getName());
        table.setDataSet((DataSetHandle)dataSet);
        this.designHandle.getDataSources().add((DesignElementHandle)dataSource);
        this.designHandle.getDataSets().add((DesignElementHandle)dataSet);
        DesignElementHandleTest.assertTrue((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        table.getGroups().add((DesignElementHandle)tableGroup);
        DesignElementHandleTest.assertFalse((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        tableGroup = factory.newTableGroup();
        tableGroup.setName("Group1");
        DesignElementHandleTest.assertFalse((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        TableHandle nestedTable = factory.newTableItem("nested", 1);
        RowHandle row = (RowHandle)table.getDetail().get(0);
        CellHandle cell = (CellHandle)row.getCells().get(0);
        cell.getContent().add((DesignElementHandle)nestedTable);
        tableGroup = factory.newTableGroup();
        tableGroup.setName("Group3");
        DesignElementHandleTest.assertTrue((boolean)nestedTable.canContain(1, (DesignElementHandle)tableGroup));
        nestedTable.getGroups().add((DesignElementHandle)tableGroup);
        DesignElementHandleTest.assertFalse((boolean)nestedTable.canContain(1, (DesignElementHandle)tableGroup));
        tableGroup = factory.newTableGroup();
        tableGroup.setName("Group1");
        DesignElementHandleTest.assertFalse((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        ListHandle nestedList = factory.newList(null);
        cell.getContent().add((DesignElementHandle)nestedList);
        ListGroupHandle listGroup = factory.newListGroup();
        listGroup.setName("Group1");
        DesignElementHandleTest.assertFalse((boolean)nestedList.canContain(1, (DesignElementHandle)listGroup));
        DesignElementHandleTest.assertFalse((boolean)table.canContain(1, (DesignElementHandle)listGroup));
        tableGroup = factory.newTableGroup();
        tableGroup.setName("Group3");
        try {
            nestedTable.getGroups().add((DesignElementHandle)tableGroup);
            DesignElementHandleTest.fail();
        }
        catch (NameException e) {
            DesignElementHandleTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)e.getErrorCode());
        }
        tableGroup.setName("TrickGroup");
        nestedTable.getGroups().add((DesignElementHandle)tableGroup);
        listGroup.setName("Group4");
        DesignElementHandleTest.assertTrue((boolean)nestedList.canContain(1, (DesignElementHandle)listGroup));
        tableGroup = factory.newTableGroup();
        tableGroup.setName("Group4");
        DesignElementHandleTest.assertTrue((boolean)nestedTable.canContain(1, (DesignElementHandle)tableGroup));
        DesignElementHandleTest.assertTrue((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        tableGroup = factory.newTableGroup();
        DesignElementHandleTest.assertTrue((boolean)nestedTable.canContain(1, (DesignElementHandle)tableGroup));
        DesignElementHandleTest.assertTrue((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        table.getGroups().add((DesignElementHandle)tableGroup);
        tableGroup = factory.newTableGroup();
        DesignElementHandleTest.assertTrue((boolean)nestedTable.canContain(1, (DesignElementHandle)tableGroup));
        DesignElementHandleTest.assertTrue((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        table.getGroups().add((DesignElementHandle)tableGroup);
    }

    public void testcanContainSimpleMasterPage() throws Exception {
        this.openDesign(INPUT3);
        SimpleMasterPageHandle mHandle = (SimpleMasterPageHandle)this.designHandle.findMasterPage("Page1");
        DesignElementHandleTest.assertNotNull((String)"should not be null", (Object)mHandle);
        GridHandle grid = mHandle.getElementFactory().newGridItem("grid");
        DesignElementHandleTest.assertFalse((boolean)mHandle.canContain(mHandle.getPageHeader().getSlotID(), (DesignElementHandle)grid));
        DesignElementHandleTest.assertFalse((boolean)mHandle.canContain(mHandle.getPageFooter().getSlotID(), (DesignElementHandle)grid));
    }
}

