/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.providers;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.data.oda.pojo.querymodel.FieldSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.MethodSource;
import org.eclipse.birt.data.oda.pojo.querymodel.VariableParameter;
import org.eclipse.birt.data.oda.pojo.ui.impl.models.ColumnDefinition;
import org.eclipse.birt.data.oda.pojo.util.MethodParameterType;

public class ColumnMappingPageHelper {
    private Set<String> names = new HashSet<String>();
    private static final String AUTO_ADJUST_NAME_REGEX = ".*_[0-9]+$";
    private static final String DEFAULT_PARAM_NAME_PREFIX = "param_";
    private List<ColumnDefinition> definitions = new ArrayList<ColumnDefinition>();
    private List<IMethodParameter> currentColumnParams;

    public ColumnDefinition addColumnDefinition(ColumnDefinition cd) {
        assert (cd != null);
        String name = this.getDistinctName(cd.getName());
        this.names.add(name);
        ColumnDefinition def = cd.clone();
        def.setName(name);
        this.definitions.add(def);
        return def;
    }

    public ColumnDefinition[] addColumnDefinitions(ColumnDefinition[] definitions) {
        ColumnDefinition[] result = new ColumnDefinition[definitions.length];
        int index = 0;
        ColumnDefinition[] columnDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition cd = columnDefinitionArray[n2];
            result[index++] = this.addColumnDefinition(cd);
            ++n2;
        }
        return result;
    }

    public boolean isUniqueColumnName(String name) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        return !this.names.contains(name);
    }

    public String getDistinctName(String newName) {
        Object name = newName;
        while (this.names.contains(name)) {
            if (((String)name).matches(AUTO_ADJUST_NAME_REGEX)) {
                int lastIndex = ((String)name).lastIndexOf(95);
                String index = ((String)name).substring(lastIndex + 1);
                name = ((String)name).substring(0, lastIndex + 1) + (Integer.parseInt(index) + 1);
                continue;
            }
            name = ((String)name).endsWith("_") ? (String)name + "1" : (String)name + "_1";
        }
        return name;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.definitions;
    }

    public List<IMethodParameter> getAllParameters() {
        ArrayList<IMethodParameter> params = new ArrayList<IMethodParameter>();
        int i = 0;
        while (i < this.definitions.size()) {
            IMappingSource[] sources = this.definitions.get(i).getMappingPath();
            int j = 0;
            while (j < sources.length) {
                if (sources[j] instanceof MethodSource) {
                    params.addAll(Arrays.asList(((MethodSource)sources[j]).getParameters()));
                }
                ++j;
            }
            ++i;
        }
        return params;
    }

    public void clearColumnDefinitions() {
        this.definitions.clear();
        this.names.clear();
    }

    public boolean isFirstRow(Object o) {
        if (this.definitions.size() > 0) {
            return this.definitions.get(0) == o;
        }
        return false;
    }

    public boolean isLastRow(Object o) {
        if (this.definitions.size() > 0) {
            return this.definitions.get(this.definitions.size() - 1) == o;
        }
        return false;
    }

    public boolean isValidParamName(VariableParameter vp, String name, String type) {
        if (vp == null || vp.getName() == null || vp.getDataType() == null) {
            return false;
        }
        List<IMethodParameter> allParams = this.getAllParameters();
        int i = 0;
        while (i < this.definitions.size()) {
            List<VariableParameter> paramList = this.definitions.get(i).getVariableParameters();
            int k = 0;
            while (k < paramList.size()) {
                if (!vp.equals((Object)paramList.get(k)) && vp.getName().equals(paramList.get(k).getName())) {
                    return vp.getDataType().equalsIgnoreCase(paramList.get(k).getDataType());
                }
                ++k;
            }
            k = 0;
            while (k < allParams.size()) {
                IMethodParameter item = allParams.get(k);
                if (item instanceof VariableParameter && !vp.equals((Object)item) && name.equals(((VariableParameter)item).getName())) {
                    return type.equals(((VariableParameter)item).getDataType());
                }
                ++k;
            }
            ++i;
        }
        return true;
    }

    public int getElementIndex(Object o) {
        return this.definitions.indexOf(o);
    }

    public void moveColumnDefinitionUp(int index) {
        if (index >= 1 && index < this.definitions.size()) {
            ColumnDefinition cd = this.definitions.get(index);
            this.definitions.set(index, this.definitions.get(index - 1));
            this.definitions.set(index - 1, cd);
        }
    }

    public void moveColumnDefinitionDown(int index) {
        if (index >= 0 && index < this.definitions.size() - 1) {
            ColumnDefinition cd = this.definitions.get(index);
            this.definitions.set(index, this.definitions.get(index + 1));
            this.definitions.set(index + 1, cd);
        }
    }

    public void removeColumnDefinition(ColumnDefinition column) {
        if (this.definitions.remove(column)) {
            this.names.remove(column.getName());
        }
    }

    public ColumnDefinition setColumnDefinition(int index, ColumnDefinition cd) {
        this.names.remove(this.definitions.get(index).getName());
        String newName = this.getDistinctName(cd.getName());
        this.names.add(newName);
        ColumnDefinition newDef = cd.clone();
        newDef.setName(newName);
        this.definitions.set(index, newDef);
        return newDef;
    }

    public void updateParameters(ColumnDefinition cd) {
    }

    public int getColumnDefnCount() {
        return this.definitions.size();
    }

    public IMappingSource[] createMappingPath(List<Member> backs) {
        IMappingSource[] result = new IMappingSource[backs.size()];
        if (this.currentColumnParams == null) {
            this.currentColumnParams = new ArrayList<IMethodParameter>();
        }
        int index = 1;
        int i = 0;
        while (i < result.length) {
            Member m = backs.get(backs.size() - 1 - i);
            if (m instanceof Field) {
                result[i] = new FieldSource(m.getName());
            } else if (m instanceof Method) {
                ArrayList<VariableParameter> params = new ArrayList<VariableParameter>();
                Class<?>[] classArray = ((Method)m).getParameterTypes();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> c = classArray[n2];
                    index = this.getUniqueParamIndex();
                    MethodParameterType pt = MethodParameterType.getInstance(c);
                    VariableParameter vp = new VariableParameter(DEFAULT_PARAM_NAME_PREFIX + index, pt.getName());
                    ++index;
                    params.add(vp);
                    this.currentColumnParams.add((IMethodParameter)vp);
                    ++n2;
                }
                result[i] = new MethodSource(m.getName(), params.toArray(new IMethodParameter[0]));
            }
            assert (false);
            ++i;
        }
        return result;
    }

    public int getUniqueParamIndex() {
        int index = 1;
        while (this.containsParameter(DEFAULT_PARAM_NAME_PREFIX + index)) {
            ++index;
        }
        return index;
    }

    public boolean containsParameter(String name) {
        if (name != null) {
            int i = 0;
            while (i < this.definitions.size()) {
                List<VariableParameter> paramList = this.definitions.get(i).getVariableParameters();
                int k = 0;
                while (k < paramList.size()) {
                    if (name.equals(paramList.get(k).getName())) {
                        return true;
                    }
                    ++k;
                }
                ++i;
            }
            i = 0;
            while (i < this.currentColumnParams.size()) {
                IMethodParameter item = this.currentColumnParams.get(i);
                if (item instanceof VariableParameter && name.equals(((VariableParameter)item).getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void clearParametersCache() {
        if (this.currentColumnParams != null) {
            this.currentColumnParams.clear();
        }
    }
}

