/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.regre;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.junit.Assert;
import org.junit.Test;
import testutil.ConfigText;

public class SortHintTest
extends APITestCase {
    public static final String[] COLS = new String[]{"CUSTOMERID", "DURATION", "CHARGE", "TONUMBER"};

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestSortHint.TableName"), ConfigText.getString("Api.TestSortHint.TableSQL"), "testSortHint.txt");
    }

    private QueryDefinition getQueryDefn() {
        QueryDefinition queryDefn = this.newReportQuery();
        IBaseExpression[] exprArray = new IBaseExpression[COLS.length];
        int i = 0;
        while (i < COLS.length) {
            String exprName = COLS[i];
            ScriptExpression expr = new ScriptExpression("dataSetRow[\"" + COLS[i] + "\"]");
            queryDefn.addResultSetExpression(exprName, (IBaseExpression)expr);
            ++i;
        }
        return queryDefn;
    }

    @Test
    public void testSortHintTableSort() {
        QueryDefinition queryDefn = this.getQueryDefn();
        GroupDefinition[] gdArray = new GroupDefinition[1];
        GroupDefinition gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[0] + "\"]");
        gd.setSortDirection(0);
        gdArray[0] = gd;
        int i = 0;
        while (i < gdArray.length) {
            queryDefn.addGroup((IGroupDefinition)gdArray[i]);
            ++i;
        }
        SortDefinition[] sdArray = new SortDefinition[3];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[0] + "\"]");
        sd.setSortDirection(0);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[1] + "\"]");
        sd.setSortDirection(0);
        sdArray[1] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[2] + "\"]");
        sd.setSortDirection(0);
        sdArray[2] = sd;
        int i2 = 0;
        while (i2 < sdArray.length) {
            queryDefn.addSort(sdArray[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < COLS.length - 1) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i2] + "\"]");
            sd.setSortDirection(0);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i2;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintTableSort2() {
        QueryDefinition queryDefn = this.getQueryDefn();
        SortDefinition[] sdArray = new SortDefinition[2];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[0] + "\"]");
        sd.setSortDirection(0);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[1] + "\"]");
        sd.setSortDirection(0);
        sdArray[1] = sd;
        int i = 0;
        while (i < sdArray.length) {
            queryDefn.addSort(sdArray[i]);
            ++i;
        }
        i = 0;
        while (i < COLS.length - 1) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i] + "\"]");
            sd.setSortDirection(0);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintTableSort3() {
        QueryDefinition queryDefn = this.getQueryDefn();
        SortDefinition[] sdArray = new SortDefinition[2];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[0] + "\"]");
        sd.setSortDirection(0);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[2] + "\"]");
        sd.setSortDirection(0);
        sdArray[1] = sd;
        int i = 0;
        while (i < sdArray.length) {
            queryDefn.addSort(sdArray[i]);
            ++i;
        }
        i = 0;
        while (i < COLS.length - 1) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i] + "\"]");
            sd.setSortDirection(0);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintTableSort4() {
        QueryDefinition queryDefn = this.getQueryDefn();
        SortDefinition[] sdArray = new SortDefinition[2];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[1] + "\"]");
        sd.setSortDirection(0);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[3] + "\"]");
        sd.setSortDirection(1);
        sdArray[1] = sd;
        int i = 0;
        while (i < sdArray.length) {
            queryDefn.addSort(sdArray[i]);
            ++i;
        }
        i = 0;
        while (i < 2) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i] + "\"]");
            sd.setSortDirection(0);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintTableSort5() {
        QueryDefinition queryDefn = this.getQueryDefn();
        GroupDefinition[] gdArray = new GroupDefinition[2];
        GroupDefinition gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[0] + "\"]");
        gd.setSortDirection(0);
        gdArray[0] = gd;
        gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[1] + "\"]");
        gd.setSortDirection(0);
        gdArray[1] = gd;
        int i = 0;
        while (i < gdArray.length) {
            queryDefn.addGroup((IGroupDefinition)gdArray[i]);
            ++i;
        }
        SortDefinition[] sdArray = new SortDefinition[2];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[0] + "\"]");
        sd.setSortDirection(0);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[1] + "\"]");
        sd.setSortDirection(0);
        sdArray[1] = sd;
        int i2 = 0;
        while (i2 < sdArray.length) {
            queryDefn.addSort(sdArray[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < COLS.length - 1) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i2] + "\"]");
            sd.setSortDirection(0);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i2;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintTableSort6() {
        QueryDefinition queryDefn = this.getQueryDefn();
        GroupDefinition[] gdArray = new GroupDefinition[3];
        GroupDefinition gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[0] + "\"]");
        gd.setSortDirection(0);
        gdArray[0] = gd;
        gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[1] + "\"]");
        gd.setSortDirection(0);
        gdArray[1] = gd;
        gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[2] + "\"]");
        gd.setSortDirection(0);
        gdArray[2] = gd;
        int i = 0;
        while (i < gdArray.length) {
            queryDefn.addGroup((IGroupDefinition)gdArray[i]);
            ++i;
        }
        SortDefinition[] sdArray = new SortDefinition[2];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[1] + "\"]");
        sd.setSortDirection(0);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[3] + "\"]");
        sd.setSortDirection(0);
        sdArray[1] = sd;
        int i2 = 0;
        while (i2 < sdArray.length) {
            queryDefn.addSort(sdArray[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < COLS.length - 1) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i2] + "\"]");
            sd.setSortDirection(0);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i2;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintTableSort7() {
        QueryDefinition queryDefn = this.getQueryDefn();
        GroupDefinition[] gdArray = new GroupDefinition[3];
        GroupDefinition gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[0] + "\"]");
        gd.setSortDirection(0);
        gdArray[0] = gd;
        gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[1] + "\"]");
        gd.setSortDirection(0);
        gdArray[1] = gd;
        gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[2] + "\"]");
        gd.setSortDirection(0);
        gdArray[2] = gd;
        int i = 0;
        while (i < gdArray.length) {
            queryDefn.addGroup((IGroupDefinition)gdArray[i]);
            ++i;
        }
        SortDefinition[] sdArray = new SortDefinition[1];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[3] + "\"]");
        sd.setSortDirection(0);
        sdArray[0] = sd;
        int i2 = 0;
        while (i2 < sdArray.length) {
            queryDefn.addSort(sdArray[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < COLS.length) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i2] + "\"]");
            sd.setSortDirection(0);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i2;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintTableSort8() {
        QueryDefinition queryDefn = this.getQueryDefn();
        GroupDefinition[] gdArray = new GroupDefinition[3];
        GroupDefinition gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[0] + "\"]");
        gd.setSortDirection(0);
        gdArray[0] = gd;
        gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[1] + "\"]");
        gd.setSortDirection(0);
        gdArray[1] = gd;
        gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[2] + "\"]");
        gd.setSortDirection(0);
        gdArray[2] = gd;
        int i = 0;
        while (i < gdArray.length) {
            queryDefn.addGroup((IGroupDefinition)gdArray[i]);
            ++i;
        }
        SortDefinition[] sdArray = new SortDefinition[2];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[1] + "\"]");
        sd.setSortDirection(0);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[3] + "\"]");
        sd.setSortDirection(0);
        sdArray[1] = sd;
        int i2 = 0;
        while (i2 < sdArray.length) {
            queryDefn.addSort(sdArray[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < COLS.length) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i2] + "\"]");
            sd.setSortDirection(0);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i2;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintNoEffect() {
        QueryDefinition queryDefn = this.getQueryDefn();
        GroupDefinition[] gdArray = new GroupDefinition[1];
        GroupDefinition gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[0] + "\"]");
        gd.setSortDirection(1);
        gdArray[0] = gd;
        int i = 0;
        while (i < gdArray.length) {
            queryDefn.addGroup((IGroupDefinition)gdArray[i]);
            ++i;
        }
        SortDefinition[] sdArray = new SortDefinition[3];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[0] + "\"]");
        sd.setSortDirection(1);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[1] + "\"]");
        sd.setSortDirection(1);
        sdArray[1] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[2] + "\"]");
        sd.setSortDirection(0);
        sdArray[2] = sd;
        int i2 = 0;
        while (i2 < sdArray.length) {
            queryDefn.addSort(sdArray[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < COLS.length - 1) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i2] + "\"]");
            sd.setSortDirection(0);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i2;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintResolve() {
        QueryDefinition queryDefn = this.getQueryDefn();
        queryDefn.addResultSetExpression("REFERCOL", (IBaseExpression)new ScriptExpression("row[\"ID\"]"));
        queryDefn.addResultSetExpression("ID", (IBaseExpression)new ScriptExpression("dataSetRow[\"" + COLS[0] + "\"]"));
        SortDefinition[] sdArray = new SortDefinition[3];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"ID\"]");
        sd.setSortDirection(1);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[1] + "\"]");
        sd.setSortDirection(1);
        sdArray[1] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[2] + "\"]");
        sd.setSortDirection(1);
        sdArray[2] = sd;
        int i = 0;
        while (i < sdArray.length) {
            queryDefn.addSort(sdArray[i]);
            ++i;
        }
        i = 0;
        while (i < COLS.length - 1) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i] + "\"]");
            sd.setSortDirection(1);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i;
        }
        this.executeAndCheck(queryDefn);
    }

    @Test
    public void testSortHintResolveColumnAlias() {
        QueryDefinition queryDefn = this.newReportQuery();
        IBaseExpression[] exprArray = new IBaseExpression[COLS.length];
        Map exprs = queryDefn.getResultSetExpressions();
        int i = 0;
        while (i < COLS.length) {
            String exprName = COLS[i];
            ScriptExpression expr = new ScriptExpression("dataSetRow[\"" + COLS[i] + "_ALIAS\"]");
            queryDefn.addResultSetExpression(exprName, (IBaseExpression)expr);
            exprs.put(exprName + "_ALIAS", expr);
            ++i;
        }
        GroupDefinition[] gdArray = new GroupDefinition[3];
        GroupDefinition gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[0] + "_ALIAS\"]");
        gd.setSortDirection(1);
        gdArray[0] = gd;
        gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[1] + "_ALIAS\"]");
        gd.setSortDirection(1);
        gdArray[1] = gd;
        gd = new GroupDefinition();
        gd.setKeyExpression("row[\"" + COLS[2] + "_ALIAS\"]");
        gd.setSortDirection(1);
        gdArray[2] = gd;
        int i2 = 0;
        while (i2 < gdArray.length) {
            queryDefn.addGroup((IGroupDefinition)gdArray[i2]);
            ++i2;
        }
        SortDefinition[] sdArray = new SortDefinition[3];
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[0] + "_ALIAS\"]");
        sd.setSortDirection(1);
        sdArray[0] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[1] + "_ALIAS\"]");
        sd.setSortDirection(1);
        sdArray[1] = sd;
        sd = new SortDefinition();
        sd.setExpression("row[\"" + COLS[2] + "_ALIAS\"]");
        sd.setSortDirection(1);
        sdArray[2] = sd;
        int i3 = 0;
        while (i3 < sdArray.length) {
            queryDefn.addSort(sdArray[i3]);
            ++i3;
        }
        i3 = 0;
        while (i3 < COLS.length - 1) {
            sd = new SortDefinition();
            sd.setColumn("dataSetRow[\"" + COLS[i3] + "\"]");
            sd.setSortDirection(1);
            this.dataSet.addSortHint((ISortDefinition)sd);
            ++i3;
        }
        List resultSetHints = this.dataSet.getResultSetHints();
        int j = 0;
        while (j < COLS.length) {
            ColumnDefinition cdefn = new ColumnDefinition(COLS[j]);
            cdefn.setAlias(COLS[j] + "_ALIAS");
            resultSetHints.add(cdefn);
            ++j;
        }
        this.executeAndCheck(queryDefn);
    }

    private void executeAndCheck(QueryDefinition queryDefn) {
        try {
            IResultIterator ri = this.executeQuery((IQueryDefinition)queryDefn);
            while (ri.next()) {
                int i = 0;
                while (i < COLS.length) {
                    Object ob = ri.getValue(COLS[i]);
                    if (ob == null) {
                        this.testPrint("null");
                    } else {
                        this.testPrint(ob.toString());
                    }
                    if (i < COLS.length - 1) {
                        this.testPrint(",");
                    } else {
                        this.testPrintln("");
                    }
                    ++i;
                }
            }
            ri.close();
            this.checkOutputFile();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

