/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.TOCTestCase;
import org.eclipse.birt.report.engine.toc.TOCView;

public class TOCViewTest
extends TOCTestCase {
    static final String TOC_NORMAL_GOLDEN = "<toc nodeId=\"/\">\t\t<toc nodeId=\"__TOC_0\" displayText=\"report header\"/>    \t<toc nodeId=\"__TOC_1\" displayText=\"table\">        <toc nodeId=\"__TOC_1_0\" displayText=\"group 1\">            <toc nodeId=\"__TOC_1_0_0\" displayText=\"detail 1\"/>            <toc nodeId=\"__TOC_1_0_1\" displayText=\"detail 2\"/>        </toc>        <toc nodeId=\"__TOC_1_1\" displayText=\"group 2\">            <toc nodeId=\"__TOC_1_1_0\" displayText=\"detail 3\"/>            <toc nodeId=\"__TOC_1_1_1\" displayText=\"detail 4\"/>        </toc>    </toc>\t\t<toc nodeId=\"__TOC_2\" displayText=\"\">\t\t\t<toc nodeId=\"__TOC_2_0\" displayText=\"chart 1\"/>\t\t\t<toc nodeId=\"__TOC_2_1\" displayText=\"chart 2\"/>\t\t</toc>\t\t</toc>";
    static final String TOC_WITH_FORMAT_GOLDEN = "<toc nodeId=\"/\">    <toc nodeId=\"__TOC_2\" displayText=\"chart 2\"/></toc>";
    static final String TOC_WITH_EMPTY_GROUP_GOLDEN = "<toc nodeId=\"/\">    <toc nodeId=\"__TOC_0\" displayText=\"report header\"/>    <toc nodeId=\"__TOC_1\" displayText=\"table\">        <toc nodeId=\"__TOC_1_0\" displayText=\"\">            <toc nodeId=\"__TOC_1_0_0\" displayText=\"header\"/>            <toc nodeId=\"__TOC_1_0_1\" displayText=\"\">                <toc nodeId=\"__TOC_1_0_1_0\" displayText=\"detail 1\"/>                <toc nodeId=\"__TOC_1_0_1_1\" displayText=\"detail 2\"/>            </toc>        </toc>    <toc nodeId=\"__TOC_1_1\" displayText=\"\">            <toc nodeId=\"__TOC_1_1_0\" displayText=\"header 2\"/>            <toc nodeId=\"__TOC_1_1_1\" displayText=\"\">                <toc nodeId=\"__TOC_1_1_1_0\" displayText=\"detail 3\"/>                <toc nodeId=\"__TOC_1_1_1_1\" displayText=\"detail 4\"/>            </toc>        </toc>    </toc></toc>";

    public void testTocFind() throws Exception {
        ITreeNode tree = this.createTocNormal();
        TOCView view = new TOCView(tree, null, ULocale.ENGLISH, TimeZone.getTimeZone((String)"GMT+08:00"), "html");
        this.checkTocNode(view, "/", null, 3);
        this.checkTocNode(view, "__TOC_0", "report header", 0);
        this.checkTocNode(view, "__TOC_1", "table", 2);
        this.checkTocNode(view, "__TOC_1_0", "group 1", 2);
        this.checkTocNode(view, "__TOC_1_0_0", "detail 1", 0);
        this.checkTocNode(view, "__TOC_1_0_1", "detail 2", 0);
        this.checkTocNode(view, "__TOC_1_1", "group 2", 2);
        this.checkTocNode(view, "__TOC_1_1_0", "detail 3", 0);
        this.checkTocNode(view, "__TOC_1_1_1", "detail 4", 0);
        this.checkTocNode(view, "__TOC_2_0", "chart 1", 0);
        this.checkTocNode(view, "__TOC_2_1", "chart 2", 0);
        TOCViewTest.assertTrue((view.findTOC("__TOC_0_0") == null ? 1 : 0) != 0);
        TOCViewTest.assertTrue((view.findTOC("__TOC_1_1_2") == null ? 1 : 0) != 0);
        TOCViewTest.assertTrue((view.findTOC("__TOC_1_1_1_0") == null ? 1 : 0) != 0);
        TOCViewTest.assertTrue((view.findTOC("__TOC_3") == null ? 1 : 0) != 0);
    }

    void checkTocNode(TOCView view, String id, String label, int children) {
        TOCNode node = view.findTOC(id);
        TOCViewTest.assertEquals((String)id, (String)node.getNodeID());
        TOCViewTest.assertEquals((String)label, (String)node.getDisplayString());
        TOCViewTest.assertEquals((int)children, (int)node.getChildren().size());
    }

    public void testTocViewNormal() throws EngineException, IOException {
        ITreeNode tree = this.createTocNormal();
        System.out.println(this.toString(tree));
        TOCView view = new TOCView(tree, null, ULocale.ENGLISH, TimeZone.getTimeZone((String)"GMT+08:00"), "html");
        String output = this.toString(view.getRoot());
        System.out.println(output);
        TOCViewTest.assertEquals((String)TOC_NORMAL_GOLDEN.replaceAll("\\s", ""), (String)output.replaceAll("\\s", ""));
    }

    protected ITreeNode createTocNormal() {
        TOCBuilder builder = new TOCBuilder();
        this.createEntry(builder, null, "report header");
        TOCEntry table = this.startEntry(builder, null, "table");
        TOCEntry group1 = this.startEntry(builder, table, "group 1");
        this.createEntry(builder, group1, "detail 1");
        this.createEntry(builder, group1, "detail 2");
        this.closeEntry(builder, group1);
        TOCEntry group2 = this.startEntry(builder, table, "group 2");
        this.createEntry(builder, group2, "detail 3");
        this.createEntry(builder, group2, "detail 4");
        this.closeEntry(builder, group2);
        TOCEntry dummyGird = this.startDummyEntry(builder, null, "pdf");
        this.createEntry(builder, dummyGird, "chart 1");
        this.createEntry(builder, dummyGird, "chart 2");
        this.closeEntry(builder, dummyGird);
        return builder.getTOCTree();
    }

    public void testTocViewWithFormat() throws EngineException, IOException {
        ITreeNode tree = this.createTocWithFormat();
        System.out.println(this.toString(tree));
        TOCView view = new TOCView(tree, null, ULocale.ENGLISH, TimeZone.getTimeZone((String)"GMT+08:00"), "html");
        String output = this.toString(view.getRoot());
        System.out.println(output);
        TOCViewTest.assertEquals((String)TOC_WITH_FORMAT_GOLDEN.replaceAll("\\s", ""), (String)output.replaceAll("\\s", ""));
    }

    protected ITreeNode createTocWithFormat() {
        TOCBuilder builder = new TOCBuilder();
        TOCEntry dummyGird = this.startDummyEntry(builder, null, "html");
        this.createEntry(builder, dummyGird, "chart 1");
        this.createEntry(builder, dummyGird, "chart 2");
        this.closeEntry(builder, dummyGird);
        this.createEntry(builder, null, "chart 1", "pdf,html");
        this.createEntry(builder, null, "chart 2", "pdf");
        return builder.getTOCTree();
    }

    public void testTocViewWithEmptyGorup() throws EngineException, IOException {
        ITreeNode tree = this.createTocWithEmptyGroup();
        System.out.println(this.toString(tree));
        TOCView view = new TOCView(tree, null, ULocale.ENGLISH, TimeZone.getTimeZone((String)"GMT+08:00"), "html");
        String output = this.toString(view.getRoot());
        System.out.println(output);
        TOCViewTest.assertEquals((String)TOC_WITH_EMPTY_GROUP_GOLDEN.replaceAll("\\s", ""), (String)output.replaceAll("\\s", ""));
    }

    protected ITreeNode createTocWithEmptyGroup() {
        TOCBuilder builder = new TOCBuilder();
        this.createEntry(builder, null, "report header");
        TOCEntry table = this.startEntry(builder, null, "table");
        TOCEntry group1 = this.startGroupEntry(builder, table, null);
        this.createEntry(builder, group1, "header");
        TOCEntry group = this.startGroupEntry(builder, group1, null);
        this.createEntry(builder, group, "detail 1");
        this.createEntry(builder, group, "detail 2");
        this.closeEntry(builder, group);
        this.closeEntry(builder, group1);
        TOCEntry group2 = this.startGroupEntry(builder, table, null);
        this.createEntry(builder, group2, "header 2");
        TOCEntry group3 = this.startGroupEntry(builder, group2, null);
        this.createEntry(builder, group3, "detail 3");
        this.createEntry(builder, group3, "detail 4");
        this.closeEntry(builder, group3);
        this.closeEntry(builder, group2);
        return builder.getTOCTree();
    }

    protected ITreeNode createToc() {
        TOCBuilder builder = new TOCBuilder();
        this.createEntry(builder, null, "report header");
        TOCEntry table = this.startEntry(builder, null, "table");
        TOCEntry group1 = this.startEntry(builder, table, "gropu 1");
        this.createEntry(builder, group1, "detail 1");
        this.createEntry(builder, group1, "detail 2");
        this.closeEntry(builder, group1);
        TOCEntry group2 = this.startEntry(builder, table, "group 2");
        this.createEntry(builder, group2, "detail 3");
        this.createEntry(builder, group2, "detail 4");
        this.closeEntry(builder, group2);
        TOCEntry hideTable = this.startEntry(builder, null, "table", "html");
        this.createEntry(builder, hideTable, "group 1");
        this.createEntry(builder, hideTable, "group 2");
        this.closeEntry(builder, hideTable);
        TOCEntry groupTable = this.startEntry(builder, null, "group table");
        TOCEntry group12 = this.startEntry(builder, groupTable, null);
        this.createEntry(builder, group12, "detail 1");
        this.createEntry(builder, group12, "detail 2");
        this.closeEntry(builder, group12);
        TOCEntry group22 = this.startEntry(builder, groupTable, null);
        this.createEntry(builder, group22, "detail 3");
        this.createEntry(builder, group22, "detail 4");
        this.closeEntry(builder, group22);
        this.closeEntry(builder, groupTable);
        TOCEntry dummyTable = this.startDummyEntry(builder, null, "pdf");
        TOCEntry group13 = this.startEntry(builder, dummyTable, "group 1");
        this.createEntry(builder, group13, "detail 1");
        this.createEntry(builder, group13, "detail 2");
        this.closeEntry(builder, group13);
        TOCEntry group23 = this.startEntry(builder, dummyTable, "group 2");
        this.createEntry(builder, group23, "detail 3");
        this.createEntry(builder, group23, "detail 4");
        this.closeEntry(builder, group23);
        this.closeEntry(builder, dummyTable);
        return builder.getTOCTree();
    }
}

