/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.bre;

import junit.framework.TestCase;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class BirtCompTest
extends TestCase {
    private Context cx;
    private Scriptable scope;

    @Before
    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        this.scope.put("org.eclipse.birt.core.script.functionservice.context.functionBean", this.scope, (Object)new IScriptFunctionContext(){

            public Object findProperty(String name) {
                return null;
            }
        });
        new CoreJavaScriptInitializer().initialize(this.cx, this.scope);
    }

    @After
    public void tearDown() {
        Context.exit();
    }

    @Test
    public void testAnyOf() {
        String script2 = "BirtComp.anyOf(100,100,\"ABC\", \"1999-11-10\",null);";
        String script3 = "BirtComp.anyOf(null,100,\"ABC\", \"1999-11-10\",null)";
        String script4 = "BirtComp.anyOf(\"ABC\",100,\"ABC\", \"1999-11-10\",null)";
        String script5 = "BirtComp.anyOf(new Date(99,10,10),100,\"ABC\", \"1999-11-10\",null)";
        String script6 = "BirtComp.anyOf(\"1999-11-10\",100,\"ABC\", \"1999-11-10\",null)";
        String script7 = "BirtComp.anyOf(20,100,\"ABC\", \"1999-11-10\",null)";
        String script8 = "array = new Array(3);array[0]=0;array[1]=1;array[2]=2;BirtComp.anyOf(1,array);";
        String script9 = "array = new Array(3);array[0]=0;array[1]=1;array[2]=2;BirtComp.anyOf(4,array);";
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script2, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script3, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script4, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script5, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script6, "inline", 1, null)));
        BirtCompTest.assertFalse((boolean)((Boolean)this.cx.evaluateString(this.scope, script7, "inline", 1, null)));
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script8, "inline", 1, null)));
        BirtCompTest.assertFalse((boolean)((Boolean)this.cx.evaluateString(this.scope, script9, "inline", 1, null)));
    }

    @Test
    public void testBetween() {
        String script1 = "BirtComp.between(\"1923-10-11\",new Date(10,11,11),new Date(33,11,11))";
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script1, "inline", 1, null)));
        String script2 = "BirtComp.between(100,101,102)";
        BirtCompTest.assertFalse((boolean)((Boolean)this.cx.evaluateString(this.scope, script2, "inline", 1, null)));
    }

    @Test
    public void testNotBetween() {
        String script1 = "BirtComp.notBetween(\"1923-10-11\",new Date(10,11,11),new Date(33,11,11))";
        BirtCompTest.assertFalse((boolean)((Boolean)this.cx.evaluateString(this.scope, script1, "inline", 1, null)));
        String script2 = "BirtComp.notBetween(100,101,102)";
        BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, script2, "inline", 1, null)));
    }

    @Test
    public void testCompare() {
        Object[][] tests = new Object[][]{{"BirtComp.equalTo(100,100);", true}, {"BirtComp.equalTo(null,null)", true}, {"BirtComp.equalTo(\"ABC\",\"ABC\")", true}, {"BirtComp.equalTo(new Date(99,10,10),\"1999-11-10\")", true}, {"BirtComp.equalTo(\"1999-11-10\",new Date(99,10,10))", true}, {"BirtComp.equalTo(20,100)", false}, {"BirtComp.equalTo( new java.sql.Time(10,10,10), \"10:10:10.000\")", true}, {"BirtComp.equalTo( new java.sql.Date(80,9,9), \"1980-10-9 12:14:25\")", true}, {"BirtComp.notEqual(100,100);", false}, {"BirtComp.notEqual(null,null)", false}, {"BirtComp.notEqual(\"ABC\",\"ABC\")", false}, {"BirtComp.notEqual(new Date(99,10,10),\"1999-11-10\")", false}, {"BirtComp.notEqual(\"1999-11-10\",new Date(99,10,10))", false}, {"BirtComp.notEqual(20,100)", true}, {"BirtComp.greaterThan(100,10);", true}, {"BirtComp.greaterThan(null,null)", false}, {"BirtComp.greaterThan(\"aBC\",\"ABC\")", true}, {"BirtComp.greaterThan(new Date(99,9,10),\"1999-11-10\")", false}, {"BirtComp.greaterThan(\"1999-11-10\",new Date(99,9,10))", true}, {"BirtComp.greaterThan(20,100)", false}, {"BirtComp.greaterOrEqual(100,10);", true}, {"BirtComp.greaterOrEqual(null,null)", true}, {"BirtComp.greaterOrEqual(\"aBC\",\"ABC\")", true}, {"BirtComp.greaterOrEqual(new Date(99,9,10),\"1999-11-10\")", false}, {"BirtComp.greaterOrEqual(\"1999-11-10\",new Date(99,9,10))", true}, {"BirtComp.greaterOrEqual(20,100)", false}, {"BirtComp.lessThan(10,100);", true}, {"BirtComp.lessThan(null,null)", false}, {"BirtComp.lessThan(\"aBC\",\"ABC\")", false}, {"BirtComp.lessThan(new Date(99,9,10),\"1999-11-10\")", true}, {"BirtComp.lessThan(\"1999-11-10\",new Date(99,9,10))", false}, {"BirtComp.lessThan(20,100)", true}, {"BirtComp.lessOrEqual(100,10);", false}, {"BirtComp.lessOrEqual(null,null)", true}, {"BirtComp.lessOrEqual(\"aBC\",\"ABC\")", false}, {"BirtComp.lessOrEqual(new Date(99,9,10),\"1999-11-10\")", true}, {"BirtComp.lessOrEqual(\"1999-11-10\",new Date(99,9,10))", false}, {"BirtComp.lessOrEqual(100,100)", true}};
        int i = 0;
        while (i < tests.length) {
            BirtCompTest.assertTrue((boolean)((Boolean)this.cx.evaluateString(this.scope, (String)tests[i][0], "inline", 1, null)).equals((Boolean)tests[i][1]));
            ++i;
        }
    }

    @Test
    public void testMatch() {
        String[] script = new String[]{"BirtComp.match(\"x 99:02:03\",\".*[0-9]*:[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99::03\",\".*[0-9]*:[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99:02:03\",\"x [0-9]*:[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99:02:03\",\".*99*:[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99:02:03\",\".*[0-9]*.[0-9]*:[0-9]*\");", "BirtComp.match(\"x 99:02:03\",\".*[0-9]*:[0-9]*:[0-9]*3.\");"};
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        boolean[] result = blArray;
        int i = 0;
        while (i < script.length) {
            BirtCompTest.assertTrue(((Boolean)this.cx.evaluateString(this.scope, script[i], "inline", 1, null) == result[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testLike() {
        String[] script = new String[]{"BirtComp.like(\"x 99:02:03\",\"%:0_:03\");", "BirtComp.like(\"x 99::003\",\"%9_::__3\");", "BirtComp.like(\"x 99:02:03\",\"%99:02_03\");", "BirtComp.like(\"x 99:02:03\",\"x 99%0_\");", "BirtComp.like(\"x 99:02:03\",\"_ 99%03\");", "BirtComp.like(\"x 99:02:03\",\"%:0_:__3\");", "BirtComp.like(\"x 99:02:03\",\"%:0\\\\_03\");", "BirtComp.like(\"x 99:02_03\",\"%:0\\\\_03\");", "BirtComp.like(\"x 99:02_03\",\"%:02\\\\_03\");", "BirtComp.like(\"x 99:02_03\",\"\\\\%:02\\\\_03\");", "BirtComp.like(\"x 99%:02_03\",\"%\\\\%:02\\\\_03\");", "BirtComp.like(\"x 99%:02_03\",\"\\\\\\\\%\\\\%:02\\\\_03\");", "BirtComp.like(\"x \\\\99%:02_03\",\"_ \\\\\\\\99\\\\%:02\\\\_03\");", "BirtComp.like(\"ABC\",\"%AB%\");", "BirtComp.like(\"ABC\",\"%Ab%\");", "BirtComp.like(\"ABC\",\"%Ab%\",true);", "BirtComp.like(\"AB\\r\\nC\",\"%AB%\");"};
        boolean[] blArray = new boolean[17];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[8] = true;
        blArray[10] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[15] = true;
        blArray[16] = true;
        boolean[] result = blArray;
        int i = 0;
        while (i < script.length) {
            BirtCompTest.assertEquals((boolean)result[i], (boolean)((Boolean)this.cx.evaluateString(this.scope, script[i], "inline", 1, null)));
            ++i;
        }
    }

    @Test
    public void testNotLike() {
        String[] script = new String[]{"BirtComp.notLike(\"x 99:02:03\",\"%:0_:03\");", "BirtComp.notLike(\"x 99::003\",\"%9_::__3\");", "BirtComp.notLike(\"x 99:02:03\",\"%99:02_03\");", "BirtComp.notLike(\"x 99:02:03\",\"x 99%0_\");", "BirtComp.notLike(\"x 99:02:03\",\"_ 99%03\");", "BirtComp.notLike(\"x 99:02:03\",\"%:0_:__3\");", "BirtComp.notLike(\"x 99:02:03\",\"%:0\\\\_03\");", "BirtComp.notLike(\"x 99:02_03\",\"%:0\\\\_03\");", "BirtComp.notLike(\"x 99:02_03\",\"%:02\\\\_03\");", "BirtComp.notLike(\"x 99:02_03\",\"\\\\%:02\\\\_03\");", "BirtComp.notLike(\"x 99%:02_03\",\"%\\\\%:02\\\\_03\");", "BirtComp.notLike(\"x 99%:02_03\",\"\\\\\\\\%\\\\%:02\\\\_03\");", "BirtComp.notLike(\"x \\\\99%:02_03\",\"_ \\\\\\\\99\\\\%:02\\\\_03\");"};
        boolean[] blArray = new boolean[13];
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[9] = true;
        blArray[11] = true;
        boolean[] result = blArray;
        int i = 0;
        while (i < script.length) {
            BirtCompTest.assertEquals((boolean)result[i], (boolean)((Boolean)this.cx.evaluateString(this.scope, script[i], "inline", 1, null)));
            ++i;
        }
    }

    @Test
    public void testCompareString() {
        String[] script = new String[]{"BirtComp.compareString(null,null)", "BirtComp.compareString(null,\"abc\")", "BirtComp.compareString(\"abc\",null);", "BirtComp.compareString(\"ABC\",\"ABC\")", "BirtComp.compareString(\"abc\",\"ABC\")", "BirtComp.compareString(\"ABC\",\"DEF\")", "BirtComp.compareString(\"abc\",\"ABC\",true)", "BirtComp.compareString(\"abc \",\"ABC\",true)", "BirtComp.compareString(\"abc \",\"ABC\",true,true)", "BirtComp.compareString(\"abc \",\"ABC\",false,true)"};
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[3] = true;
        blArray[6] = true;
        blArray[8] = true;
        boolean[] result = blArray;
        int i = 0;
        while (i < script.length) {
            BirtCompTest.assertTrue(((Boolean)this.cx.evaluateString(this.scope, script[i], "inline", 1, null) == result[i] ? 1 : 0) != 0);
            System.out.println(i);
            ++i;
        }
    }
}

