/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class InputStreamRefreshTest
extends TestCase {
    static final String ARCHIVE_NAME = "./utest/test.archive";
    static final String STREAM_NAME = "/teststream";

    @Before
    public void setUp() {
        ArchiveUtil.deleteAllFiles((File)new File(ARCHIVE_NAME));
    }

    @After
    public void tearDown() {
        ArchiveUtil.deleteAllFiles((File)new File(ARCHIVE_NAME));
    }

    @Test
    public void testReaderDuringWriter() throws Exception {
        ArchiveFile archive = new ArchiveFile(ARCHIVE_NAME, "rw");
        ArchiveWriter writer = new ArchiveWriter((IArchiveFile)archive);
        writer.initialize();
        ArchiveReader reader = new ArchiveReader((IArchiveFile)archive);
        reader.open();
        RAOutputStream ws = writer.createRandomAccessStream(STREAM_NAME);
        ws.writeInt(1);
        ws.flush();
        RAInputStream rs = reader.getStream(STREAM_NAME);
        InputStreamRefreshTest.assertEquals((int)1, (int)rs.readInt());
        ws.seek(0L);
        ws.writeLong(2L);
        ws.flush();
        rs.refresh();
        rs.seek(0L);
        InputStreamRefreshTest.assertEquals((long)2L, (long)rs.readLong());
        rs.close();
        ws.close();
        reader.close();
        writer.finish();
        archive.close();
    }
}

