/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.io.UnsupportedEncodingException;
import org.eclipse.birt.report.designer.core.commands.CmdBaseTestCase;
import org.eclipse.birt.report.designer.core.commands.PasteStructureCommand;
import org.eclipse.birt.report.designer.core.model.views.outline.EmbeddedImageNode;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public class PasteStructureCommandTest
extends CmdBaseTestCase {
    private static final String testImageName = "Test Image";
    private EmbeddedImage embeddedImg = null;

    @Override
    protected void tearDown() throws SemanticException {
        super.tearDown();
        this.embeddedImg = null;
    }

    private void createEmbeddedImage() {
        this.embeddedImg = new EmbeddedImage(testImageName);
        try {
            this.embeddedImg.setData("data".getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            PasteStructureCommandTest.fail((String)"embeddedImg.setData failed");
        }
    }

    public void testPasteStructure() {
        EmbeddedImageNode embeddedImgNode = new EmbeddedImageNode((ModuleHandle)this.getReportDesignHandle());
        this.createEmbeddedImage();
        PasteStructureCommand pasteStrucCmd = new PasteStructureCommand((IStructure)this.embeddedImg, (Object)embeddedImgNode);
        PasteStructureCommandTest.assertTrue((boolean)pasteStrucCmd.canExecute());
        pasteStrucCmd.execute();
        EmbeddedImage find = this.getReportDesignHandle().findImage(testImageName);
        PasteStructureCommandTest.assertNotNull((Object)find);
    }

    public void testPasteStructure2() {
        this.createEmbeddedImage();
        PasteStructureCommand pasteStrucCmd = new PasteStructureCommand((IStructure)this.embeddedImg, (Object)this.getReportDesignHandle());
        PasteStructureCommandTest.assertTrue((boolean)pasteStrucCmd.canExecute());
        pasteStrucCmd.execute();
        EmbeddedImage find = this.getReportDesignHandle().findImage(testImageName);
        PasteStructureCommandTest.assertNotNull((Object)find);
    }
}

