/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.JoinConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.JoinCondition;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class JointDataSetParseTest
extends BaseTestCase {
    String inputFileName = "JointDataSetParseTest.xml";
    String goldenFileName = "JointDataSetParseTest_golden.xml";
    String validationInputFileName = "JointDataSetParseTest_validation.xml";
    String semanticCheckFileName = "JointDataSetParseTest_semantic.xml";

    public void testParser() throws DesignFileException {
        this.openDesign(this.inputFileName);
        JointDataSetHandle dataSet = this.designHandle.findJointDataSet("JointDataSet");
        JointDataSetParseTest.assertNotNull((Object)dataSet);
        JointDataSetParseTest.assertEquals((int)0, (int)dataSet.getRowFetchLimit());
        JointDataSetParseTest.assertTrue((boolean)dataSet.needsCache());
        List dataSets = dataSet.getElement().getListProperty((Module)this.design, "dataSets");
        JointDataSetParseTest.assertEquals((int)2, (int)dataSets.size());
        DataSetHandle ds1 = this.designHandle.findDataSet("DataSet1");
        JointDataSetParseTest.assertSame((Object)ds1.getElement(), (Object)((ElementRefValue)dataSets.get(0)).getElement());
        JointDataSetParseTest.assertEquals((int)30, (int)ds1.getRowFetchLimit());
        JointDataSetParseTest.assertTrue((boolean)ds1.needsCache());
        DataSetHandle ds2 = this.designHandle.findDataSet("DataSet2");
        JointDataSetParseTest.assertEquals((int)0, (int)ds2.getRowFetchLimit());
        JointDataSetParseTest.assertSame((Object)ds2.getElement(), (Object)((ElementRefValue)dataSets.get(1)).getElement());
        Iterator dataSetIter = dataSet.dataSetsIterator();
        JointDataSetParseTest.assertEquals((Object)ds1, dataSetIter.next());
        JointDataSetParseTest.assertEquals((Object)ds2, dataSetIter.next());
        JointDataSetParseTest.assertFalse((boolean)dataSetIter.hasNext());
        Iterator joinConditionsIterator = dataSet.joinConditionsIterator();
        JointDataSetParseTest.assertTrue((boolean)joinConditionsIterator.hasNext());
        JoinConditionHandle joinConditionHandle = (JoinConditionHandle)joinConditionsIterator.next();
        JointDataSetParseTest.assertFalse((boolean)joinConditionsIterator.hasNext());
        JointDataSetParseTest.assertEquals((String)"inner", (String)joinConditionHandle.getJoinType());
        JointDataSetParseTest.assertEquals((String)"eq", (String)joinConditionHandle.getOperator());
        JointDataSetParseTest.assertEquals((String)"DataSet1", (String)joinConditionHandle.getLeftDataSet());
        JointDataSetParseTest.assertEquals((String)"DataSet2", (String)joinConditionHandle.getRightDataSet());
        JointDataSetParseTest.assertEquals((String)"leftExpression", (String)joinConditionHandle.getLeftExpression());
        JointDataSetParseTest.assertEquals((String)"rightExpression", (String)joinConditionHandle.getRightExpression());
        TableHandle table = (TableHandle)this.designHandle.findElement("table1");
        JointDataSetParseTest.assertEquals((String)"JointDataSet", (String)table.getDataSet().getName());
        List parameters = (List)dataSet.getProperty("parameters");
        JointDataSetParseTest.assertEquals((int)1, (int)parameters.size());
        DataSetParameter parameter = (DataSetParameter)parameters.get(0);
        JointDataSetParseTest.assertEquals((int)1, (int)parameter.getPosition());
        JointDataSetParseTest.assertEquals((String)"name", (String)parameter.getName());
        JointDataSetParseTest.assertEquals((String)"string", (String)parameter.getDataType());
        JointDataSetParseTest.assertTrue((boolean)parameter.isOptional());
        JointDataSetParseTest.assertEquals((String)"default value 1", (String)parameter.getDefaultValue());
        JointDataSetParseTest.assertEquals((boolean)true, (boolean)parameter.allowNull());
        List columns = (List)dataSet.getProperty("resultSet");
        JointDataSetParseTest.assertEquals((int)1, (int)columns.size());
        ResultSetColumn column = (ResultSetColumn)columns.get(0);
        JointDataSetParseTest.assertEquals((int)1, (int)column.getPosition());
        JointDataSetParseTest.assertEquals((String)"name", (String)column.getColumnName());
        JointDataSetParseTest.assertEquals((String)"string", (String)column.getDataType());
        columns = (List)dataSet.getProperty("computedColumns");
        JointDataSetParseTest.assertEquals((int)1, (int)columns.size());
        ComputedColumn computedColumn = (ComputedColumn)columns.get(0);
        JointDataSetParseTest.assertEquals((String)"column1", (String)computedColumn.getColumnName());
        JointDataSetParseTest.assertEquals((String)"expression1", (String)computedColumn.getExpression());
        JointDataSetParseTest.assertEquals((String)"integer", (String)computedColumn.getDataType());
        List columnHints = (List)dataSet.getProperty("columnHints");
        JointDataSetParseTest.assertEquals((int)1, (int)columnHints.size());
        ColumnHint columnHint = (ColumnHint)columnHints.get(0);
        PropertyDefn member = (PropertyDefn)columnHint.getDefn().getMember("columnName");
        JointDataSetParseTest.assertEquals((Object)"username", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("alias");
        JointDataSetParseTest.assertEquals((Object)"userid", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("searching");
        JointDataSetParseTest.assertEquals((Object)"none", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("export");
        JointDataSetParseTest.assertEquals((Object)"always", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("analysis");
        JointDataSetParseTest.assertEquals((Object)"dimension", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("parentLevel");
        JointDataSetParseTest.assertEquals((Object)"4", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("format");
        JointDataSetParseTest.assertEquals((Object)"##.###", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("displayNameID");
        JointDataSetParseTest.assertEquals((Object)"message.column-hint.username", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("displayName");
        JointDataSetParseTest.assertEquals((Object)"User Name", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("helpTextID");
        JointDataSetParseTest.assertEquals((Object)"message.column-hint.help", (Object)columnHint.getProperty((Module)this.design, member));
        member = (PropertyDefn)columnHint.getDefn().getMember("helpText");
        JointDataSetParseTest.assertEquals((Object)"Help me!", (Object)columnHint.getProperty((Module)this.design, member));
        ArrayList filters = (ArrayList)dataSet.getProperty("filter");
        JointDataSetParseTest.assertEquals((int)1, (int)filters.size());
        JointDataSetParseTest.assertEquals((String)"lt", (String)((FilterCondition)filters.get(0)).getOperator());
        JointDataSetParseTest.assertEquals((String)"filter expression", (String)((FilterCondition)filters.get(0)).getExpr());
        JointDataSetParseTest.assertEquals((String)"value1 expression", (String)((FilterCondition)filters.get(0)).getValue1());
        JointDataSetParseTest.assertEquals((String)"value2 expression", (String)((FilterCondition)filters.get(0)).getValue2());
    }

    public void testWriter() throws Exception {
        this.openDesign(this.inputFileName);
        JointDataSetHandle dataSet = this.designHandle.findJointDataSet("JointDataSet");
        JointDataSetParseTest.assertNotNull((Object)dataSet);
        dataSet.setRowFetchLimit(10);
        DataSetHandle ds1 = this.designHandle.findDataSet("DataSet1");
        ds1.setRowFetchLimit(50);
        ds1.setNeedsCache(false);
        DataSetHandle ds2 = this.designHandle.findDataSet("DataSet2");
        ds2.setRowFetchLimit(20);
        dataSet.addDataSet("DataSet3");
        JoinCondition condition = StructureFactory.createJoinCondition();
        condition.setJoinType("left-out");
        condition.setOperator("eq");
        condition.setLeftDataSet("DataSet2");
        condition.setRightDataSet("DataSet3");
        condition.setLeftExpression("leftExpression");
        condition.setRightExpression("rightExpression");
        PropertyHandle conditionHandle = dataSet.getPropertyHandle("joinConditions");
        conditionHandle.addItem((IStructure)condition);
        this.save();
        JointDataSetParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testValidation() throws Exception {
        this.openDesign(this.validationInputFileName);
        List errors = this.designHandle.getErrorList();
        JointDataSetParseTest.assertEquals((int)6, (int)errors.size());
        this.assertHasError((ErrorDetail)errors.get(0), "JointDataSet1");
        this.assertHasError((ErrorDetail)errors.get(1), "JointDataSet2");
        this.assertHasError((ErrorDetail)errors.get(2), "JointDataSet3");
        this.assertHasError((ErrorDetail)errors.get(3), "JointDataSet4");
        this.assertHasError((ErrorDetail)errors.get(4), "JointDataSet5");
        this.assertHasError((ErrorDetail)errors.get(5), "JointDataSet6");
    }

    public void testSemanticCheck() throws DesignFileException {
        this.openDesign(this.semanticCheckFileName);
        List errors = this.design.getErrorList();
        JointDataSetParseTest.assertEquals((int)1, (int)errors.size());
        ErrorDetail error = (ErrorDetail)errors.get(0);
        JointDataSetParseTest.assertEquals((String)"Error.SemanticError.INVALID_ELEMENT_REF", (String)error.getErrorCode());
        JointDataSetParseTest.assertEquals((String)"JointDataSet", (String)error.getElement().getName());
    }

    private void assertHasError(ErrorDetail errorDetail, String dataSetName) {
        JointDataSetParseTest.assertTrue(("Error.PropertyValueException.VALUE_REQUIRED".equals(errorDetail.getErrorCode()) && errorDetail.getElement() instanceof JointDataSet && dataSetName.equals(errorDetail.getElement().getName()) ? 1 : 0) != 0);
    }
}

