/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibrarySharedResultSetTest
extends BaseTestCase {
    public void testCannotExtends() throws Exception {
        this.openDesign("BlankDesign.xml");
        this.designHandle.includeLibrary("SharedResultSetLibrary.xml", "lib1");
        this.libraryHandle = this.designHandle.getLibrary("lib1");
        LibrarySharedResultSetTest.assertTrue((boolean)this.libraryHandle.isValid());
        TableHandle table2 = (TableHandle)this.libraryHandle.findElement("table2");
        LibrarySharedResultSetTest.assertEquals((int)2, (int)table2.getDataBindingType());
        try {
            this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)table2, "newTable2");
            LibrarySharedResultSetTest.fail();
        }
        catch (ExtendsException e) {
            LibrarySharedResultSetTest.assertEquals((String)"Error.ExtendsForbiddenException.RESULT_SET_SHARED_CANT_EXTEND", (String)e.getErrorCode());
        }
        DesignElementHandle grid = this.libraryHandle.findElement("NewGrid");
        try {
            this.designHandle.getElementFactory().newElementFrom(grid, "newGrid");
            LibrarySharedResultSetTest.fail();
        }
        catch (ExtendsException e) {
            LibrarySharedResultSetTest.assertEquals((String)"Error.ExtendsForbiddenException.RESULT_SET_SHARED_CANT_EXTEND", (String)e.getErrorCode());
        }
    }
}

