/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.tests.engine.BaseEmitter;

public class IElementTest
extends BaseEmitter {
    private String report = "IElementTest.rptdesign";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.report, this.report);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    public void testParent() {
        IContainerContent element = new ReportContent().createContainerContent();
        IContainerContent parent = new ReportContent().createContainerContent();
        element.setParent((IElement)parent);
        IElementTest.assertEquals((Object)parent, (Object)element.getParent());
        element.setParent(null);
        IElementTest.assertNull((Object)element.getParent());
    }

    public void testIElement() throws EngineException {
        this.runandrender_emitter("html", false);
    }

    @Override
    public void endContainer(IContainerContent container) {
        System.out.println(container);
    }

    @Override
    public void endCell(ICellContent cell) {
        IElementTest.assertTrue((boolean)(cell.getParent() instanceof IRowContent));
    }

    @Override
    public void endRow(IRowContent row) {
        IElementTest.assertTrue((boolean)(row.getParent() instanceof ITableContent));
    }

    @Override
    protected String getReportName() {
        return this.report;
    }
}

