/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.script;

import java.text.ParseException;
import java.util.Iterator;
import org.eclipse.birt.report.engine.javascript.JavascriptVersion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;

public class ScriptValidator {
    private final ISourceViewer scriptViewer;

    public ScriptValidator(ISourceViewer viewer) {
        this.scriptViewer = viewer;
        this.init();
    }

    public void init() {
        this.clearAnnotations();
    }

    /*
     * Unable to fully structure code
     */
    public void validate(boolean isFunctionBody, boolean isErrorSelected) throws ParseException {
        block10: {
            block11: {
                if (this.scriptViewer == null) {
                    return;
                }
                this.clearAnnotations();
                textField = this.scriptViewer.getTextWidget();
                if (textField == null || !textField.isEnabled()) {
                    return;
                }
                functionTag = "function(){";
                document = this.scriptViewer.getDocument();
                text = document == null ? null : this.scriptViewer.getDocument().get();
                script = text;
                if (isFunctionBody) {
                    script = functionTag + (String)script + "\n}";
                }
                try {
                    this.validateScript((String)script);
                    break block10;
                }
                catch (ParseException e) {
                    offset = e.getErrorOffset();
                    if (!isFunctionBody) break block11;
                    offset -= functionTag.length();
                    ** while (offset >= text.length())
                }
lbl-1000:
                // 1 sources

                {
                    --offset;
                    continue;
                }
            }
            errorMessage = e.getLocalizedMessage();
            position = this.getErrorPosition(text, offset);
            if (position != null) {
                annotationModel = this.scriptViewer.getAnnotationModel();
                if (annotationModel != null) {
                    annotationModel.addAnnotation(new Annotation("org.eclipse.ui.workbench.texteditor.error", true, errorMessage), position);
                }
                if (isErrorSelected) {
                    if (this.scriptViewer instanceof SourceViewer) {
                        ((SourceViewer)this.scriptViewer).setSelection((ISelection)new TextSelection(position.getOffset(), position.getLength()));
                    }
                    this.scriptViewer.revealRange(position.getOffset(), position.getLength());
                }
            }
            throw new ParseException(e.getLocalizedMessage(), position.offset);
        }
    }

    private void clearAnnotations() {
        IAnnotationModel annotationModel = this.scriptViewer.getAnnotationModel();
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (annotation == null || !"org.eclipse.ui.workbench.texteditor.error".equals(annotation.getType())) continue;
                annotationModel.removeAnnotation(annotation);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void validateScript(String script) throws ParseException {
        block4: {
            block5: {
                if (script == null) {
                    return;
                }
                compilerEnv = new CompilerEnvirons();
                compilerEnv.setLanguageVersion(new JavascriptVersion().getECMAScriptVersion());
                jsParser = new Parser(compilerEnv, compilerEnv.getErrorReporter());
                try {
                    jsParser.parse(script, null, 0);
                    break block4;
                }
                catch (EvaluatorException e) {
                    offset = -1;
                    if (this.scriptViewer == null) break block5;
                    lines = script.split("\n");
                    i = 0;
                    ** while (i < e.lineNumber())
                }
lbl-1000:
                // 1 sources

                {
                    offset += lines[i].length() + 1;
                    ++i;
                    continue;
                }
lbl19:
                // 1 sources

                offset += e.columnNumber();
            }
            throw new ParseException(e.getLocalizedMessage(), offset);
        }
    }

    protected Position getErrorPosition(String script, int offset) {
        int end = offset;
        while (end >= script.length() || end >= 0 && Character.isWhitespace(script.charAt(end)) || this.isCommentLine(script, end)) {
            --end;
        }
        int start = end;
        while (start >= 0 && !Character.isWhitespace(script.charAt(start)) && !Character.isJavaIdentifierPart(script.charAt(start))) {
            --start;
        }
        return new Position(start + 1, end - start);
    }

    private boolean isCommentLine(String script, int index) {
        int start = index;
        while (start >= 0 && script.charAt(start) != '\n') {
            if (start + 1 < script.length() && script.charAt(start) == '/' && script.charAt(start + 1) == '/') {
                return true;
            }
            --start;
        }
        return false;
    }
}

