/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.extension;

import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.AggregationDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.ShowSummaryFieldDialog;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class SwitchCellInfo {
    public static final int UNKNOWN = 0;
    public static final int GRAND_TOTAL = 1;
    public static final int SUB_TOTAL = 2;
    public static final int MEASURE = 3;
    private int type;
    private boolean isNew = false;
    private CrosstabReportItemHandle crosstab;
    private AggregationCellHandle cell;
    private GrandTotalInfo grandTotal;
    private SubTotalInfo subTotal;
    private MeasureInfo measureInfo;

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public SwitchCellInfo(CrosstabReportItemHandle crosstab, int type) {
        this.crosstab = crosstab;
        this.type = type;
    }

    public CrosstabReportItemHandle getCrosstab() {
        return this.crosstab;
    }

    public GrandTotalInfo getGrandTotalInfo() {
        return this.grandTotal;
    }

    public SubTotalInfo getSubTotalInfo() {
        return this.subTotal;
    }

    public MeasureInfo getMeasureInfo() {
        return this.measureInfo;
    }

    public AggregationCellHandle getAggregationCell() {
        if (this.cell != null) {
            return this.cell;
        }
        switch (this.type) {
            case 1: {
                this.cell = this.getCellFromGrandTotal();
                break;
            }
            case 2: {
                this.cell = this.getCellFromSubTotal();
                break;
            }
            case 3: {
                this.cell = this.getCellFromMeasure();
            }
        }
        return this.cell;
    }

    public String getExpectedView() {
        String view = "";
        switch (this.type) {
            case 1: {
                view = this.grandTotal.expectedView;
                break;
            }
            case 2: {
                view = this.subTotal.expectedView;
                break;
            }
            case 3: {
                view = this.measureInfo.expectedView;
            }
        }
        return view;
    }

    private AggregationCellHandle getCellFromMeasure() {
        AggregationCellHandle cell = null;
        if (this.measureInfo == null) {
            return cell;
        }
        MeasureViewHandle measureView = this.crosstab.getMeasure(this.measureInfo.getMeasureName());
        if (measureView == null) {
            return cell;
        }
        cell = measureView.getCell();
        return cell;
    }

    private AggregationCellHandle getCellFromSubTotal() {
        AggregationCellHandle cell = null;
        if (this.subTotal == null) {
            return cell;
        }
        LevelHandle level = this.subTotal.level;
        if (level == null) {
            return cell;
        }
        MeasureViewHandle measureView = this.crosstab.getMeasure(this.subTotal.getMeasureName());
        LevelViewHandle levelView = this.findLevelViewHandle(level);
        if (measureView == null || levelView == null) {
            return cell;
        }
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        int axisType = levelView.getAxisType();
        int counterAxisType = CrosstabUtil.getOppositeAxisType((int)levelView.getAxisType());
        DimensionViewHandle counterDimension = this.crosstab.getDimension(counterAxisType, this.crosstab.getDimensionCount(counterAxisType) - 1);
        String counterDimensionName = null;
        String counterLevelName = null;
        if (counterDimension != null) {
            counterDimensionName = counterDimension.getCubeDimensionName();
            counterLevelName = counterDimension.getLevel(counterDimension.getLevelCount() - 1).getCubeLevelName();
        }
        String dimensionName = ((DimensionViewHandle)levelView.getContainer()).getCubeDimensionName();
        String levelName = levelView.getCubeLevelName();
        if (levelName == null || dimensionName == null) {
            return cell;
        }
        if (axisType == 0) {
            rowDimension = dimensionName;
            rowLevel = levelName;
            colDimension = counterDimensionName;
            colLevel = counterLevelName;
        } else if (axisType == 1) {
            colDimension = dimensionName;
            colLevel = levelName;
            rowDimension = counterDimensionName;
            rowLevel = counterLevelName;
        }
        cell = measureView.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        return cell;
    }

    private AggregationCellHandle getCellFromGrandTotal() {
        AggregationCellHandle cell = null;
        if (this.grandTotal == null) {
            return cell;
        }
        MeasureViewHandle measureView = this.crosstab.getMeasure(this.grandTotal.getMeasureQualifiedName());
        if (measureView == null) {
            return cell;
        }
        int counterAxisType = CrosstabUtil.getOppositeAxisType((int)this.grandTotal.axis);
        DimensionViewHandle counterDimension = this.crosstab.getDimension(counterAxisType, this.crosstab.getDimensionCount(counterAxisType) - 1);
        String counterDimensionName = null;
        String counterLevelName = null;
        if (counterDimension != null) {
            counterDimensionName = counterDimension.getCubeDimensionName();
            counterLevelName = counterDimension.getLevel(counterDimension.getLevelCount() - 1).getCubeLevelName();
        }
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        if (this.grandTotal.axis == 0) {
            colDimension = counterDimensionName;
            colLevel = counterLevelName;
        } else if (this.grandTotal.axis == 1) {
            rowDimension = counterDimensionName;
            rowLevel = counterLevelName;
        }
        cell = measureView.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        return cell;
    }

    public void setGrandTotalInfo(AggregationDialog.GrandTotalInfo grandTotalIn, int axis) {
        this.grandTotal = new GrandTotalInfo(grandTotalIn, axis);
    }

    public void setSubTotalInfo(AggregationDialog.SubTotalInfo subTotalIn) {
        this.subTotal = new SubTotalInfo(subTotalIn);
    }

    public void setMeasureInfo(ShowSummaryFieldDialog.MeasureInfo measureInfoIn) {
        this.measureInfo = new MeasureInfo(measureInfoIn);
    }

    public void setMeasureInfo(boolean isShow, String measureName, String expectedName) {
        this.measureInfo = new MeasureInfo(isShow, measureName, expectedName);
    }

    public int getType() {
        return this.type;
    }

    private LevelViewHandle findLevelViewHandle(LevelHandle handle) {
        LevelViewHandle levelView;
        DimensionViewHandle tmpDimView;
        int dimCount = this.crosstab.getDimensionCount(0);
        int i = 0;
        while (i < dimCount) {
            tmpDimView = this.crosstab.getDimension(0, i);
            levelView = tmpDimView.getLevel(handle.getQualifiedName());
            if (levelView != null) {
                return levelView;
            }
            ++i;
        }
        dimCount = this.crosstab.getDimensionCount(1);
        i = 0;
        while (i < dimCount) {
            tmpDimView = this.crosstab.getDimension(1, i);
            levelView = tmpDimView.getLevel(handle.getQualifiedName());
            if (levelView != null) {
                return levelView;
            }
            ++i;
        }
        return null;
    }

    public static class GrandTotalInfo {
        private String expectedView = "";
        private String MeasureQualifiedName = "";
        private boolean aggregationOn = false;
        private String function = "";
        private boolean isAssociation = false;
        private int axis;

        public GrandTotalInfo(AggregationDialog.GrandTotalInfo grandTotalIn, int axis) {
            this.aggregationOn = grandTotalIn.isAggregationOn();
            this.function = grandTotalIn.getFunction();
            this.MeasureQualifiedName = grandTotalIn.getMeasureQualifiedName();
            this.isAssociation = grandTotalIn.isAssociation();
            this.expectedView = grandTotalIn.getExpectedView();
            this.axis = axis;
        }

        public String getMeasureQualifiedName() {
            return this.MeasureQualifiedName;
        }

        public boolean isAggregationOn() {
            return this.aggregationOn;
        }

        public boolean isAssociation() {
            return this.isAssociation;
        }

        public String getFunction() {
            return this.function;
        }

        public int getAxisType() {
            return this.axis;
        }
    }

    public static class MeasureInfo {
        private String expectedView = "";
        private String measureName = "";
        private boolean isShow = false;

        public MeasureInfo(ShowSummaryFieldDialog.MeasureInfo measureInfoIn) {
            this.isShow = measureInfoIn.isShow();
            this.measureName = measureInfoIn.getMeasureName();
            this.expectedView = measureInfoIn.getExpectedView();
        }

        public MeasureInfo(boolean isShow, String measureName, String expectedName) {
            this.isShow = isShow;
            this.measureName = measureName;
            this.expectedView = expectedName;
        }

        public String getMeasureName() {
            return this.measureName;
        }

        public boolean isShow() {
            return this.isShow;
        }
    }

    public static class SubTotalInfo {
        private String expectedView = "";
        private LevelHandle level;
        private String measureName;
        private boolean aggregationOn = false;
        private boolean isAssociation = false;
        private String function = "";

        public SubTotalInfo(AggregationDialog.SubTotalInfo subTotalIn) {
            this.measureName = subTotalIn.getAggregateOnMeasureName();
            this.aggregationOn = subTotalIn.isAggregationOn();
            this.function = subTotalIn.getFunction();
            this.level = subTotalIn.getLevel();
            this.isAssociation = subTotalIn.isAssociation();
            this.expectedView = subTotalIn.getExpectedView();
        }

        public String getMeasureName() {
            return this.measureName;
        }

        public LevelHandle getLevelHande() {
            return this.level;
        }

        public boolean isAggregation() {
            return this.aggregationOn;
        }

        public boolean isAssociation() {
            return this.isAssociation;
        }

        public String getFunction() {
            return this.function;
        }
    }
}

