/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts;

import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DataEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.util.bidi.BidiUIUtils;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class MeasureAggregationEditPart
extends DataEditPart {
    public MeasureAggregationEditPart(Object model) {
        super(model);
    }

    protected String getText() {
        DataItemHandle handle = (DataItemHandle)this.getModel();
        ComputedColumnHandle bindingColumn = DEUtil.getInputBinding((ReportItemHandle)handle, (String)handle.getResultSetColumn());
        if (bindingColumn == null) {
            return super.getText();
        }
        Object retValue = null;
        String displayName = this.getDisplayName();
        if (displayName != null && displayName.length() > 0) {
            retValue = displayName;
        }
        if (retValue == null) {
            retValue = this.getMeasureName(bindingColumn);
        }
        if (retValue == null) {
            return super.getText();
        }
        ((LabelFigure)this.getFigure()).setSpecialPREFIX("\u2211");
        if (((String)retValue).length() > 18) {
            retValue = ((String)retValue).substring(0, 16) + "...";
        }
        retValue = BidiUIUtils.INSTANCE.isDirectionRTL(this.getModel()) ? "\u202a[\u202b" + (String)retValue + "\u202c]\u202c\u202a\u2211" : "\u2211[" + (String)retValue + "]";
        return retValue;
    }

    private String getMeasureName(ComputedColumnHandle bindingColumn) {
        DataRequestSession session = null;
        try {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            String string = session.getCubeQueryUtil().getReferencedMeasureName(DataUtil.getAggregationExpression((ComputedColumnHandle)bindingColumn));
            return string;
        }
        catch (Exception e) {
            return null;
        }
        finally {
            if (session != null) {
                session.shutdown();
            }
        }
    }
}

