/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal.component;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.script.api.component.ICategory;
import org.eclipse.birt.chart.script.api.data.ISeriesGrouping;
import org.eclipse.birt.chart.script.internal.ChartComponentUtil;
import org.eclipse.birt.chart.script.internal.component.SeriesImpl;
import org.eclipse.birt.chart.script.internal.data.SeriesGroupingImpl;

public class CategoryImpl
extends SeriesImpl
implements ICategory {
    public CategoryImpl(SeriesDefinition sd, Chart cm) {
        super(sd, cm);
    }

    @Override
    public ISeriesGrouping getGrouping() {
        return new SeriesGroupingImpl(this.sd.getGrouping());
    }

    @Override
    public String getSorting() {
        return this.sd.getSorting().getName();
    }

    @Override
    public void setSorting(String sorting) {
        this.sd.setSorting(SortOption.getByName((String)sorting));
    }

    @Override
    public String getOptionalValueGroupingExpr() {
        List sds = ChartComponentUtil.getOrthogonalSeriesDefinitions(this.cm, 0);
        SeriesDefinition sdValue0 = (SeriesDefinition)sds.get(0);
        return sdValue0.getQuery().getDefinition();
    }

    @Override
    public void setOptionalValueGroupingExpr(String expr) {
        Query query = this.sd.getQuery();
        if (query == null) {
            query = QueryImpl.create((String)expr);
            this.sd.setQuery(query);
            query.eAdapters().addAll((Collection)this.sd.eAdapters());
        } else {
            query.setDefinition(expr);
        }
        this.updateOptionGrouping(expr);
    }

    private void updateOptionGrouping(String expr) {
        List seriesList = ChartComponentUtil.getOrthogonalSeriesDefinitions(this.cm, -1);
        int i = 0;
        while (i < seriesList.size()) {
            SeriesDefinition sd = (SeriesDefinition)seriesList.get(i);
            if (sd.getQuery() != null) {
                sd.getQuery().setDefinition(expr);
            } else {
                Query query = QueryImpl.create((String)expr);
                query.eAdapters().addAll((Collection)sd.eAdapters());
                sd.setQuery(query);
            }
            ++i;
        }
    }
}

