/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.CDialogCellEditor;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ComboBoxColorCellEditor
extends CDialogCellEditor {
    private CCombo comboBox;
    private String[] items;
    private Map itemKeyMap;
    private Map valueKeyMap;
    int selection;
    private static final int defaultStyle = 0;
    private Composite composite;
    private int inProcessing = 0;

    public ComboBoxColorCellEditor(Composite parent) {
        super(parent);
        this.setStyle(0);
    }

    public ComboBoxColorCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public ComboBoxColorCellEditor(Composite parent, String[] items, String[] values) {
        this(parent, items, values, 0);
    }

    public ComboBoxColorCellEditor(Composite parent, String[] items, int style) {
        this(parent, items, null, style);
    }

    public ComboBoxColorCellEditor(Composite parent, String[] items, String[] values, int style) {
        super(parent, style);
        if (items != null) {
            if (values != null) {
                assert (values.length == items.length);
                this.itemKeyMap = new HashMap();
                this.valueKeyMap = new HashMap();
                int i = 0;
                while (i < items.length) {
                    this.itemKeyMap.put(items[i], values[i]);
                    this.valueKeyMap.put(values[i], items[i]);
                    ++i;
                }
            }
            Arrays.sort(items);
        }
        this.setItems(items);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new FillLayout());
        this.comboBox = new CCombo(this.composite, 0);
        this.comboBox.setVisibleItemCount(30);
        this.comboBox.setBackground(bg);
        this.comboBox.setFont(cell.getFont());
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ComboBoxColorCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                ComboBoxColorCellEditor.this.applyEditorValueAndDeactivate();
            }
        });
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ComboBoxColorCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxColorCellEditor.this.focusLost();
            }
        });
        return this.composite;
    }

    void applyEditorValueAndDeactivate() {
        this.inProcessing = 1;
        this.doValueChanged();
        this.fireApplyEditorValue();
        this.deactivate();
        this.inProcessing = 0;
    }

    @Override
    protected void doValueChanged() {
        boolean newValidState;
        if (this.selection != this.comboBox.getSelectionIndex()) {
            this.markDirty();
        }
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = null;
        newValue = this.selection == -1 ? this.comboBox.getText() : (this.itemKeyMap != null ? this.itemKeyMap.get(this.comboBox.getItem(this.selection)) : this.comboBox.getItem(this.selection));
        if (newValue != null && (newValidState = this.isCorrect(newValue))) {
            this.doSetValue(newValue);
            this.markDirty();
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Shell shell = new Shell(Display.getCurrent(), 1264);
        shell.setLocation(cellEditorWindow.toDisplay((int)0, (int)0).x + cellEditorWindow.getBounds().width, cellEditorWindow.toDisplay((int)0, (int)0).y - cellEditorWindow.getBounds().height);
        ColorDialog dialog = new ColorDialog(shell, 65536);
        RGB[] rgbs = ReportPlugin.getDefault().getCustomColorsPreference();
        if (rgbs != null) {
            dialog.setRGBs(rgbs);
        }
        Object value = this.getValue();
        try {
            int color = value instanceof String ? ColorUtil.parseColor((String)((String)value)) : (Integer)value;
            dialog.setRGB(DEUtil.getRGBValue((int)color));
        }
        catch (Exception exception) {
            // empty catch block
        }
        value = dialog.open();
        ReportPlugin.getDefault().setCustomColorsPreference(dialog.getRGBs());
        if (value != null && dialog.getRGB() != null) {
            this.deactivate();
            return ColorUtil.format((int)ColorUtil.formRGB((int)dialog.getRGB().red, (int)dialog.getRGB().green, (int)dialog.getRGB().blue), (int)1);
        }
        this.comboBox.setFocus();
        shell.dispose();
        return value;
    }

    protected void updateContents(Object value) {
        String item;
        if (this.comboBox == null) {
            return;
        }
        Object text = "";
        if (value != null) {
            text = value instanceof RGB ? "0x" + Integer.toHexString(DEUtil.getRGBInt((RGB)((RGB)value))) : value.toString();
        }
        int index = -1;
        if (this.valueKeyMap != null && (item = (String)this.valueKeyMap.get(value)) != null) {
            index = this.comboBox.indexOf(item);
        }
        if (index >= 0) {
            text = this.comboBox.getItem(index);
        }
        this.comboBox.setText((String)text);
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.character == '\r') {
            this.applyEditorValueAndDeactivate();
        }
    }

    @Override
    protected void focusLost() {
        if (this.inProcessing == 1) {
            return;
        }
        super.focusLost();
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }
}

