/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.layout.AbstractPageFlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

public class MasterPageLayout
extends AbstractPageFlowLayout {
    public static final int MINIMUM_HEIGHT = 50;

    public MasterPageLayout(GraphicalEditPart owner) {
        super(owner);
    }

    @Override
    public void layout(IFigure parent) {
        Rectangle parentBounds = this.getInitSize();
        AbstractPageFlowLayout.Result result = this.getReportBounds(parentBounds);
        parentBounds = result.reportSize;
        parent.setBounds(parentBounds);
        List children = parent.getChildren();
        Rectangle clientArea = parent.getClientArea();
        int y = clientArea.y;
        int height = clientArea.height;
        int i = 0;
        while (i < children.size()) {
            IFigure figure = (IFigure)children.get(i);
            Rectangle bounds = (Rectangle)this.getConstraint(figure);
            if (bounds != null) {
                bounds = this.convertRectangle(bounds, clientArea);
                figure.getBounds().width = bounds.width;
                Dimension preferredSize = figure.getPreferredSize();
                bounds = bounds.getCopy();
                if (bounds.height < 0) {
                    bounds.height = Math.max(preferredSize.height, 50);
                }
                if (bounds.height > height) {
                    bounds.height = height;
                }
                if (bounds.y + bounds.height > height + y || bounds.y < y) {
                    bounds.y = height + y - bounds.height;
                }
                figure.setBounds(bounds);
            }
            ++i;
        }
        Rectangle rect = new Rectangle(0, 0, parentBounds.x + parentBounds.width + result.rightSpace, parentBounds.y + parentBounds.height + result.bottomSpace);
        this.setViewProperty(rect, parentBounds);
    }

    private Rectangle convertRectangle(Rectangle bounds, Rectangle clientArea) {
        Rectangle b = bounds.getCopy();
        b.width = clientArea.width;
        if (b.x == 0) {
            b.x = clientArea.getTopLeft().x;
            b.y = clientArea.getTopLeft().y;
        } else {
            b.x = clientArea.getBottomLeft().x;
            b.y = clientArea.getBottomLeft().y - (b.height < 0 ? 50 : b.height);
        }
        return b;
    }
}

