/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IOutsideBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ImageFigure
extends ReportElementFigure
implements IOutsideBorder {
    private Image img;
    private int alignment;
    private Dimension size = new Dimension();
    private boolean stretch = false;

    public ImageFigure() {
        this(null, 2);
    }

    public ImageFigure(Image image) {
        this(image, 2);
    }

    public ImageFigure(Image image, int alignment) {
        this.setImage(image);
        this.setAlignment(alignment);
    }

    @Override
    public Image getImage() {
        return this.img;
    }

    public void setStretched(boolean isStretched) {
        this.stretch = isStretched;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.getBorder() != null) {
            Insets bdInsets = this.getBorder().getInsets((IFigure)this);
            return new Dimension(this.size.width + bdInsets.getWidth(), this.size.height + bdInsets.getHeight());
        }
        return this.size;
    }

    private void paintStretched(Graphics g) {
        Image image = this.getImage();
        Rectangle area = this.getClientArea();
        if (area.height > 0 && area.width > 0) {
            g.drawImage(image, new Rectangle(image.getBounds()), area);
        }
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            if (this.getBorder() instanceof BaseBorder) {
                graphics.fillRectangle(this.getBounds().getCopy().shrink(((BaseBorder)this.getBorder()).getBorderInsets()));
            } else {
                graphics.fillRectangle(this.getBounds());
            }
        }
        if (this.getImage() == null || this.getImage().isDisposed()) {
            return;
        }
        if (this.stretch) {
            this.paintStretched(graphics);
            return;
        }
        Rectangle area = this.getClientArea();
        graphics.drawImage(this.getImage(), switch (this.alignment & 0x18) {
            case 16 -> area.x + area.width - this.size.width;
            case 8 -> area.x;
            default -> (area.width - this.size.width) / 2 + area.x;
        }, switch (this.alignment & 5) {
            case 1 -> area.y;
            case 4 -> area.y + area.height - this.size.height;
            default -> (area.height - this.size.height) / 2 + area.y;
        });
    }

    @Override
    public void setAlignment(int flag) {
        this.alignment = flag;
    }

    @Override
    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        this.size = this.img != null ? new Rectangle(image.getBounds()).getSize() : new Dimension();
        this.revalidate();
        this.repaint();
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.size.width = w;
        this.size.height = h;
    }

    @Override
    public Border getOutsideBorder() {
        return this.getBorder();
    }
}

