/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.DataEngineThreadLocal;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.CancelManager;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.NamingRelation;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class DataEngineSession {
    private static Integer count = 0;
    private Map context;
    private Scriptable scope;
    private DataSetCacheManager dataSetCacheManager;
    private DataEngineImpl engine;
    private String tempDir;
    private QueryResultIDUtil queryResultIDUtil;
    private NamingRelation namingRelation;
    private CancelManager cancelManager;
    private StopSign stopSign;
    private Timer currentTimer;
    private Map<String, Integer> acls;
    private Set<String> emptyQueryResultID;
    private RAOutputStream emtpryIDStream;
    private static ThreadLocal<ClassLoader> classLoaderHolder = new ThreadLocal();
    private static ThreadLocal<Map<String, Integer>> versionForQuRsHolder = new ThreadLocal();
    private static Logger logger = Logger.getLogger(DataEngineSession.class.getName());

    public DataEngineSession(DataEngineImpl engine) throws BirtException {
        Object[] params = new Object[]{engine};
        logger.entering(DataEngineSession.class.getName(), "DataEngineSession", params);
        this.context = new HashMap();
        this.engine = engine;
        this.scope = engine.getContext().getJavaScriptScope();
        this.stopSign = new StopSign();
        IDataScriptEngine scriptEngine = (IDataScriptEngine)engine.getContext().getScriptContext().getScriptEngine("javascript");
        if (this.scope == null) {
            this.scope = new ImporterTopLevel(scriptEngine.getJSContext(engine.getContext().getScriptContext()));
        }
        new CoreJavaScriptInitializer().initialize(scriptEngine.getJSContext(engine.getContext().getScriptContext()), this.scope);
        StringBuilder buffer = new StringBuilder();
        buffer.append(engine.getContext().getTmpdir());
        buffer.append("DataEngine");
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        buffer.append(Integer.toHexString(processName.hashCode()));
        buffer.append("_");
        buffer.append(Integer.toHexString(engine.hashCode()));
        buffer.append("_");
        buffer.append(this.getCount());
        buffer.append(File.separator);
        this.tempDir = buffer.toString();
        this.dataSetCacheManager = new DataSetCacheManager(this);
        this.cancelManager = new CancelManager();
        if (engine.getContext().getClassLoader() != null) {
            classLoaderHolder.set(engine.getContext().getClassLoader());
        }
        final int mode = engine.getContext().getMode();
        engine.addShutdownListener(new IShutdownListener(){

            @Override
            public void dataEngineShutdown() {
                int count = DataEngineThreadLocal.getInstance().getCloseListener().getActivateDteCount();
                if (count == 1) {
                    classLoaderHolder.set(null);
                }
                if (mode != 3) {
                    versionForQuRsHolder.set(null);
                }
                DataEngineSession.this.houseKeepCancelManager();
                DataEngineSession.this.saveGeneralACL();
                if (DataEngineSession.this.emtpryIDStream != null) {
                    try {
                        DataEngineSession.this.emtpryIDStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        engine.addShutdownListener(new ReportDocumentShutdownListener(this));
        this.queryResultIDUtil = new QueryResultIDUtil();
        this.loadGeneralACL();
        int currentQueryID = 0;
        if (engine.getContext().getDocReader() != null) {
            try {
                if (engine.getContext().getDocReader().exists("/dataEngine/queryStartingID")) {
                    RAInputStream stream = engine.getContext().getDocReader().getInputStream("/dataEngine/queryStartingID");
                    currentQueryID = stream.readInt();
                    stream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.queryResultIDUtil = new QueryResultIDUtil(currentQueryID);
        logger.exiting(DataEngineSession.class.getName(), "DataEngineSession");
    }

    private void loadGeneralACL() throws DataException {
        this.acls = new LinkedHashMap<String, Integer>();
        if (!this.engine.getContext().hasInStream("DataEngine", null, 111)) {
            return;
        }
        DataInputStream aclCollectionStream = new DataInputStream((InputStream)this.engine.getContext().getInputStream("DataEngine", null, 111));
        try {
            int count = IOUtil.readInt((InputStream)aclCollectionStream);
            int i = 0;
            while (i < count) {
                String temp = IOUtil.readString((DataInputStream)aclCollectionStream);
                if (temp != null) {
                    temp = temp.toUpperCase();
                }
                this.acls.put(temp, i);
                ++i;
            }
            aclCollectionStream.close();
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private void saveGeneralACL() {
        try {
            if (this.engine.getContext().getDocWriter() == null || this.acls.isEmpty()) {
                return;
            }
            DataOutputStream aclCollectionStream = new DataOutputStream((OutputStream)this.engine.getContext().getOutputStream("DataEngine", null, 111));
            IOUtil.writeInt((OutputStream)aclCollectionStream, (int)this.acls.size());
            for (String acl : this.acls.keySet()) {
                IOUtil.writeString((DataOutputStream)aclCollectionStream, (String)acl);
            }
            aclCollectionStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public void updateNestedEmptyQueryID(String queryResultID) {
        try {
            if (this.engine.getContext().getDocWriter() == null || this.emptyQueryResultID.isEmpty()) {
                return;
            }
            if (this.emtpryIDStream == null) {
                this.emtpryIDStream = this.engine.getContext().getOutputStream("DataEngine", null, 116);
            }
            DataOutputStream emptryQueryIDStream = new DataOutputStream((OutputStream)this.emtpryIDStream);
            this.emtpryIDStream.seek(0L);
            IOUtil.writeInt((OutputStream)emptryQueryIDStream, (int)this.emptyQueryResultID.size());
            for (String id : this.emptyQueryResultID) {
                IOUtil.writeString((DataOutputStream)emptryQueryIDStream, (String)id);
            }
            this.emtpryIDStream.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount() {
        Integer n = count;
        synchronized (n) {
            count = (count + 1) % 100000;
            return count;
        }
    }

    public DataEngine getEngine() {
        return this.engine;
    }

    public Object get(String key) {
        if (key != null) {
            return this.context.get(key);
        }
        return null;
    }

    public void set(String key, Object value) {
        this.context.put(key, value);
    }

    public StopSign getStopSign() {
        return this.stopSign;
    }

    public void cancel() {
        this.stopSign.stop();
        this.cancelManager.doCancel();
        if (this.currentTimer == null) {
            this.currentTimer = new Timer();
            this.currentTimer.schedule((TimerTask)this.cancelManager, 1000L, 1000L);
        }
    }

    public void restart() {
        this.stopSign.start();
    }

    public Scriptable getSharedScope() {
        return this.scope;
    }

    public DataSetCacheManager getDataSetCacheManager() {
        return this.dataSetCacheManager;
    }

    public static ClassLoader getCurrentClassLoader() {
        return classLoaderHolder.get();
    }

    public static Map<String, Integer> getVersionForQuRsMap() {
        if (versionForQuRsHolder.get() == null) {
            versionForQuRsHolder.set(new HashMap());
        }
        return versionForQuRsHolder.get();
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public DataEngineContext getEngineContext() {
        return this.engine.getContext();
    }

    public QueryResultIDUtil getQueryResultIDUtil() {
        return this.queryResultIDUtil;
    }

    public NamingRelation getNamingRelation() {
        return this.namingRelation;
    }

    public void setNamingRelation(NamingRelation namingRelation) {
        this.namingRelation = namingRelation;
    }

    public CancelManager getCancelManager() {
        return this.cancelManager;
    }

    private void houseKeepCancelManager() {
        if (this.cancelManager != null) {
            this.cancelManager.cancel();
            this.cancelManager = null;
        }
        if (this.currentTimer != null) {
            this.currentTimer.cancel();
            this.currentTimer = null;
        }
    }

    public Map<String, Integer> getACLs() {
        return this.acls;
    }

    public Set<String> getEmptyNestedResultSetID() {
        if (this.emptyQueryResultID == null) {
            this.emptyQueryResultID = new HashSet<String>();
        }
        return this.emptyQueryResultID;
    }

    static class ReportDocumentShutdownListener
    implements IShutdownListener {
        private DataEngineSession session;

        ReportDocumentShutdownListener(DataEngineSession session) {
            this.session = session;
        }

        @Override
        public void dataEngineShutdown() {
            if (this.session.getNamingRelation() == null) {
                return;
            }
            if (this.session.getEngineContext().getDocWriter() != null) {
                try {
                    this.saveNamingRelation(this.session.getNamingRelation());
                }
                catch (DataException e1) {
                    e1.printStackTrace();
                }
            }
        }

        private void saveNamingRelation(NamingRelation relation) throws DataException {
            Map bookmarkMap = relation.getBookmarkMap();
            Map elementIdMap = relation.getElementIdMap();
            RAOutputStream out = this.session.getEngineContext().getOutputStream(null, null, 101);
            try {
                try {
                    DataOutputStream dos = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
                    IOUtil.writeMap((DataOutputStream)dos, (Map)bookmarkMap);
                    IOUtil.writeMap((DataOutputStream)dos, (Map)elementIdMap);
                    dos.flush();
                }
                catch (IOException e) {
                    throw new DataException("", e);
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "", e);
                    }
                }
            }
        }
    }
}

