/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetView;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STSheetViewType;
import uk.co.spudsoft.birt.emitters.excel.AreaBorders;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.FilteredSheet;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.ITableHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableContainer;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableHandler;

public class AbstractRealTableHandler
extends AbstractHandler
implements ITableHandler,
NestedTableContainer {
    protected int startRow;
    protected int startCol;
    protected int startDetailsRow = -1;
    protected int endDetailsRow;
    private BirtStyle tableStyle;
    private AreaBorders borderDefn;
    private List<NestedTableHandler> nestedTables;

    public AbstractRealTableHandler(Logger log, IHandler parent, ITableContent table) {
        super(log, parent, (IContent)table);
    }

    @Override
    public int getColumnCount() {
        return ((ITableContent)this.element).getColumnCount();
    }

    @Override
    public void addNestedTable(NestedTableHandler nestedTableHandler) {
        if (this.nestedTables == null) {
            this.nestedTables = new ArrayList<NestedTableHandler>();
        }
        this.log.debug("Adding nested table: ", nestedTableHandler);
        this.nestedTables.add(nestedTableHandler);
    }

    @Override
    public boolean rowHasNestedTable(int rowNum) {
        if (this.nestedTables != null) {
            for (NestedTableHandler nestedTableHandler : this.nestedTables) {
                if (!nestedTableHandler.includesRow(rowNum)) continue;
                this.log.debug("Row ", rowNum, " has nested table ", nestedTableHandler);
                return true;
            }
        }
        this.log.debug("Row ", rowNum, " has no nested tables");
        return false;
    }

    @Override
    public int extendRowBy(int rowNum) {
        int offset = 1;
        if (this.nestedTables != null) {
            for (NestedTableHandler nestedTableHandler : this.nestedTables) {
                int nestedTablesOffset = nestedTableHandler.extendParentsRowBy(rowNum);
                if (nestedTablesOffset <= offset) continue;
                this.log.debug("Row ", rowNum, " is extended by ", nestedTablesOffset, " thanks to ", nestedTableHandler);
                offset = nestedTablesOffset;
            }
        }
        return offset;
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        this.startRow = state.rowNum;
        this.startCol = state.colNum;
        this.log.debug("startTable @ [", this.startRow, ",", this.startCol, "]");
        int col = 0;
        while (col < table.getColumnCount()) {
            DimensionType width = table.getColumn(col).getWidth();
            if (width != null) {
                this.log.debug("BIRT table column width: ", col, " = ", width);
                int newWidth = state.getSmu().poiColumnWidthFromDimension(width);
                int oldWidth = state.currentSheet.getColumnWidth(this.startCol + col);
                int maxValue = 65280;
                if (newWidth > maxValue) {
                    state.currentSheet.setColumnWidth(this.startCol + col, maxValue);
                } else if (oldWidth == 256 * state.currentSheet.getDefaultColumnWidth() || newWidth > oldWidth) {
                    state.currentSheet.setColumnWidth(this.startCol + col, newWidth);
                }
            }
            ++col;
        }
        this.tableStyle = new BirtStyle((IContent)table);
        this.borderDefn = AreaBorders.create(-1, this.startCol, this.startCol + table.getColumnCount() - 1, this.startRow, -1, -1, this.tableStyle);
        if (this.borderDefn != null) {
            state.insertBorderOverload(this.borderDefn);
        }
        if (table.getGenerateBy() instanceof GridItemDesign) {
            this.startDetailsRow = state.rowNum;
        }
    }

    @Override
    public void endTable(HandlerState state, ITableContent table) throws BirtException {
        String pagePreview;
        int displayZoom;
        if (table.getGenerateBy() instanceof GridItemDesign) {
            this.endDetailsRow = state.rowNum;
        }
        this.log.debug("Applying bottom border to [", state.rowNum - 1, ",", this.startCol, "] - [", state.rowNum - 1, ",", this.startCol + table.getColumnCount() - 1, "]");
        state.getSmu().applyBottomBorderToRow(state.getSm(), state.currentSheet, this.startCol, this.startCol + table.getColumnCount() - 1, state.rowNum - 1, this.tableStyle);
        if (this.borderDefn != null) {
            state.removeBorderOverload(this.borderDefn);
        }
        this.log.debug("Details rows from ", this.startDetailsRow, " to ", this.endDetailsRow);
        int autoWidthStartRow = this.startDetailsRow;
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.AutoColWidthsIncludeTableHeader", false)) {
            autoWidthStartRow = this.startRow;
        }
        int autoWidthEndRow = this.endDetailsRow;
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.AutoColWidthsIncludeTableFooter", false)) {
            autoWidthEndRow = state.rowNum - 1;
        }
        if (autoWidthStartRow >= 0 && autoWidthEndRow > autoWidthStartRow) {
            boolean defaultAutoColWidth = EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.StreamingXlsx", false);
            boolean forceAutoColWidths = EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.ForceAutoColWidths", defaultAutoColWidth);
            int defaultColumnWidth = 256 * state.currentSheet.getDefaultColumnWidth();
            int col = 0;
            while (col < table.getColumnCount()) {
                int columnWidth = state.currentSheet.getColumnWidth(col);
                if (forceAutoColWidths || columnWidth == defaultColumnWidth) {
                    FilteredSheet filteredSheet = new FilteredSheet(state.currentSheet, autoWidthStartRow, Math.min(autoWidthEndRow, autoWidthStartRow + 12));
                    double calcWidth = SheetUtil.getColumnWidth((Sheet)filteredSheet, (int)col, (boolean)false);
                    int maxColumnWidth = 65280;
                    if ((calcWidth *= 294.4) > (double)maxColumnWidth) {
                        calcWidth = maxColumnWidth;
                    } else if (calcWidth < (double)defaultColumnWidth) {
                        calcWidth = defaultColumnWidth;
                    }
                    state.currentSheet.setColumnWidth(col, (int)calcWidth);
                }
                ++col;
            }
        }
        if (table.getBookmark() != null && state.rowNum > this.startRow && table.getColumnCount() > 1) {
            this.createName(state, AbstractRealTableHandler.prepareName(table.getBookmark()), this.startRow, 0, state.rowNum - 1, table.getColumnCount() - 1);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.DisplayFormulas", false)) {
            state.currentSheet.setDisplayFormulas(true);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.DisplayGridlines", true)) {
            state.currentSheet.setDisplayGridlines(false);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.DisplayRowColHeadings", true)) {
            state.currentSheet.setDisplayRowColHeadings(false);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.DisplayZeros", true)) {
            state.currentSheet.setDisplayZeros(false);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.DisplayRowColHeadings", true)) {
            state.currentSheet.setDisplayRowColHeadings(false);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.PrintGridlines", false)) {
            state.currentSheet.setPrintGridlines(true);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.PrintRowColHeadings", false)) {
            state.currentSheet.setPrintRowAndColumnHeadings(true);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.PrintFitToPage", false)) {
            state.currentSheet.setFitToPage(true);
        }
        if ((displayZoom = EmitterServices.integerOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.DisplaySheetZoom", -1)) >= 10 && displayZoom <= 400) {
            state.currentSheet.setZoom(displayZoom);
        }
        if ((pagePreview = EmitterServices.stringOption((ITaskOption)state.getRenderOptions(), (IContent)table, "ExcelEmitter.PagePreview", null)) != null) {
            if (pagePreview.equalsIgnoreCase("PageLayout")) {
                CTSheetView view = ((XSSFSheet)state.currentSheet).getCTWorksheet().getSheetViews().getSheetViewArray(0);
                view.setView(STSheetViewType.PAGE_LAYOUT);
            } else if (pagePreview.equalsIgnoreCase("PageBreak")) {
                CTSheetView view = ((XSSFSheet)state.currentSheet).getCTWorksheet().getSheetViews().getSheetViewArray(0);
                view.setView(STSheetViewType.PAGE_BREAK_PREVIEW);
            }
        }
    }

    @Override
    public void startTableBand(HandlerState state, ITableBandContent band) throws BirtException {
        if (band.getBandType() == 0 && this.startDetailsRow < 0) {
            this.startDetailsRow = state.rowNum;
        }
    }

    @Override
    public void endTableBand(HandlerState state, ITableBandContent band) throws BirtException {
        if (band.getBandType() == 0) {
            this.endDetailsRow = state.rowNum - 1;
        }
    }

    @Override
    public void startTableGroup(HandlerState state, ITableGroupContent group) throws BirtException {
    }

    @Override
    public void endTableGroup(HandlerState state, ITableGroupContent group) throws BirtException {
    }
}

