/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.axis;

import com.ibm.icu.util.Calendar;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.FieldAssistHelper;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataElementComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisGridLinesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisLabelSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisMarkersSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisScaleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisTitleSheet;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractAxisSubtask
extends SubtaskSheetImpl
implements Listener,
SelectionListener,
ModifyListener {
    private ChartCheckbox btnCategoryAxis;
    private ChartCheckbox btnReverse;
    protected ExternalizedTextEditorComposite txtTitle;
    protected ChartCheckbox btnTitleVisible;
    private ChartCombo cmbTypes;
    private ChartCombo cmbOrigin;
    private Button btnFormatSpecifier;
    private Label lblValue;
    private IDataElementComposite txtValue;
    private ChartCheckbox btnLabelVisible;
    private FontDefinitionComposite fdcFont;
    private ChartCheckbox btnStaggered;
    private LocalizedNumberEditorComposite lneLabelSpan;
    private Button btnFixLabelSpan;

    protected AbstractAxisSubtask() {
    }

    protected abstract Axis getAxisForProcessing();

    protected abstract Axis getDefaultValueAxis();

    protected abstract int getAxisAngleType();

    protected boolean isChart3D() {
        if (this.getChart() instanceof ChartWithAxes) {
            return ((Chart)this.getChart()).getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL;
        }
        return false;
    }

    @Override
    public void createControl(Composite parent) {
        GridData gd;
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, false);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd2 = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd2);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(4, false));
        cmpBasic.setLayoutData((Object)new GridData(768));
        if (this.getAxisAngleType() == 1) {
            this.btnCategoryAxis = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBasic, 0, this.getDefaultValueAxis().isCategoryAxis());
            this.btnCategoryAxis.setText(Messages.getString("AbstractAxisSubtask.Lbl.IsCategoryAxis"));
            gd2 = new GridData();
            gd2.horizontalSpan = 2;
            this.btnCategoryAxis.setLayoutData((Object)gd2);
            this.btnCategoryAxis.setSelectionState(this.getDefaultCategoryAxisButtonState());
            this.updateCategoryAxisUI(!this.getAxisForProcessing().isSetType() || !AxisType.TEXT_LITERAL.equals((Object)this.getAxisForProcessing().getType()));
            this.btnCategoryAxis.addSelectionListener((SelectionListener)this);
            this.btnReverse = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBasic, 0, DefaultValueProvider.defChartWithAxes().isReverseCategory());
            this.btnReverse.setText(Messages.getString("AbstractAxisSubtask.Label.ReverseCategory"));
            gd2 = new GridData();
            gd2.horizontalSpan = 2;
            this.btnReverse.setLayoutData((Object)gd2);
            this.btnReverse.setSelectionState(((ChartWithAxes)this.getChart()).isSetReverseCategory() ? (((ChartWithAxes)this.getChart()).isReverseCategory() ? 1 : 2) : 0);
            this.updateReverseUI(((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnCategoryAxis));
            this.btnReverse.addSelectionListener((SelectionListener)this);
        }
        this.createTitleComosite(cmpBasic);
        if (this.getAxisAngleType() != 3) {
            Label lblType = new Label(cmpBasic, 0);
            lblType.setText(Messages.getString("OrthogonalAxisDataSheetImpl.Lbl.Type"));
            this.cmbTypes = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCombo(cmpBasic, 12, (EObject)this.getAxisForProcessing(), "type", this.getDefaultValueAxis().getType().getName());
            gd = new GridData();
            gd.widthHint = 220;
            gd.horizontalIndent = 5;
            this.cmbTypes.setLayoutData((Object)gd);
            this.cmbTypes.addSelectionListener((SelectionListener)this);
            this.btnFormatSpecifier = new Button(cmpBasic, 8);
            GridData gdBTNFormatSpecifier = new GridData();
            gdBTNFormatSpecifier.horizontalIndent = -3;
            gdBTNFormatSpecifier.horizontalSpan = 2;
            this.btnFormatSpecifier.setLayoutData((Object)gdBTNFormatSpecifier);
            this.btnFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
            this.btnFormatSpecifier.addSelectionListener((SelectionListener)this);
            this.btnFormatSpecifier.setText(Messages.getString("Format.Button.Label"));
            if (!this.isChart3D()) {
                Label lblOrigin = new Label(cmpBasic, 0);
                lblOrigin.setText(Messages.getString("OrthogonalAxisDataSheetImpl.Lbl.Origin"));
                this.cmbOrigin = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCombo(cmpBasic, 12, (EObject)this.getAxisForProcessing().getOrigin(), "type", this.getDefaultValueAxis().getOrigin().getType().getName());
                GridData gd3 = new GridData();
                gd3.widthHint = 220;
                gd3.horizontalSpan = 3;
                gd3.horizontalIndent = 5;
                this.cmbOrigin.setLayoutData((Object)gd3);
                this.cmbOrigin.addSelectionListener((SelectionListener)this);
                boolean bValueOrigin = false;
                if (this.getAxisForProcessing().getOrigin() != null && (!this.getAxisForProcessing().getOrigin().isSetType() || this.getAxisForProcessing().getOrigin().isSetType() && this.getAxisForProcessing().getOrigin().getType().equals((Object)IntersectionType.VALUE_LITERAL))) {
                    bValueOrigin = true;
                }
                this.lblValue = new Label(cmpBasic, 0);
                this.lblValue.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Value"));
                this.lblValue.setEnabled(bValueOrigin);
                this.txtValue = this.createDataElementComposite(cmpBasic);
                GridData gd4 = new GridData();
                gd4.widthHint = 278;
                gd4.horizontalSpan = 3;
                gd4.horizontalIndent = 5;
                this.txtValue.setLayoutData((Object)gd4);
                this.txtValue.addListener((Listener)this);
                this.txtValue.setEnabled(bValueOrigin);
            }
            this.populateLists();
        }
        new Label(cmpBasic, 0).setText(Messages.getString("AxisYSheetImpl.Label.Labels"));
        this.fdcFont = new FontDefinitionComposite(cmpBasic, 0, (ChartWizardContext)this.getContext(), this.getAxisForProcessing().getLabel().getCaption().getFont(), this.getAxisForProcessing().getLabel().getCaption().getColor(), false);
        GridData gdFDCFont = new GridData();
        gdFDCFont.widthHint = 250;
        gdFDCFont.horizontalIndent = 5;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        Composite cmpLabel = new Composite(cmpBasic, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        cmpLabel.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cmpLabel.setLayout((Layout)layout);
        this.btnLabelVisible = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpLabel, 0, this.getDefaultValueAxis().getLabel().isVisible());
        this.btnLabelVisible.setText(Messages.getString("AbstractAxisSubtask.Label.Visible2"));
        gd = new GridData(768);
        this.btnLabelVisible.setLayoutData((Object)gd);
        this.btnLabelVisible.setSelectionState(this.getAxisForProcessing().getLabel().isSetVisible() ? (this.getAxisForProcessing().getLabel().isVisible() ? 1 : 2) : 0);
        this.btnLabelVisible.addSelectionListener((SelectionListener)this);
        boolean bNot3D = !this.isChart3D();
        this.btnStaggered = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpLabel, 0, this.getDefaultValueAxis().isStaggered() && bNot3D);
        this.btnStaggered.setText(Messages.getString("AbstractAxisSubtask.Label.Stagger"));
        Axis ax = this.getAxisForProcessing();
        this.btnStaggered.setSelectionState(ax.isSetStaggered() ? (ax.isStaggered() && bNot3D ? 1 : 2) : 0);
        this.btnStaggered.setEnabled(bNot3D);
        this.btnStaggered.setVisible(this.isStaggerSupported());
        this.btnStaggered.addSelectionListener((SelectionListener)this);
        this.createLabelSpan(cmpBasic);
        this.createButtonGroup(this.cmpContent);
        this.setStateOfTitle();
        this.setStateOfLabel();
    }

    protected int getDefaultCategoryAxisButtonState() {
        return this.getAxisForProcessing().isSetCategoryAxis() ? (this.getAxisForProcessing().isCategoryAxis() ? 1 : 2) : 0;
    }

    protected void createTitleComosite(Composite cmpBasic) {
        Label lblTitle = new Label(cmpBasic, 0);
        lblTitle.setText(Messages.getString("AxisYSheetImpl.Label.Title"));
        List keys = null;
        IUIServiceProvider serviceprovider = ((ChartWizardContext)this.getContext()).getUIServiceProvider();
        if (serviceprovider != null) {
            keys = serviceprovider.getRegisteredKeys();
        }
        this.txtTitle = new ExternalizedTextEditorComposite(cmpBasic, 2052, -1, -1, keys, serviceprovider, this.getTitleValue());
        GridData gd = new GridData();
        gd.widthHint = 230;
        gd.horizontalIndent = 5;
        this.txtTitle.setLayoutData(gd);
        this.txtTitle.addListener(this);
        this.btnTitleVisible = ((ChartWizardContext)this.getContext()).getUIFactory().createChartCheckbox(cmpBasic, 0, this.getDefaultValueAxis().getTitle().isVisible());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.btnTitleVisible.setLayoutData((Object)gd);
        this.btnTitleVisible.setText(Messages.getString("ChartSheetImpl.Label.Visible"));
        this.btnTitleVisible.setSelectionState(this.getAxisForProcessing().getTitle().isSetVisible() ? (this.getAxisForProcessing().getTitle().isVisible() ? 1 : 2) : 0);
        this.btnTitleVisible.addSelectionListener((SelectionListener)this);
    }

    protected boolean isStaggerSupported() {
        return true;
    }

    protected String getTitleValue() {
        if (this.getAxisForProcessing().getTitle().getCaption().getValue() == null) {
            return "";
        }
        return this.getAxisForProcessing().getTitle().getCaption().getValue();
    }

    protected void createLabelSpan(Composite cmpBasic) {
        if (!this.isChart3D()) {
            Label l = new Label(cmpBasic, 0);
            l.setText(Messages.getString("AbstractAxisSubtask.Label.LabelSpan"));
            FieldAssistHelper.getInstance().addRequiredFieldIndicator(l);
            Composite cmpEditorWithUnit = new Composite(cmpBasic, 0);
            GridData gd = new GridData();
            gd.widthHint = 250;
            cmpEditorWithUnit.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cmpEditorWithUnit.setLayout((Layout)layout);
            this.lneLabelSpan = new LocalizedNumberEditorComposite(cmpEditorWithUnit, 2048);
            ChartUIUtil.addScreenReaderAccessbility((Control)this.lneLabelSpan.getTextControl(), (String)l.getText());
            new TextNumberEditorAssistField(this.lneLabelSpan.getTextControl(), null);
            this.lneLabelSpan.setValue(this.getAxisForProcessing().getLabelSpan());
            this.lneLabelSpan.addModifyListener(this);
            gd = new GridData(768);
            gd.horizontalIndent = 5;
            this.lneLabelSpan.setLayoutData(gd);
            this.lneLabelSpan.setEnabled(this.getAxisForProcessing().isSetLabelSpan());
            new Label(cmpEditorWithUnit, 0).setText(Messages.getString("AbstractAxisSubtask.Label.Points"));
            this.btnFixLabelSpan = new Button(cmpBasic, 32);
            this.btnFixLabelSpan.setText(Messages.getString("AbstractAxisSubtask.Button.Fixed"));
            this.btnFixLabelSpan.addSelectionListener((SelectionListener)this);
            this.btnFixLabelSpan.setSelection(this.getAxisForProcessing().isSetLabelSpan());
        }
    }

    protected void updateCategoryAxisUI(boolean enabled) {
        this.btnCategoryAxis.setEnabled(enabled);
    }

    protected void updateReverseUI(boolean enabled) {
        this.btnReverse.setEnabled(enabled);
    }

    protected void setStateOfTitle() {
        boolean isTitleEnabled = this.isTitleEnabled();
        this.txtTitle.setEnabled(isTitleEnabled);
        this.setToggleButtonEnabled(".Title", isTitleEnabled);
    }

    protected boolean isTitleEnabled() {
        return !((ChartWizardContext)this.getContext()).getUIFactory().isSetInvisible((EObject)this.getAxisForProcessing().getTitle());
    }

    private void setStateOfLabel() {
        Axis ax = this.getAxisForProcessing();
        boolean isLabelEnabled = !((ChartWizardContext)this.getContext()).getUIFactory().isSetInvisible((EObject)ax.getLabel());
        this.fdcFont.setEnabled(isLabelEnabled);
        this.btnStaggered.setEnabled(!this.isChart3D() && isLabelEnabled);
        this.setToggleButtonEnabled(".Label", isLabelEnabled);
    }

    protected void createButtonGroup(Composite parent) {
        AbstractPopupSheet popup;
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        gridData.horizontalAlignment = 1;
        cmp.setLayoutData((Object)gridData);
        if (this.getAxisAngleType() != 3) {
            popup = new AxisScaleSheet(Messages.getString("AxisYSheetImpl.Label.Scale"), (ChartWizardContext)this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType(), this.getDefaultValueAxis());
            Button btnScale = this.createToggleButton(cmp, ".Scale", Messages.getString("AxisYSheetImpl.Label.Scale&"), popup);
            btnScale.addSelectionListener((SelectionListener)this);
        }
        popup = new AxisTitleSheet(Messages.getString("AxisYSheetImpl.Label.TitleFormat"), (ChartWizardContext)this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType(), this.getDefaultValueAxis());
        Button btnAxisTitle = this.createToggleButton(cmp, ".Title", Messages.getString("AxisYSheetImpl.Label.TitleFormat&"), popup, ((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnTitleVisible));
        btnAxisTitle.addSelectionListener((SelectionListener)this);
        popup = new AxisLabelSheet(Messages.getString("AxisYSheetImpl.Label.LabelFormat"), (ChartWizardContext)this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType(), this.getDefaultValueAxis());
        Button btnAxisLabel = this.createToggleButton(cmp, ".Label", Messages.getString("AxisYSheetImpl.Label.LabelFormat&"), popup, ((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnLabelVisible));
        btnAxisLabel.addSelectionListener((SelectionListener)this);
        popup = new AxisGridLinesSheet(Messages.getString("AxisYSheetImpl.Label.Gridlines"), (ChartWizardContext)this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType(), this.getDefaultValueAxis());
        Button btnGridlines = this.createToggleButton(cmp, ".Gridlines", Messages.getString("AxisYSheetImpl.Label.Gridlines&"), popup);
        btnGridlines.addSelectionListener((SelectionListener)this);
        if (this.getAxisAngleType() != 3) {
            this.createMarkersUI(cmp);
        }
        if (this.isInteractivityEnabled()) {
            popup = new InteractivitySheet(Messages.getString("AbstractAxisSubtask.Label.Interactivity"), (ChartWizardContext)this.getContext(), (EList<Trigger>)this.getAxisForProcessing().getTriggers(), (EObject)this.getAxisForProcessing(), 8, 16);
            Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, ((Chart)this.getChart()).getInteractivity().isEnable());
            btnInteractivity.addSelectionListener((SelectionListener)this);
        }
    }

    protected boolean isInteractivityEnabled() {
        return ((ChartWizardContext)this.getContext()).isInteractivityEnabled();
    }

    protected void createMarkersUI(Composite cmp) {
        AxisMarkersSheet popup = new AxisMarkersSheet(Messages.getString("AxisYSheetImpl.Label.Markers"), (ChartWizardContext)this.getContext(), this.getAxisForProcessing(), this.getDefaultValueAxis());
        Button btnMarkers = this.createToggleButton(cmp, ".Markers", Messages.getString("AxisYSheetImpl.Label.Markers&"), popup, !ChartUIUtil.is3DType((Chart)((Chart)this.getChart())));
        btnMarkers.addSelectionListener((SelectionListener)this);
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.axisTypeSet;
        if (this.getAxisAngleType() == 2) {
            ns = ChartUIUtil.getCompatibleAxisType((Series)this.getDesignTimeSeries());
        }
        this.cmbTypes.setItems(ns.getDisplayNames());
        this.cmbTypes.setItemData(ns.getNames());
        this.cmbTypes.setSelection(this.getAxisForProcessing().getType().getName());
        if (!this.isChart3D()) {
            ns = LiteralHelper.intersectionTypeSet;
            this.cmbOrigin.setItems(ns.getDisplayNames());
            this.cmbOrigin.setItemData(ns.getNames());
            this.cmbOrigin.setSelection(this.getAxisForProcessing().getOrigin().getType().getName());
        }
        if (this.txtValue != null && this.getAxisForProcessing().getOrigin().getType().equals((Object)IntersectionType.VALUE_LITERAL)) {
            this.txtValue.setDataElement(this.getAxisForProcessing().getOrigin().getValue());
        }
    }

    protected Series getDesignTimeSeries() {
        return ((SeriesDefinition)this.getAxisForProcessing().getSeriesDefinitions().get(0)).getDesignTimeSeries();
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtTitle)) {
            this.getAxisForProcessing().getTitle().getCaption().setValue((String)event.data);
        } else if (event.widget.equals(this.txtValue)) {
            DataElement de = this.txtValue.getDataElement();
            if (de != null) {
                this.getAxisForProcessing().getOrigin().setValue(de);
            }
        } else if (event.widget.equals((Object)this.fdcFont)) {
            this.getAxisForProcessing().getLabel().getCaption().setFont(this.fdcFont.getFontDefinition());
            this.getAxisForProcessing().getLabel().getCaption().setColor(this.fdcFont.getFontColor());
        }
    }

    private double suggestLabelSpan(Axis ax) {
        boolean bHorizontal = ((ChartWithAxes)this.getChart()).isTransposed() ^ ax.getOrientation() == Orientation.HORIZONTAL_LITERAL;
        if (!bHorizontal) {
            if (ax.getType() == AxisType.LINEAR_LITERAL || ax.getType() == AxisType.LOGARITHMIC_LITERAL) {
                return 30.0;
            }
            return 50.0;
        }
        return 16.0;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget == this.btnFixLabelSpan) {
            boolean bLabelThickFixed = this.btnFixLabelSpan.getSelection();
            this.lneLabelSpan.setEnabled(bLabelThickFixed);
            if (!bLabelThickFixed) {
                this.getAxisForProcessing().unsetLabelSpan();
            } else {
                if (this.lneLabelSpan.getValue() == 0.0) {
                    double value = this.suggestLabelSpan(this.getAxisForProcessing());
                    this.lneLabelSpan.setValue(value);
                }
                this.getAxisForProcessing().setLabelSpan(this.lneLabelSpan.getValue());
            }
        }
        if (e.widget.equals(this.cmbTypes)) {
            AxisType axisType;
            String selectedAxisType = this.cmbTypes.getSelectedItemData();
            AxisType axisType2 = axisType = selectedAxisType == null ? this.getDefaultValueAxis().getType() : AxisType.getByName((String)selectedAxisType);
            if (this.getAxisForProcessing().isSetType() && this.getAxisForProcessing().getType() == axisType) {
                return;
            }
            ChartAdapter.beginIgnoreNotifications();
            this.convertSampleData(axisType);
            this.getAxisForProcessing().setFormatSpecifier(null);
            EList markerLines = this.getAxisForProcessing().getMarkerLines();
            int i = 0;
            while (i < markerLines.size()) {
                ((MarkerLine)markerLines.get(i)).setFormatSpecifier(null);
                ++i;
            }
            EList markerRanges = this.getAxisForProcessing().getMarkerRanges();
            int i2 = 0;
            while (i2 < markerRanges.size()) {
                ((MarkerRange)markerRanges.get(i2)).setFormatSpecifier(null);
                ++i2;
            }
            ChartAdapter.endIgnoreNotifications();
            if (selectedAxisType != null) {
                this.getAxisForProcessing().setType(axisType);
            }
            if (this.btnCategoryAxis != null) {
                boolean disableCategoryAxisUI = selectedAxisType != null && AxisType.TEXT_LITERAL.equals((Object)axisType);
                this.updateCategoryAxisUI(!disableCategoryAxisUI);
                this.updateReverseStateByCategoryAxisUI();
            }
            this.refreshPopupSheet();
        } else if (e.widget.equals(this.cmbOrigin)) {
            String selectedOriginType = this.cmbOrigin.getSelectedItemData();
            if (selectedOriginType != null && IntersectionType.VALUE_LITERAL.getName().equals(selectedOriginType)) {
                this.lblValue.setEnabled(true);
                this.txtValue.setEnabled(true);
                this.getAxisForProcessing().getOrigin().setType(IntersectionType.getByName((String)selectedOriginType));
            } else {
                boolean enabled = false;
                if (selectedOriginType == null) {
                    enabled = true;
                } else {
                    this.getAxisForProcessing().getOrigin().setType(IntersectionType.getByName((String)selectedOriginType));
                }
                this.getAxisForProcessing().getOrigin().setValue(null);
                this.lblValue.setEnabled(enabled);
                this.txtValue.setEnabled(enabled);
            }
            if (selectedOriginType != null && this.getAxisForProcessing().getOrigin().getType().getValue() == 2) {
                this.getAxisForProcessing().getOrigin().setValue(this.txtValue.getDataElement());
            }
        } else if (e.widget.equals(this.btnCategoryAxis)) {
            int state = this.btnCategoryAxis.getSelectionState();
            if (state == 0) {
                this.getAxisForProcessing().unsetCategoryAxis();
            } else {
                this.getAxisForProcessing().setCategoryAxis(state == 1);
            }
            ChartCacheManager.getInstance().cacheCategory(((ChartWithAxes)this.getChart()).getType(), state == 1);
            this.refreshPopupSheet();
            this.updateReverseStateByCategoryAxisUI();
        } else if (e.widget.equals(this.btnReverse)) {
            if (this.btnReverse.getSelectionState() == 0) {
                ((ChartWithAxes)this.getChart()).unsetReverseCategory();
            } else {
                ((ChartWithAxes)this.getChart()).setReverseCategory(this.btnReverse.getSelectionState() == 1);
            }
        } else if (e.widget == this.btnTitleVisible) {
            if (this.btnTitleVisible.getSelectionState() == 0) {
                this.getAxisForProcessing().getTitle().unsetVisible();
            } else {
                this.getAxisForProcessing().getTitle().setVisible(this.btnTitleVisible.getSelectionState() == 1);
            }
            this.setStateOfTitle();
            Button btnAxisTitle = this.getToggleButton(".Title");
            if (this.btnTitleVisible.getSelectionState() != 1 && btnAxisTitle.getSelection()) {
                btnAxisTitle.setSelection(false);
                this.detachPopup((Widget)btnAxisTitle);
            } else {
                this.refreshPopupSheet();
            }
        } else if (e.widget == this.btnLabelVisible) {
            if (this.btnLabelVisible.getSelectionState() == 0) {
                this.getAxisForProcessing().getLabel().unsetVisible();
            } else {
                this.getAxisForProcessing().getLabel().setVisible(this.btnLabelVisible.getSelectionState() == 1);
            }
            this.setStateOfLabel();
            Button btnAxisLabel = this.getToggleButton(".Label");
            if (this.btnLabelVisible.getSelectionState() != 1 && btnAxisLabel.getSelection()) {
                btnAxisLabel.setSelection(false);
                this.detachPopup((Widget)btnAxisLabel);
            } else {
                this.refreshPopupSheet();
            }
        } else if (e.widget.equals(this.btnFormatSpecifier)) {
            this.handleFormatBtnSelected();
        } else if (e.widget == this.btnStaggered) {
            if (this.btnStaggered.getSelectionState() == 0) {
                this.getAxisForProcessing().unsetStaggered();
            } else {
                this.getAxisForProcessing().setStaggered(this.btnStaggered.getSelectionState() == 1);
            }
        }
    }

    protected void updateReverseStateByCategoryAxisUI() {
        int state = this.btnCategoryAxis.getSelectionState();
        boolean enabledUI = ((ChartWizardContext)this.getContext()).getUIFactory().canEnableUI(this.btnCategoryAxis);
        this.updateReverseUI(enabledUI);
        if (state == 0) {
            this.btnReverse.setSelectionState(0);
            ((ChartWithAxes)this.getChart()).unsetReverseCategory();
        } else if (state == 2) {
            this.btnReverse.setSelectionState(2);
            ((ChartWithAxes)this.getChart()).setReverseCategory(false);
        }
    }

    protected void handleFormatBtnSelected() {
        Object sAxisTitle = Messages.getString("OrthogonalAxisDataSheetImpl.Lbl.OrthogonalAxis");
        try {
            String sTitleString = this.getTitleValue();
            int iSeparatorIndex = sTitleString.indexOf("=");
            if (iSeparatorIndex > 0) {
                sTitleString = sTitleString.substring(iSeparatorIndex);
            } else if (iSeparatorIndex == 0) {
                sTitleString = sTitleString.substring("=".length());
            }
            sAxisTitle = (String)sAxisTitle + " (" + sTitleString + ")";
        }
        catch (NullPointerException sTitleString) {
            // empty catch block
        }
        FormatSpecifier formatspecifier = null;
        if (this.getAxisForProcessing().getFormatSpecifier() != null) {
            formatspecifier = this.getAxisForProcessing().getFormatSpecifier();
        }
        ((ChartWizardContext)this.getContext()).getUIServiceProvider().getFormatSpecifierHandler().handleFormatSpecifier(this.cmpContent.getShell(), (String)sAxisTitle, new AxisType[]{this.getAxisForProcessing().getType()}, formatspecifier, (EObject)this.getAxisForProcessing(), "formatSpecifier", (ChartWizardContext)this.getContext());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void convertSampleData(AxisType axisType) {
        if (this.getAxisAngleType() == 1) {
            if (axisType == null) {
                axisType = AxisType.TEXT_LITERAL;
            }
            BaseSampleData bsd = (BaseSampleData)((Chart)this.getChart()).getSampleData().getBaseSampleData().get(0);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation(), (int)0));
        } else if (this.getAxisAngleType() == 2) {
            if (axisType == null) {
                axisType = AxisType.LINEAR_LITERAL;
            }
            int iStartIndex = this.getFirstSeriesDefinitionIndexForAxis();
            int iEndIndex = iStartIndex + this.getAxisForProcessing().getSeriesDefinitions().size();
            int iOSDSize = ((Chart)this.getChart()).getSampleData().getOrthogonalSampleData().size();
            int i = 0;
            while (i < iOSDSize) {
                OrthogonalSampleData osd = (OrthogonalSampleData)((Chart)this.getChart()).getSampleData().getOrthogonalSampleData().get(i);
                if (osd.getSeriesDefinitionIndex() >= iStartIndex && osd.getSeriesDefinitionIndex() <= iEndIndex) {
                    osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)osd.getDataSetRepresentation(), (int)i));
                }
                ++i;
            }
        }
    }

    private int getFirstSeriesDefinitionIndexForAxis() {
        int iTmp = 0;
        int i = 0;
        while (i < this.getIndex()) {
            iTmp += ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()), (int)i).getSeriesDefinitions().size();
            ++i;
        }
        return iTmp;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.lneLabelSpan) {
            this.getAxisForProcessing().setLabelSpan(this.lneLabelSpan.getValue());
        }
    }

    private Axis getOppositeAxis() {
        if (this.getAxisAngleType() == 1) {
            return ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()), (int)0);
        }
        return ChartUIUtil.getAxisXForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()));
    }

    private IDataElementComposite createDataElementComposite(Composite parent) {
        Axis oAxis = this.getOppositeAxis();
        DataElement data = this.getAxisForProcessing().getOrigin().getValue();
        if (oAxis.getType().getValue() == 3 && !oAxis.isCategoryAxis()) {
            if (!(data instanceof DateTimeDataElement)) {
                data = DateTimeDataElementImpl.create((Calendar)new CDateTime(1970, 1, 1, 0, 0, 0));
            }
            return ((ChartWizardContext)this.getContext()).getUIFactory().createDateTimeDataElementComposite(parent, 2048, (DateTimeDataElement)data, false, (EObject)this.getAxisForProcessing().getOrigin(), "value");
        }
        if (!(data instanceof NumberDataElement)) {
            data = NumberDataElementImpl.create((double)0.0);
        }
        return ((ChartWizardContext)this.getContext()).getUIFactory().createNumberDataElementComposite(parent, data, (EObject)this.getAxisForProcessing().getOrigin(), "value");
    }
}

