/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemThemeHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.util.CopyUtil;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.gef.commands.Command;

public class PasteReportItemThemeCommand
extends Command {
    protected static final Logger logger = Logger.getLogger(PasteReportItemThemeCommand.class.getName());
    private IElementCopy copyData;
    private SlotHandle container;
    private ThemeHandle theme;

    public PasteReportItemThemeCommand(IElementCopy copyData, SlotHandle container, ThemeHandle param) {
        this.copyData = copyData;
        this.container = container;
        this.theme = param;
    }

    public boolean canExecute() {
        return DNDUtil.handleValidateTargetCanContain(this.container, this.copyData);
    }

    public void execute() {
        try {
            ModuleHandle module = this.theme.getModuleHandle();
            Module library = module.getModule();
            DesignElementHandle source = this.copyData.getHandle(module);
            DesignElementHandle handle = CopyUtil.copy((DesignElementHandle)source).getHandle(module);
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("PasteReportItemThemeCommand >>  Starts. Source: " + String.valueOf(handle) + ",Target: " + DEUtil.getDisplayLabel(this.container));
            }
            if (handle instanceof ReportItemThemeHandle) {
                DesignElement element = handle.getElement();
                NameExecutor executor = new NameExecutor(library, element.getContainer(), element);
                INameHelper helper = executor.getNameHelper();
                String namePrefix = ((ReportItemThemeHandle)handle).getType() + "-" + this.theme.getName();
                handle.setName(null);
                String name = helper.getUniqueName("theme", handle.getElement(), namePrefix);
                handle.setName(name);
                this.container.add(handle);
            }
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("PasteReportItemThemeCommand >>  Finished");
            }
        }
        catch (Exception e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("PasteReportItemThemeCommand >>  Failed");
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

