/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ComplexUnit;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.IDimensionValueChangedListener;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.UnitPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ComplexUnitPropertyDescriptor
extends PropertyDescriptor {
    protected ComplexUnit complexUnit;
    private int style = 2048;
    protected static final String ERROR_MESSAGE = Messages.getString((String)"UnitPropertyDescriptor.error.message");
    protected static final String ERROR_BOX_TITLE = Messages.getString((String)"UnitPropertyDescriptor.error.title");
    protected String deMeasureValue;
    protected String deUnitValue;
    private boolean isReadOnly = false;

    public ComplexUnitPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    @Override
    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    @Override
    public Control getControl() {
        return this.complexUnit;
    }

    @Override
    public Control createControl(Composite parent) {
        this.complexUnit = this.isFormStyle() ? FormWidgetFactory.getInstance().createComplexUnit(parent) : new ComplexUnit(parent, this.style);
        this.complexUnit.addValueChangeListener(new IDimensionValueChangedListener(){

            public void valueChanged(String newValue, String unit) {
                ComplexUnitPropertyDescriptor.this.handleEvent(newValue, unit);
            }
        });
        this.complexUnit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ComplexUnitPropertyDescriptor.this.complexUnit.getUnits() != null && ComplexUnitPropertyDescriptor.this.complexUnit.getUnits().length > 0 && (ComplexUnitPropertyDescriptor.this.complexUnit.getUnit() == null || ComplexUnitPropertyDescriptor.this.complexUnit.getUnit().length() == 0) && ComplexUnitPropertyDescriptor.this.getDescriptorProvider() instanceof UnitPropertyDescriptorProvider) {
                    String unit = ((UnitPropertyDescriptorProvider)ComplexUnitPropertyDescriptor.this.getDescriptorProvider()).getDefaultUnit();
                    if (unit != null) {
                        ComplexUnitPropertyDescriptor.this.complexUnit.setUnit(unit);
                    } else {
                        ComplexUnitPropertyDescriptor.this.complexUnit.setUnit(ComplexUnitPropertyDescriptor.this.complexUnit.getUnits()[0]);
                    }
                }
            }
        });
        return this.complexUnit;
    }

    protected boolean validateDimensionValue(String value, String unit) {
        if (this.getDescriptorProvider() instanceof UnitPropertyDescriptorProvider) {
            return ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).validateDimensionValue(value, unit);
        }
        return true;
    }

    protected void handleEvent(String value, String unit) {
        if (!this.validateDimensionValue((String)value, unit)) {
            ExceptionUtil.openError((String)ERROR_BOX_TITLE, (String)ERROR_MESSAGE);
            this.load();
            return;
        }
        if (value == null || ((String)value).equals("")) {
            value = null;
        } else {
            String unitName;
            if (this.getDescriptorProvider() instanceof UnitPropertyDescriptorProvider && (unitName = ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getUnitName(unit)) != null) {
                value = (String)value + unitName;
            }
            if (((String)value).equals(this.deMeasureValue + this.deUnitValue)) {
                return;
            }
        }
        try {
            this.save(value);
        }
        catch (SemanticException e) {
            this.complexUnit.setValue(Double.parseDouble(this.deMeasureValue));
            WidgetUtil.processError((Shell)this.complexUnit.getShell(), (Exception)((Object)e));
        }
    }

    @Override
    public void load() {
        if (this.getDescriptorProvider() instanceof UnitPropertyDescriptorProvider) {
            this.deMeasureValue = ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getMeasureValue();
            if (this.deMeasureValue == null) {
                this.deMeasureValue = "";
            }
            if (!this.deMeasureValue.equals(String.valueOf(this.complexUnit.getValue()))) {
                try {
                    this.complexUnit.setValue(this.deMeasureValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Object[] items = ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getUnitItems();
            if (!Arrays.equals(this.complexUnit.getUnits(), items)) {
                this.complexUnit.setUnits((String[])items);
            }
            try {
                this.deUnitValue = ((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getUnitDisplayName(((UnitPropertyDescriptorProvider)this.getDescriptorProvider()).getUnit());
            }
            catch (Exception e) {
                ExceptionUtil.handle((Throwable)e);
                return;
            }
            if (this.deUnitValue == null) {
                this.complexUnit.deselectUnit();
            } else if (!this.deUnitValue.equals(this.complexUnit.getUnit())) {
                this.complexUnit.selectUnit(Arrays.asList(items).indexOf(this.deUnitValue));
            }
        }
    }

    @Override
    public void save(Object obj) throws SemanticException {
        if (!this.isReadOnly) {
            this.getDescriptorProvider().save(obj);
        }
    }

    public void setReadOnly(boolean isReadOnly) {
        this.complexUnit.setReadOnly(isReadOnly);
        this.isReadOnly = isReadOnly;
    }

    public void setVisible(boolean isVisible) {
        this.complexUnit.setVisible(isVisible);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.complexUnit, (boolean)isHidden);
    }
}

