/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.publisher;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;

public class GatheringComputer
implements FileUtils.IPathComputer {
    private static final String PROVIDED_PATH = ":PROVIDED:";
    private final LinkedHashMap<File, String> filesMap = new LinkedHashMap();

    public IPath computePath(File source) {
        String prefix = this.filesMap.get(source);
        IPath result = null;
        if (prefix.startsWith(PROVIDED_PATH)) {
            result = IPath.fromOSString((String)prefix.substring(10));
        } else {
            result = IPath.fromOSString((String)source.getAbsolutePath());
            IPath rootPath = IPath.fromOSString((String)prefix);
            result = result.removeFirstSegments(rootPath.matchingFirstSegments(result));
        }
        return result.setDevice(null);
    }

    public void reset() {
    }

    public void addAll(GatheringComputer computer) {
        this.filesMap.putAll(computer.filesMap);
    }

    public void addFiles(String prefix, String[] files) {
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            this.filesMap.put(new File(prefix, file), prefix);
            ++n2;
        }
    }

    public void addFile(String prefix, String file) {
        this.filesMap.put(new File(prefix, file), prefix);
    }

    public void addFile(String computedPath, File file) {
        this.filesMap.put(file, PROVIDED_PATH + computedPath);
    }

    public File[] getFiles() {
        Set<File> keys = this.filesMap.keySet();
        return keys.toArray(new File[keys.size()]);
    }

    public int size() {
        return this.filesMap.size();
    }
}

