/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.dtd.core.internal.emf.DTDAttribute;
import org.eclipse.wst.dtd.core.internal.emf.DTDBasicType;
import org.eclipse.wst.dtd.core.internal.emf.DTDDefaultKind;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDEnumGroupKind;
import org.eclipse.wst.dtd.core.internal.emf.DTDEnumerationType;
import org.eclipse.wst.dtd.core.internal.emf.DTDLexicalInfo;
import org.eclipse.wst.dtd.core.internal.emf.DTDObject;
import org.eclipse.wst.dtd.core.internal.emf.DTDPackage;
import org.eclipse.wst.dtd.core.internal.emf.DTDType;
import org.eclipse.wst.dtd.core.internal.emf.impl.DTDFactoryImpl;

public class DTDAttributeImpl
extends EAttributeImpl
implements DTDAttribute {
    DTDLexicalInfo lexInfo = new DTDLexicalInfo();
    protected static final String COMMENT_EDEFAULT = null;
    protected String comment = COMMENT_EDEFAULT;
    protected static final DTDDefaultKind DEFAULT_KIND_EDEFAULT = DTDDefaultKind.IMPLIED_LITERAL;
    protected DTDDefaultKind defaultKind = DEFAULT_KIND_EDEFAULT;
    protected static final String DEFAULT_VALUE_STRING_EDEFAULT = null;
    protected String defaultValueString = DEFAULT_VALUE_STRING_EDEFAULT;
    protected DTDEntity attributeNameReferencedEntity;
    protected DTDEntity attributeTypeReferencedEntity;

    @Override
    public DTDType getDTDType() {
        return (DTDType)this.getEType();
    }

    @Override
    public void setDTDType(DTDType type) {
        this.setEType((EClassifier)type);
    }

    @Override
    public void setDTDBasicType(int value) {
        DTDFactoryImpl factory = (DTDFactoryImpl)DTDFactoryImpl.instance();
        switch (value) {
            case 0: {
                this.setDTDType(factory.getDTDBasicType_NONE());
                break;
            }
            case 1: {
                this.setDTDType(factory.getDTDBasicType_CDATA());
                break;
            }
            case 2: {
                this.setDTDType(factory.getDTDBasicType_ID());
                break;
            }
            case 3: {
                this.setDTDType(factory.getDTDBasicType_IDREF());
                break;
            }
            case 4: {
                this.setDTDType(factory.getDTDBasicType_IDREFS());
                break;
            }
            case 5: {
                this.setDTDType(factory.getDTDBasicType_ENTITY());
                break;
            }
            case 6: {
                this.setDTDType(factory.getDTDBasicType_ENTITIES());
                break;
            }
            case 7: {
                this.setDTDType(factory.getDTDBasicType_NMTOKEN());
                break;
            }
            case 8: {
                this.setDTDType(factory.getDTDBasicType_NMTOKENS());
            }
        }
    }

    @Override
    public String unparse() {
        StringBuffer result = new StringBuffer(128);
        result.append(this.getName());
        StringBuffer value = new StringBuffer();
        switch (this.getDefaultKind().getValue()) {
            case 1: {
                value.append("#IMPLIED");
                break;
            }
            case 2: {
                value.append("#REQUIRED");
                break;
            }
            case 3: {
                String type = this.getDTDType().toString();
                if (type.equals("Identifier (ID)") || type.equals("ID Reference (IDREF)") || type.equals("Enumerated Name Tokens") || type.equals("ID References (IDREFS)")) break;
                value.append("#FIXED \"").append(this.getDefaultValueString()).append("\"");
                break;
            }
            case 4: {
                String defaultValue = this.getDefaultValueString();
                if (defaultValue == null) break;
                value.append("\"").append(defaultValue).append("\"");
            }
        }
        DTDEntity typeEnt = this.getAttributeTypeReferencedEntity();
        if (typeEnt != null) {
            result.append(" %" + typeEnt.getName() + "; ").append(value);
        } else {
            DTDType dtdType = this.getDTDType();
            if (dtdType instanceof DTDBasicType) {
                switch (((DTDBasicType)dtdType).getKind().getValue()) {
                    case 1: {
                        result.append(" CDATA ").append(value);
                        break;
                    }
                    case 2: {
                        result.append(" ID ").append(value);
                        break;
                    }
                    case 3: {
                        result.append(" IDREF ").append(value);
                        break;
                    }
                    case 4: {
                        result.append(" IDREFS ").append(value);
                        break;
                    }
                    case 5: {
                        result.append(" ENTITY ").append(value);
                        break;
                    }
                    case 6: {
                        result.append(" ENTITIES ").append(value);
                        break;
                    }
                    case 7: {
                        result.append(" NMTOKEN ").append(value);
                        break;
                    }
                    case 8: {
                        result.append(" NMTOKENS ").append(value);
                    }
                }
            } else if (dtdType instanceof DTDEnumerationType) {
                result.append(" ").append(this.buildEnumString((DTDEnumerationType)dtdType)).append(value);
            }
        }
        return result.toString();
    }

    private String buildEnumString(DTDEnumerationType enumType) {
        Iterator i;
        String result = "";
        if (enumType.getKind().getValue() == 2) {
            result = String.valueOf(result) + "NOTATION ";
        }
        if ((i = enumType.getEnumLiterals().iterator()).hasNext()) {
            result = String.valueOf(result) + "(" + ((EEnumLiteral)i.next()).toString();
            while (i.hasNext()) {
                result = String.valueOf(result) + " | " + ((EEnumLiteral)i.next()).toString();
            }
            result = String.valueOf(result) + ") ";
        }
        return result;
    }

    @Override
    public DTDEnumerationType createDTDEnumeration(String[] enumValues, int enumKind) {
        DTDEnumerationType enumeration = DTDFactoryImpl.instance().createDTDEnumerationType();
        DTDEnumGroupKind groupKind = DTDEnumGroupKind.get(enumKind);
        enumeration.setKind(groupKind);
        if (enumValues != null) {
            int i = 0;
            while (i < enumValues.length) {
                EcorePackage ePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
                EEnumLiteral enumLiteral = ((EcoreFactory)ePackage.getEFactoryInstance()).createEEnumLiteral();
                enumLiteral.setName(enumValues[i]);
                enumLiteral.setValue(i);
                enumeration.getEnumLiterals().add((Object)enumLiteral);
                ++i;
            }
        }
        this.getDTDElement().getDTDFile().getDTDEnumerationType().add((Object)enumeration);
        return enumeration;
    }

    @Override
    public String getPathname() {
        return null;
    }

    @Override
    public DTDObject findObject(String relativePath) {
        return null;
    }

    @Override
    public Collection getEnumeratedValues() {
        ArrayList<String> result = new ArrayList<String>();
        DTDType type = this.getDTDType();
        if (type instanceof DTDEnumerationType) {
            DTDEnumerationType enumType = (DTDEnumerationType)type;
            Iterator i = enumType.getEnumLiterals().iterator();
            while (i.hasNext()) {
                result.add(((EEnumLiteral)i.next()).toString());
            }
        }
        return result;
    }

    @Override
    public int getStartOffset() {
        return this.lexInfo.getStartOffset();
    }

    @Override
    public void setStartOffset(int v) {
        this.lexInfo.setStartOffset(v);
    }

    @Override
    public int getEndOffset() {
        return this.lexInfo.getEndOffset();
    }

    @Override
    public void setEndOffset(int v) {
        this.lexInfo.setEndOffset(v);
    }

    protected EClass eStaticClass() {
        return DTDPackage.Literals.DTD_ATTRIBUTE;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String newComment) {
        String oldComment = this.comment;
        this.comment = newComment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldComment, (Object)this.comment));
        }
    }

    @Override
    public DTDDefaultKind getDefaultKind() {
        return this.defaultKind;
    }

    @Override
    public void setDefaultKind(DTDDefaultKind newDefaultKind) {
        DTDDefaultKind oldDefaultKind = this.defaultKind;
        DTDDefaultKind dTDDefaultKind = this.defaultKind = newDefaultKind == null ? DEFAULT_KIND_EDEFAULT : newDefaultKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, (Object)oldDefaultKind, (Object)this.defaultKind));
        }
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultValueString;
    }

    @Override
    public void setDefaultValueString(String newDefaultValueString) {
        String oldDefaultValueString = this.defaultValueString;
        this.defaultValueString = newDefaultValueString;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldDefaultValueString, (Object)this.defaultValueString));
        }
    }

    @Override
    public DTDEntity getAttributeNameReferencedEntity() {
        if (this.attributeNameReferencedEntity != null && this.attributeNameReferencedEntity.eIsProxy()) {
            InternalEObject oldAttributeNameReferencedEntity = (InternalEObject)this.attributeNameReferencedEntity;
            this.attributeNameReferencedEntity = (DTDEntity)this.eResolveProxy(oldAttributeNameReferencedEntity);
            if (this.attributeNameReferencedEntity != oldAttributeNameReferencedEntity && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 23, (Object)oldAttributeNameReferencedEntity, (Object)this.attributeNameReferencedEntity));
            }
        }
        return this.attributeNameReferencedEntity;
    }

    public DTDEntity basicGetAttributeNameReferencedEntity() {
        return this.attributeNameReferencedEntity;
    }

    public NotificationChain basicSetAttributeNameReferencedEntity(DTDEntity newAttributeNameReferencedEntity, NotificationChain msgs) {
        DTDEntity oldAttributeNameReferencedEntity = this.attributeNameReferencedEntity;
        this.attributeNameReferencedEntity = newAttributeNameReferencedEntity;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldAttributeNameReferencedEntity, (Object)newAttributeNameReferencedEntity);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setAttributeNameReferencedEntity(DTDEntity newAttributeNameReferencedEntity) {
        if (newAttributeNameReferencedEntity != this.attributeNameReferencedEntity) {
            NotificationChain msgs = null;
            if (this.attributeNameReferencedEntity != null) {
                msgs = ((InternalEObject)this.attributeNameReferencedEntity).eInverseRemove((InternalEObject)this, 6, DTDEntity.class, msgs);
            }
            if (newAttributeNameReferencedEntity != null) {
                msgs = ((InternalEObject)newAttributeNameReferencedEntity).eInverseAdd((InternalEObject)this, 6, DTDEntity.class, msgs);
            }
            if ((msgs = this.basicSetAttributeNameReferencedEntity(newAttributeNameReferencedEntity, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)newAttributeNameReferencedEntity, (Object)newAttributeNameReferencedEntity));
        }
    }

    @Override
    public DTDEntity getAttributeTypeReferencedEntity() {
        if (this.attributeTypeReferencedEntity != null && this.attributeTypeReferencedEntity.eIsProxy()) {
            InternalEObject oldAttributeTypeReferencedEntity = (InternalEObject)this.attributeTypeReferencedEntity;
            this.attributeTypeReferencedEntity = (DTDEntity)this.eResolveProxy(oldAttributeTypeReferencedEntity);
            if (this.attributeTypeReferencedEntity != oldAttributeTypeReferencedEntity && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 24, (Object)oldAttributeTypeReferencedEntity, (Object)this.attributeTypeReferencedEntity));
            }
        }
        return this.attributeTypeReferencedEntity;
    }

    public DTDEntity basicGetAttributeTypeReferencedEntity() {
        return this.attributeTypeReferencedEntity;
    }

    public NotificationChain basicSetAttributeTypeReferencedEntity(DTDEntity newAttributeTypeReferencedEntity, NotificationChain msgs) {
        DTDEntity oldAttributeTypeReferencedEntity = this.attributeTypeReferencedEntity;
        this.attributeTypeReferencedEntity = newAttributeTypeReferencedEntity;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 24, (Object)oldAttributeTypeReferencedEntity, (Object)newAttributeTypeReferencedEntity);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setAttributeTypeReferencedEntity(DTDEntity newAttributeTypeReferencedEntity) {
        if (newAttributeTypeReferencedEntity != this.attributeTypeReferencedEntity) {
            NotificationChain msgs = null;
            if (this.attributeTypeReferencedEntity != null) {
                msgs = ((InternalEObject)this.attributeTypeReferencedEntity).eInverseRemove((InternalEObject)this, 7, DTDEntity.class, msgs);
            }
            if (newAttributeTypeReferencedEntity != null) {
                msgs = ((InternalEObject)newAttributeTypeReferencedEntity).eInverseAdd((InternalEObject)this, 7, DTDEntity.class, msgs);
            }
            if ((msgs = this.basicSetAttributeTypeReferencedEntity(newAttributeTypeReferencedEntity, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, (Object)newAttributeTypeReferencedEntity, (Object)newAttributeTypeReferencedEntity));
        }
    }

    @Override
    public DTDElement getDTDElement() {
        if (this.eContainerFeatureID() != 25) {
            return null;
        }
        return (DTDElement)this.eContainer();
    }

    public NotificationChain basicSetDTDElement(DTDElement newDTDElement, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newDTDElement, 25, msgs);
        return msgs;
    }

    @Override
    public void setDTDElement(DTDElement newDTDElement) {
        if (newDTDElement != this.eInternalContainer() || this.eContainerFeatureID() != 25 && newDTDElement != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newDTDElement)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newDTDElement != null) {
                msgs = ((InternalEObject)newDTDElement).eInverseAdd((InternalEObject)this, 27, DTDElement.class, msgs);
            }
            if ((msgs = this.basicSetDTDElement(newDTDElement, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 25, (Object)newDTDElement, (Object)newDTDElement));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 23: {
                if (this.attributeNameReferencedEntity != null) {
                    msgs = ((InternalEObject)this.attributeNameReferencedEntity).eInverseRemove((InternalEObject)this, 6, DTDEntity.class, msgs);
                }
                return this.basicSetAttributeNameReferencedEntity((DTDEntity)otherEnd, msgs);
            }
            case 24: {
                if (this.attributeTypeReferencedEntity != null) {
                    msgs = ((InternalEObject)this.attributeTypeReferencedEntity).eInverseRemove((InternalEObject)this, 7, DTDEntity.class, msgs);
                }
                return this.basicSetAttributeTypeReferencedEntity((DTDEntity)otherEnd, msgs);
            }
            case 25: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetDTDElement((DTDElement)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 23: {
                return this.basicSetAttributeNameReferencedEntity(null, msgs);
            }
            case 24: {
                return this.basicSetAttributeTypeReferencedEntity(null, msgs);
            }
            case 25: {
                return this.basicSetDTDElement(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 25: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 27, DTDElement.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 20: {
                return this.getComment();
            }
            case 21: {
                return this.getDefaultKind();
            }
            case 22: {
                return this.getDefaultValueString();
            }
            case 23: {
                if (resolve) {
                    return this.getAttributeNameReferencedEntity();
                }
                return this.basicGetAttributeNameReferencedEntity();
            }
            case 24: {
                if (resolve) {
                    return this.getAttributeTypeReferencedEntity();
                }
                return this.basicGetAttributeTypeReferencedEntity();
            }
            case 25: {
                return this.getDTDElement();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 20: {
                this.setComment((String)newValue);
                return;
            }
            case 21: {
                this.setDefaultKind((DTDDefaultKind)((Object)newValue));
                return;
            }
            case 22: {
                this.setDefaultValueString((String)newValue);
                return;
            }
            case 23: {
                this.setAttributeNameReferencedEntity((DTDEntity)newValue);
                return;
            }
            case 24: {
                this.setAttributeTypeReferencedEntity((DTDEntity)newValue);
                return;
            }
            case 25: {
                this.setDTDElement((DTDElement)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 20: {
                this.setComment(COMMENT_EDEFAULT);
                return;
            }
            case 21: {
                this.setDefaultKind(DEFAULT_KIND_EDEFAULT);
                return;
            }
            case 22: {
                this.setDefaultValueString(DEFAULT_VALUE_STRING_EDEFAULT);
                return;
            }
            case 23: {
                this.setAttributeNameReferencedEntity(null);
                return;
            }
            case 24: {
                this.setAttributeTypeReferencedEntity(null);
                return;
            }
            case 25: {
                this.setDTDElement(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 20: {
                return COMMENT_EDEFAULT == null ? this.comment != null : !COMMENT_EDEFAULT.equals(this.comment);
            }
            case 21: {
                return this.defaultKind != DEFAULT_KIND_EDEFAULT;
            }
            case 22: {
                return DEFAULT_VALUE_STRING_EDEFAULT == null ? this.defaultValueString != null : !DEFAULT_VALUE_STRING_EDEFAULT.equals(this.defaultValueString);
            }
            case 23: {
                return this.attributeNameReferencedEntity != null;
            }
            case 24: {
                return this.attributeTypeReferencedEntity != null;
            }
            case 25: {
                return this.getDTDElement() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (comment: ");
        result.append(this.comment);
        result.append(", defaultKind: ");
        result.append((Object)this.defaultKind);
        result.append(", defaultValueString: ");
        result.append(this.defaultValueString);
        result.append(')');
        return result.toString();
    }
}

