/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogStatistics;
import org.eclipse.datatools.enablement.ibm.db2.catalog.JavaProcedureInfo;
import org.eclipse.datatools.enablement.ibm.db2.catalog.util.JavaProcedureProviderRegistry;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogParameter;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrivilege;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWCatalogMessages;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ExtendedOptions;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2JavaOptions;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ModelFactory;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Procedure;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Source;
import org.eclipse.datatools.enablement.ibm.db2.model.impl.DB2ProcedureImpl;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.DataAccess;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogProcedure
extends DB2ProcedureImpl
implements ICatalogObject,
IDatabaseObject {
    private boolean loaded = false;
    private boolean dependencyLoaded = false;
    private boolean parameterLoaded = false;
    private boolean sourceLoaded = false;
    private boolean javaProcedureLoaded = false;
    private boolean externalNameLoaded = false;
    private boolean privilegeLoaded = false;
    private JavaProcedureInfo myJavaProcedureInfo;
    private boolean db2PackageLoaded = false;
    protected String db2Package;
    private boolean statisticsLoaded = false;
    private boolean impactsLoaded = false;
    private Collection impacts = new ArrayList();
    private Collection statistics = new ArrayList();

    public void refresh() {
        this.loaded = false;
        if (this.parameterLoaded) {
            this.parameters.clear();
            this.parameterLoaded = false;
        }
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        if (this.sourceLoaded) {
            this.source = null;
            this.extendedOptions.clear();
            this.sourceLoaded = false;
        }
        this.javaProcedureLoaded = false;
        this.privilegeLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
        if ((1 & refreshType) == 1) {
            this.statistics.clear();
            this.statisticsLoaded = false;
        }
    }

    public String getLanguage() {
        return super.getLanguage();
    }

    public boolean isDeterministic() {
        return super.isDeterministic();
    }

    public String getParameterStyle() {
        return super.getParameterStyle();
    }

    public String getFenced() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getFenced();
        }
        if (!this.loaded) {
            this.load();
        }
        return super.getFenced();
    }

    public boolean isFederated() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.isFederated();
        }
        if (!this.loaded) {
            this.load();
        }
        return super.isFederated();
    }

    public int getMaxResultSets() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getMaxResultSets();
        }
        if (!this.loaded) {
            this.load();
        }
        return super.getMaxResultSets();
    }

    public boolean isImplicitSchema() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.isImplicitSchema();
        }
        if (!this.loaded) {
            this.load();
        }
        return this.implicitSchema;
    }

    public Source getSource() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getSource();
        }
        if (!this.loaded) {
            this.load();
        }
        this.loadSource();
        return super.getSource();
    }

    public DB2JavaOptions getJavaOptions() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getJavaOptions();
        }
        this.loadJavaProcedure();
        return super.getJavaOptions();
    }

    private String getJavaSPDb2Package() {
        String javaSPDb2Package = "";
        if ("JAVA".equals(this.getLanguage())) {
            JavaProcedureInfo javaProcedureInfo = this.getJavaProcedureInfo();
            javaSPDb2Package = javaProcedureInfo != null ? javaProcedureInfo.getDB2Package() : "";
        }
        return javaSPDb2Package;
    }

    public String getDb2Package() {
        if (!this.db2PackageLoaded) {
            if ("JAVA".equals(this.getLanguage())) {
                JavaProcedureInfo javaProcedureInfo = this.getJavaProcedureInfo();
                this.db2Package = javaProcedureInfo != null ? javaProcedureInfo.getDB2Package() : "";
            } else {
                this.load();
            }
            this.db2PackageLoaded = true;
        }
        return this.db2Package;
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    public EList getParameters() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getParameters();
        }
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.parameters;
    }

    public DataAccess getSqlDataAccess() {
        return this.sqlDataAccess;
    }

    public String getThreadsafe() {
        if (!this.loaded) {
            this.load();
        }
        return this.threadsafe;
    }

    public String getExternalName() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getExternalName();
        }
        if ("JAVA".equals(this.getLanguage()) && !this.externalNameLoaded) {
            this.loadExternalName();
        }
        return super.getExternalName();
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public EList getExtendedOptions() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getExtendedOptions();
        }
        if (!this.loaded) {
            this.load();
        }
        this.loadSource();
        return this.extendedOptions;
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        if (!this.statisticsLoaded) {
            this.statistics = LUWCatalogProcedure.getStatistics(this.getConnection(), (Routine)this);
            this.statisticsLoaded = true;
        }
        return this.statistics;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 9) {
            this.getLanguage();
        } else if (id == 28) {
            this.isFederated();
        } else if (id == 24) {
            this.getFenced();
        } else if (id == 21) {
            this.getMaxResultSets();
        } else if (id == 19) {
            this.getSource();
        } else if (id == 44) {
            this.getJavaOptions();
        } else if (id == 10) {
            this.getParameterStyle();
        } else if (id == 11) {
            this.isDeterministic();
        } else if (id == 2) {
            this.getDependencies();
        } else if (id == 18) {
            this.getParameters();
        } else if (id == 12) {
            this.getSqlDataAccess();
        } else if (id == 25) {
            this.getThreadsafe();
        } else if (id == 7) {
            this.getPrivileges();
        } else if (id == 36) {
            this.getExtendedOptions();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        String version = definition.getVersion();
        try {
            Float.parseFloat(version.substring(1));
        }
        catch (NumberFormatException numberFormatException) {}
        definition.getDataModelElementFactory();
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("WITH PP(PROCSCHEMA, PROCNAME, SPECIFICNAME, DEFINER, PARM_COUNT, DETERMINISTIC, FENCED, LANGUAGE, IMPLEMENTATION, CLASS, JAR_ID, JAR_SCHEMA, PARM_STYLE, CONTAINS_SQL, PROGRAM_TYPE, RESULT_SETS, THREADSAFE, FEDERATED, REMARKS) AS (SELECT ROUTINESCHEMA, ROUTINENAME, SPECIFICNAME, DEFINER, PARM_COUNT, DETERMINISTIC, FENCED, LANGUAGE, IMPLEMENTATION, CLASS, JAR_ID, JARSCHEMA, PARAMETER_STYLE, SQL_DATA_ACCESS, PROGRAMTYPE, RESULT_SETS, THREADSAFE, FEDERATED, REMARKS FROM SYSCAT.ROUTINES WHERE ROUTINETYPE = 'P') SELECT PROCSCHEMA, PROCNAME, SPECIFICNAME, DEFINER, PARM_COUNT, DETERMINISTIC, FENCED, LANGUAGE, IMPLEMENTATION, CLASS, JAR_ID, JAR_SCHEMA, PARM_STYLE, CONTAINS_SQL, PROGRAM_TYPE, RESULT_SETS, THREADSAFE, FEDERATED, REMARKS, BNAME AS PACKAGENAME FROM PP LEFT OUTER JOIN SYSIBM.SYSDEPENDENCIES PD ON (PD.DSCHEMA = PP.PROCSCHEMA AND PD.DNAME = PP.SPECIFICNAME AND PD.BTYPE = 'K')  WHERE PROCSCHEMA='" + LUWUtil.getIdentifier(this.getSchema().getName()) + "' AND PROCNAME='" + LUWUtil.getIdentifier(this.getName()) + "'" + " AND SPECIFICNAME='" + LUWUtil.getIdentifier(this.getSpecificName()) + "'");
            while (r.next()) {
                int resultSets;
                String deterministic = r.getString("DETERMINISTIC");
                if (deterministic.equals("Y")) {
                    this.setDeterministic(true);
                } else {
                    this.setDeterministic(false);
                }
                String sql_data_access = r.getString("CONTAINS_SQL");
                this.sqlDataAccess = sql_data_access.equals("C") ? DataAccess.CONTAINS_SQL_LITERAL : (sql_data_access.equals("M") ? DataAccess.MODIFIES_SQL_DATA_LITERAL : (sql_data_access.equals("N") ? DataAccess.NO_SQL_LITERAL : DataAccess.READS_SQL_DATA_LITERAL));
                String paramStyle = r.getString("PARM_STYLE");
                if (paramStyle.equals("DB2SQL")) {
                    this.setParameterStyle("DB2SQL");
                } else if (paramStyle.equals("DB2GENRL")) {
                    this.setParameterStyle("DB2GENRAL");
                } else if (paramStyle.equals("GENERAL")) {
                    this.setParameterStyle("GENERAL");
                } else if (paramStyle.equals("GNRLNULL")) {
                    this.setParameterStyle("GENERAL WITH NULLS");
                } else if (paramStyle.equals("JAVA")) {
                    this.setParameterStyle("JAVA");
                } else {
                    this.setParameterStyle("SQL");
                }
                this.parameterStyle = paramStyle.trim();
                String fenced = r.getString("FENCED");
                this.fenced = fenced.equals("Y") ? "FENCED" : "NOT FENCED";
                String threadsafe = r.getString("THREADSAFE");
                this.threadsafe = threadsafe.equals("Y") ? "THREADSAFE" : "NOT THREADSAFE";
                String federated = r.getString("FEDERATED");
                this.federated = federated.equals("Y");
                this.maxResultSets = resultSets = r.getInt("RESULT_SETS");
                String packagename = r.getString("PACKAGENAME");
                if (!"JAVA".equals(this.getLanguage())) {
                    this.db2Package = packagename;
                    this.db2PackageLoaded = true;
                }
                String externalName = r.getString("IMPLEMENTATION");
                if (!"JAVA".equals(this.getLanguage()) && !"SQL".equals(this.getLanguage())) {
                    this.setExternalName(externalName);
                }
                this.updateImplicitSchemaFlag();
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized JavaProcedureInfo getJavaProcedureInfo() {
        if (this.myJavaProcedureInfo != null) {
            return this.myJavaProcedureInfo;
        }
        Database database = this.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        this.myJavaProcedureInfo = JavaProcedureProviderRegistry.INSTANCE.getProvider(databaseDefinition).getProviderInstance((DB2Procedure)this, this.getConnection());
        return this.myJavaProcedureInfo;
    }

    private synchronized void loadSource() {
        if (this.sourceLoaded) {
            return;
        }
        this.sourceLoaded = true;
        EList extList = super.getExtendedOptions();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String lang = this.getLanguage();
            if ("JAVA".equals(lang)) {
                JavaProcedureInfo javaProcedureInfo = this.getJavaProcedureInfo();
                Object s = null;
                s = javaProcedureInfo != null ? javaProcedureInfo.getSource() : DB2ModelFactory.eINSTANCE.createDB2Source();
                this.setSource((Source)s);
                DB2ExtendedOptions extOpts = DB2ModelFactory.eINSTANCE.createDB2ExtendedOptions();
                if (javaProcedureInfo != null) {
                    extOpts.setColid(javaProcedureInfo.getCollectionName());
                }
                extList.add((Object)extOpts);
            } else if ("SQL".equals(lang)) {
                Connection connection = this.getConnection();
                Statement s = connection.createStatement();
                ResultSet r = s.executeQuery("SELECT TEXT, DEBUG_MODE FROM SYSCAT.ROUTINES  WHERE ROUTINESCHEMA='" + LUWUtil.getIdentifier(this.getSchema().getName()) + "' AND ROUTINENAME='" + LUWUtil.getIdentifier(this.getName()) + "'" + " AND SPECIFICNAME='" + LUWUtil.getIdentifier(this.getSpecificName()) + "'");
                String text = "";
                String debugMode = "";
                while (r.next()) {
                    String expression = r.getString("TEXT");
                    if (expression != null) {
                        text = String.valueOf(text) + expression.trim() + " ";
                    }
                    debugMode = r.getString("DEBUG_MODE");
                }
                text = text.replaceAll("[\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f]", " ");
                DB2Source source = DB2ModelFactory.eINSTANCE.createDB2Source();
                source.setBody(text);
                if (this.getDb2Package() != null) {
                    source.setDb2PackageName(this.getDb2Package());
                }
                this.setSource((Source)source);
                r.close();
                s.close();
                DB2ExtendedOptions extOpts = DB2ModelFactory.eINSTANCE.createDB2ExtendedOptions();
                if ("ALLOW".equalsIgnoreCase(debugMode.trim())) {
                    extOpts.setForDebug(true);
                } else {
                    extOpts.setForDebug(false);
                }
                extList.add((Object)extOpts);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadJavaProcedure() {
        if (this.javaProcedureLoaded) {
            return;
        }
        this.javaProcedureLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            JavaProcedureInfo javaProcedureInfo;
            String lang = this.getLanguage();
            if ("JAVA".equals(lang) && (javaProcedureInfo = this.getJavaProcedureInfo()) != null) {
                this.setJavaOptions(javaProcedureInfo.getJavaProcedure());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadExternalName() {
        if (this.externalNameLoaded) {
            return;
        }
        this.externalNameLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        JavaProcedureInfo javaProcedureInfo = this.getJavaProcedureInfo();
        if (javaProcedureInfo != null) {
            this.setExternalName(javaProcedureInfo.getExternalName());
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogProcedure.loadDependencies(this.getConnection(), super.getDependencies(), (Routine)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadParameters() {
        if (this.parameterLoaded) {
            return;
        }
        this.parameterLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogProcedure.loadParameters(this.getConnection(), super.getParameters(), (Routine)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogProcedure.loadPrivileges(this.getConnection(), privileges, (Routine)this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadDependencies(Connection connection, EList dependencyList, Routine routine) throws SQLException {
        Database database = routine.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery("SELECT BSCHEMA, BNAME, BTYPE FROM SYSCAT.ROUTINEDEP WHERE ROUTINESCHEMA='" + LUWUtil.getIdentifier(routine.getSchema().getName()) + "' AND ROUTINENAME='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'");
        try {
            while (r.next()) {
                String bschema = r.getString(1).trim();
                String bname = r.getString(2);
                String btype = r.getString(3);
                Table obj = null;
                if (btype.equals("A")) {
                    obj = LUWCatalogProcedure.getTable(routine, bschema, bname);
                } else if (btype.equals("F")) {
                    obj = LUWCatalogProcedure.getRountine(routine, bschema, bname);
                } else {
                    if (btype.equals("O")) continue;
                    if (btype.equals("R")) {
                        obj = LUWCatalogProcedure.getUserDefinedType(routine, bschema, bname);
                    } else if (btype.equals("S")) {
                        obj = LUWCatalogProcedure.getTable(routine, bschema, bname);
                    } else if (btype.equals("T")) {
                        obj = LUWCatalogProcedure.getTable(routine, bschema, bname);
                    } else if (btype.equals("U")) {
                        obj = LUWCatalogProcedure.getTable(routine, bschema, bname);
                    } else if (btype.equals("V")) {
                        obj = LUWCatalogProcedure.getTable(routine, bschema, bname);
                    } else if (btype.equals("W")) {
                        obj = LUWCatalogProcedure.getTable(routine, bschema, bname);
                    } else {
                        if (btype.equals("X") || !btype.equals("N")) continue;
                        obj = LUWCatalogProcedure.getTable(routine, bschema, bname);
                    }
                }
                if (obj == null) continue;
                Dependency dep = (Dependency)factory.create(SQLSchemaPackage.eINSTANCE.getDependency());
                dep.setTargetEnd((EObject)obj);
                dependencyList.add((Object)dep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadParameters(Connection connection, EList parameterList, Routine routine) throws SQLException {
        Database database = routine.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        databaseDefinition.getDataModelElementFactory();
        String query = "SELECT PARMNAME,ROWTYPE,LOCATOR,TYPESCHEMA,TYPENAME,LENGTH,SCALE,CODEPAGE,REMARKS,TARGET_TYPESCHEMA,TARGET_TYPENAME FROM SYSCAT.ROUTINEPARMS WHERE ROUTINESCHEMA='" + LUWUtil.getIdentifier(routine.getSchema().getName()) + "'" + " AND ROUTINENAME='" + LUWUtil.getIdentifier(routine.getName()) + "'" + " AND SPECIFICNAME='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'" + " ORDER BY ORDINAL";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                String typeSchemaName;
                PredefinedDataTypeDefinition typeDefinition;
                LUWCatalogParameter parameter = new LUWCatalogParameter();
                String name = r.getString("PARMNAME");
                parameter.setName(name);
                String rowtype = r.getString("ROWTYPE").trim();
                if (rowtype.equals("B")) {
                    parameter.setMode(ParameterMode.INOUT_LITERAL);
                } else if (rowtype.equals("O")) {
                    parameter.setMode(ParameterMode.OUT_LITERAL);
                } else if (rowtype.equals("P")) {
                    parameter.setMode(ParameterMode.IN_LITERAL);
                }
                String locator = r.getString("LOCATOR");
                if (locator.equals("Y")) {
                    parameter.setLocator(true);
                } else {
                    parameter.setLocator(false);
                }
                String typeName = r.getString("TYPENAME");
                if (typeName.equalsIgnoreCase("FLOAT")) {
                    int length = r.getInt("LENGTH");
                    typeName = length == 4 ? "REAL" : "DOUBLE";
                }
                if ((typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName)) != null) {
                    EStructuralFeature feature;
                    int length;
                    int codePage;
                    if (typeDefinition.getPrimitiveType().getValue() == 0) {
                        int codePage2 = r.getInt(8);
                        if (codePage2 == 0) {
                            typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("CHAR () FOR BIT DATA");
                        }
                    } else if (typeDefinition.getPrimitiveType().getValue() == 1 && (codePage = r.getInt(8)) == 0) {
                        typeDefinition = typeName.equals("LONG VARCHAR") ? databaseDefinition.getPredefinedDataTypeDefinition("LONG VARCHAR FOR BIT DATA") : databaseDefinition.getPredefinedDataTypeDefinition("VARCHAR () FOR BIT DATA");
                    }
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        length = r.getInt("LENGTH");
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)length);
                    } else if (typeDefinition.isPrecisionSupported()) {
                        if (typeName.equals("TIMESTAMP")) {
                            int length2 = r.getInt("SCALE");
                            feature = type.eClass().getEStructuralFeature("fractionalSecondsPrecision");
                            type.eSet(feature, (Object)length2);
                        } else {
                            int length3 = r.getInt("LENGTH");
                            if (typeName.equals("DECFLOAT")) {
                                length3 = length3 == 8 ? 16 : 34;
                            }
                            feature = type.eClass().getEStructuralFeature("precision");
                            type.eSet(feature, (Object)length3);
                        }
                    }
                    if (typeDefinition.isScaleSupported()) {
                        length = r.getInt("SCALE");
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)length);
                    }
                    parameter.setContainedType((SQLDataType)type);
                } else if (typeName.equals("REFERENCE")) {
                    typeSchemaName = r.getString("TARGET_TYPESCHEMA").trim();
                    String udtName = r.getString("TARGET_TYPENAME");
                    parameter.setReferencedType(LUWCatalogProcedure.getUserDefinedType(routine, typeSchemaName, udtName));
                } else {
                    typeSchemaName = r.getString("TYPESCHEMA").trim();
                    parameter.setReferencedType(LUWCatalogProcedure.getUserDefinedType(routine, typeSchemaName, typeName));
                }
                parameter.setDescription(r.getString("REMARKS"));
                parameterList.add((Object)parameter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static void loadPrivileges(Connection connection, EList privilegeList, Routine routine, String granteeFilter) throws SQLException {
        Schema schema = routine.getSchema();
        Database database = ModelHelper.getDatabase((Schema)schema);
        int options = ((LUWCatalogDatabase)database).getLoadOptions();
        if ((options & 0x800) == 2048) {
            return;
        }
        Statement s = connection.createStatement();
        String query = "SELECT GRANTOR,GRANTEE,GRANTEETYPE,EXECUTEAUTH FROM SYSCAT.ROUTINEAUTH WHERE SCHEMA='" + LUWUtil.getIdentifier(schema.getName()) + "'" + " AND SPECIFICNAME='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'";
        if (granteeFilter != null && !"".equals(granteeFilter)) {
            query = String.valueOf(query) + " AND " + granteeFilter;
        }
        ResultSet r = s.executeQuery(query);
        try {
            String userName = connection.getMetaData().getUserName();
            while (r.next()) {
                String grantorId = r.getString("GRANTOR").trim();
                AuthorizationIdentifier grantor = LUWCatalogDatabase.getAuthorizationId(database, grantorId, null);
                String granteeId = r.getString("GRANTEE").trim();
                AuthorizationIdentifier grantee = null;
                String granteeType = r.getString("GRANTEETYPE");
                grantee = "G".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "G") : ("R".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "R") : LUWCatalogDatabase.getAuthorizationId(database, granteeId, "U"));
                boolean isSystemGranted = granteeId.equalsIgnoreCase(userName);
                String alterAuth = r.getString("EXECUTEAUTH");
                if (alterAuth.equals("N")) continue;
                LUWCatalogPrivilege privilege = new LUWCatalogPrivilege();
                privilege.setAction("EXECUTE");
                if (alterAuth.equals("G")) {
                    privilege.setGrantable(true);
                }
                privilegeList.add((Object)privilege);
                privilege.setGrantor(grantor);
                privilege.setGrantee(grantee);
                LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    public static Schema getSchema(Routine routine, String schemaName) {
        Schema s2 = routine.getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database db = s2.getDatabase();
        if (db instanceof LUWCatalogDatabase && (s2 = ((LUWCatalogDatabase)db).getSchema(schemaName)) != null) {
            return s2;
        }
        for (Schema s2 : db.getSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        LUWCatalogSchema schema = new LUWCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(db);
        if (db instanceof LUWCatalogDatabase) {
            ((LUWCatalogDatabase)db).cacheSchema((Schema)schema);
        }
        return schema;
    }

    public static Table getTable(Routine routine, String schemaName, String tableName) {
        Table t;
        Schema schema = LUWCatalogProcedure.getSchema(routine, schemaName);
        if (schema instanceof LUWCatalogSchema && (t = ((LUWCatalogSchema)schema).getTable(schemaName, tableName)) != null) {
            return t;
        }
        for (Table table : schema.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public static Routine getRountine(Routine routine, String schemaName, String specificName) {
        Schema schema = LUWCatalogProcedure.getSchema(routine, schemaName);
        for (Routine r : schema.getRoutines()) {
            if (!specificName.equals(r.getSpecificName())) continue;
            return r;
        }
        return null;
    }

    public static UserDefinedType getUserDefinedType(Routine routine, String schemaName, String userDefinedTypeName) {
        Schema schema = LUWCatalogProcedure.getSchema(routine, schemaName);
        for (UserDefinedType userDefinedType : schema.getUserDefinedTypes()) {
            if (!userDefinedType.getName().equals(userDefinedTypeName)) continue;
            return userDefinedType;
        }
        return null;
    }

    public static Trigger getTrigger(Routine routine, String schemaName, String tabName, String triggerName) {
        Table table = LUWCatalogProcedure.getTable(routine, schemaName, tabName);
        if (table != null) {
            for (Trigger r : table.getTriggers()) {
                if (!r.getName().equals(triggerName)) continue;
                return r;
            }
        }
        return null;
    }

    public static TableConstraint getTableConstraint(Routine routine, String schemaName, String tableName, String constName) {
        Table t = LUWCatalogProcedure.getTable(routine, schemaName, tableName);
        if (!(t instanceof BaseTable)) {
            return null;
        }
        for (TableConstraint constraint : ((BaseTable)t).getConstraints()) {
            if (!constraint.getName().equals(constName)) continue;
            return constraint;
        }
        return null;
    }

    public static DB2Package getDb2Package(Routine routine, String schemaName, String pkgName, String pkgUniqueID) {
        Schema schema = LUWCatalogProcedure.getSchema(routine, schemaName);
        if (schema instanceof LUWCatalogSchema) {
            return ((LUWCatalogSchema)schema).getDB2Package(pkgName, pkgUniqueID);
        }
        return null;
    }

    private void updateImplicitSchemaFlag() {
        Source src;
        String body;
        boolean b = false;
        if (this != null && !(b = this.isImplicitSchema()) && this.getLanguage().equalsIgnoreCase("SQL") && (body = (src = this.getSource()).getBody()) != null) {
            String[] tokens = body.split(" ");
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].indexOf(46) > -1) break;
                if (tokens[i].indexOf(40) > -1) {
                    b = true;
                    break;
                }
                ++i;
            }
        }
        this.setImplicitSchema(b);
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogProcedure.getImpactedTriggers(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedTables(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedConstraints(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedRoutines(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedPackages(connection, (Routine)this));
        return impacts;
    }

    protected static Collection getImpactedTriggers(Connection connection, Routine routine) {
        ArrayList<Trigger> impacts = new ArrayList<Trigger>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT DISTINCT A.TABSCHEMA, A.TABNAME, A.TRIGNAME FROM SYSCAT.TRIGGERS A, SYSCAT.TRIGDEP B WHERE (B.BNAME='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'" + " AND B.BSCHEMA='" + LUWUtil.getIdentifier(routine.getSchema().getName()) + "'" + " AND B.BTYPE='F'" + " AND A.TRIGNAME=B.TRIGNAME" + " AND A.TRIGSCHEMA=B.TRIGSCHEMA)" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String trigName = r.getString("TRIGNAME").trim();
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Trigger trigger = LUWCatalogProcedure.getTrigger(routine, schemaName, tabName, trigName);
                if (trigger == null) continue;
                impacts.add(trigger);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedTables(Connection connection, Routine routine) {
        ArrayList<Table> impacts = new ArrayList<Table>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT DISTINCT TABNAME, TABSCHEMA FROM SYSCAT.TABDEP WHERE BTYPE='F' AND BNAME ='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'" + " AND BSCHEMA = '" + LUWUtil.getIdentifier(routine.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Table t = LUWCatalogProcedure.getTable(routine, schemaName, tabName);
                if (t == null) continue;
                impacts.add(t);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedConstraints(Connection connection, Routine routine) {
        ArrayList<TableConstraint> impacts = new ArrayList<TableConstraint>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT CONSTNAME,TABNAME,TABSCHEMA FROM SYSCAT.CONSTDEP WHERE BTYPE='F' AND BNAME='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(routine.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String constName = r.getString("CONSTNAME").trim();
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                TableConstraint constraint = LUWCatalogProcedure.getTableConstraint(routine, schemaName, tabName, constName);
                if (constraint == null) continue;
                impacts.add(constraint);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedRoutines(Connection connection, Routine routine) {
        ArrayList<Routine> impacts = new ArrayList<Routine>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT ROUTINENAME,ROUTINESCHEMA FROM SYSCAT.ROUTINEDEP WHERE BTYPE='F' AND BNAME='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(routine.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String routineName = r.getString("ROUTINENAME").trim();
                String schemaName = r.getString("ROUTINESCHEMA").trim();
                Routine p = LUWCatalogProcedure.getRountine(routine, schemaName, routineName);
                if (p == null) continue;
                impacts.add(p);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    protected static Collection getImpactedPackages(Connection connection, Routine routine) {
        ArrayList<DB2Package> impacts = new ArrayList<DB2Package>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT PKGNAME, PKGSCHEMA, HEX(UNIQUE_ID) AS UID FROM SYSCAT.PACKAGEDEP WHERE BTYPE = 'F' AND BNAME='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(routine.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String pkgUniqueID;
                String pkgName = r.getString("PKGNAME").trim();
                String schemaName = r.getString("PKGSCHEMA").trim();
                DB2Package p = LUWCatalogProcedure.getDb2Package(routine, schemaName, pkgName, pkgUniqueID = r.getString("UID").trim());
                if (p == null) continue;
                impacts.add(p);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return impacts;
    }

    public static Collection getStatistics(Connection connection, Routine routine) {
        ArrayList<CatalogStatistics> statistics = new ArrayList<CatalogStatistics>();
        try {
            String query = "SELECT IOS_PER_INVOC,INSTS_PER_INVOC,IOS_PER_ARGBYTE,INSTS_PER_ARGBYTE,PERCENT_ARGBYTES,INITIAL_IOS,INITIAL_INSTS,CARDINALITY,SELECTIVITY FROM SYSSTAT.ROUTINES WHERE ROUTINESCHEMA='" + LUWUtil.getIdentifier(routine.getSchema().getName()) + "'" + " AND ROUTINENAME ='" + LUWUtil.getIdentifier(routine.getName()) + "'" + " AND SPECIFICNAME ='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'" + " FOR FETCH ONLY";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                float selectivity;
                BigInteger card;
                float initial_insts;
                float initial_ios;
                int percent_Argbyte;
                float insts_per_Argbyte;
                float ios_per_Argbyte;
                float insts_per_Invoc;
                CatalogStatistics stats = null;
                float ios_per_Invoc = r.getFloat("IOS_PER_INVOC");
                if (ios_per_Invoc != -1.0f) {
                    stats = new CatalogStatistics("IOS_PER_INVOC", LUWCatalogMessages.STAT_IOS_PER_INVOC, LUWCatalogMessages.STAT_IOS_PER_INVOC_DES, ios_per_Invoc, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((insts_per_Invoc = r.getFloat("INSTS_PER_INVOC")) != -1.0f) {
                    stats = new CatalogStatistics("INSTS_PER_INVOC", LUWCatalogMessages.STAT_INSTS_PER_INVOC, LUWCatalogMessages.STAT_INSTS_PER_INVOC_DES, insts_per_Invoc, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((ios_per_Argbyte = r.getFloat("IOS_PER_ARGBYTE")) != -1.0f) {
                    stats = new CatalogStatistics("IOS_PER_ARGBYTE", LUWCatalogMessages.STAT_IOS_PER_ARGBYTE, LUWCatalogMessages.STAT_IOS_PER_ARGBYTE_DES, ios_per_Argbyte, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((insts_per_Argbyte = r.getFloat("INSTS_PER_ARGBYTE")) != -1.0f) {
                    stats = new CatalogStatistics("INSTS_PER_ARGBYTE", LUWCatalogMessages.STAT_INSTS_PER_ARGBYTE, LUWCatalogMessages.STAT_INSTS_PER_ARGBYTE_DES, insts_per_Argbyte, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((percent_Argbyte = r.getInt("PERCENT_ARGBYTES")) != -1) {
                    stats = new CatalogStatistics("PERCENT_ARGBYTES", LUWCatalogMessages.STAT_PERCENT_ARGBYTE, LUWCatalogMessages.STAT_PERCENT_ARGBYTE_DES, percent_Argbyte, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((initial_ios = r.getFloat("INITIAL_IOS")) != -1.0f) {
                    stats = new CatalogStatistics("INITIAL_IOS", LUWCatalogMessages.STAT_INITIAL_IOS, LUWCatalogMessages.STAT_INITIAL_IOS_DES, initial_ios, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((initial_insts = r.getFloat("INITIAL_INSTS")) != -1.0f) {
                    stats = new CatalogStatistics("INITIAL_INSTS", LUWCatalogMessages.STAT_INITIAL_INSTS, LUWCatalogMessages.STAT_INITIAL_INSTS_DES, initial_insts, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((card = r.getBigDecimal("CARDINALITY").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("CARDINALITY", LUWCatalogMessages.STAT_ROUTINE_CARDINALITY, LUWCatalogMessages.STAT_ROUTINE_CARDINALITY_DES, card, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((selectivity = r.getFloat("SELECTIVITY")) == -1.0f) continue;
                stats = new CatalogStatistics("SELECTIVITY", LUWCatalogMessages.STAT_SELECTIVITY, LUWCatalogMessages.STAT_SELECTIVITY_DES, selectivity, "SYSSTAT.ROUTINES");
                statistics.add(stats);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return statistics;
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogProcedure.loadPrivileges(this.getConnection(), privileges, (Routine)this, granteeFilter);
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }
}

