/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ErrorDialogWithToggle
extends ErrorDialog {
    private String fPreferenceKey;
    private String fToggleMessage1;
    private Button fToggleButton;
    private String fToggleMessage2;
    private Button fToggleButton2;
    IPreferenceStore fStore = null;

    public ErrorDialogWithToggle(Shell parentShell, String dialogTitle, String message, IStatus status, String preferenceKey, String toggleMessage1, String toggleMessage2, IPreferenceStore store) {
        super(parentShell, dialogTitle, message, status, 7);
        this.fStore = store;
        this.fPreferenceKey = preferenceKey;
        this.fToggleMessage1 = toggleMessage1;
        this.fToggleMessage2 = toggleMessage2;
    }

    public ErrorDialogWithToggle(Shell parentShell, String dialogTitle, String message, IStatus status, String preferenceKey, String toggleMessage, IPreferenceStore store) {
        super(parentShell, dialogTitle, message, status, 7);
        this.fStore = store;
        this.fPreferenceKey = preferenceKey;
        this.fToggleMessage1 = toggleMessage;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        dialogComposite.setFont(parent.getFont());
        this.setToggleButton(this.createCheckButton(dialogComposite, this.fToggleMessage1));
        if (this.fToggleMessage2 != null) {
            this.fToggleButton2 = this.createCheckButton(dialogComposite, this.fToggleMessage2);
        }
        this.getToggleButton().setSelection(!this.fStore.getBoolean(this.fPreferenceKey));
        ErrorDialogWithToggle.applyDialogFont((Control)dialogComposite);
        return dialogComposite;
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData(0);
        data.horizontalIndent = 40;
        data.horizontalSpan = 2;
        data.horizontalAlignment = 1;
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        return button;
    }

    protected void buttonPressed(int id, IDebugTarget target) {
        if (id == 0) {
            this.storePreference(target);
        }
        super.buttonPressed(id);
    }

    private void storePreference(IDebugTarget target) {
        this.fStore.setValue(this.fPreferenceKey, !this.getToggleButton().getSelection());
        if (this.fToggleButton2 != null && target instanceof JDIDebugTarget) {
            JDIDebugTarget jdiTarget = (JDIDebugTarget)target;
            jdiTarget.setHcrDebugErrorPref(this.fToggleButton2.getSelection());
        }
    }

    protected Button getToggleButton() {
        return this.fToggleButton;
    }

    protected void setToggleButton(Button button) {
        this.fToggleButton = button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setFocus();
    }
}

