/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.io.ObjectStreamClass;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.util.ClassResolverObjectInputStream;
import org.eclipse.ecf.core.util.IClassResolver;
import org.osgi.framework.Bundle;

public class BundleClassResolver
implements IClassResolver {
    private final Bundle bundle;

    public BundleClassResolver(Bundle b) {
        Assert.isNotNull((Object)b);
        this.bundle = b;
    }

    protected void verifyClass(ObjectStreamClass desc) throws ClassNotFoundException {
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        this.verifyClass(desc);
        try {
            return this.bundle.loadClass(desc.getName());
        }
        catch (IllegalStateException e) {
            throw new ClassNotFoundException("Cannot load class=" + String.valueOf(desc) + " because bundle=" + this.bundle.getSymbolicName() + " has been uninstalled");
        }
        catch (ClassNotFoundException e) {
            return ClassResolverObjectInputStream.resolvePrimitiveClass(desc, e);
        }
    }
}

