/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.util;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.datatools.sqltools.common.ui.util.SingleCharReader;

public abstract class SubstitutionTextReader
extends SingleCharReader {
    protected static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private Reader _fReader;
    private boolean _fWasWhiteSpace;
    private int _fCharAfterWhiteSpace;
    private boolean _fSkipWhiteSpace = true;
    private boolean _fReadFromBuffer;
    private StringBuffer _fBuffer;
    private int _fIndex;

    protected SubstitutionTextReader(Reader reader) {
        this._fReader = reader;
        this._fBuffer = new StringBuffer();
        this._fIndex = 0;
        this._fReadFromBuffer = false;
        this._fCharAfterWhiteSpace = -1;
        this._fWasWhiteSpace = true;
    }

    protected abstract String computeSubstitution(int var1) throws IOException;

    protected Reader getReader() {
        return this._fReader;
    }

    protected int nextChar() throws IOException {
        boolean bl = this._fReadFromBuffer = this._fBuffer.length() > 0;
        if (this._fReadFromBuffer) {
            char ch = this._fBuffer.charAt(this._fIndex++);
            if (this._fIndex >= this._fBuffer.length()) {
                this._fBuffer.setLength(0);
                this._fIndex = 0;
            }
            return ch;
        }
        int ch = this._fCharAfterWhiteSpace;
        if (ch == -1) {
            ch = this._fReader.read();
        }
        if (this._fSkipWhiteSpace && Character.isWhitespace((char)ch)) {
            while (Character.isWhitespace((char)(ch = this._fReader.read()))) {
            }
            if (ch != -1) {
                this._fCharAfterWhiteSpace = ch;
                return 32;
            }
        } else {
            this._fCharAfterWhiteSpace = -1;
        }
        return ch;
    }

    @Override
    public int read() throws IOException {
        int c;
        block0: do {
            c = this.nextChar();
            while (!this._fReadFromBuffer) {
                String s = this.computeSubstitution(c);
                if (s == null) continue block0;
                if (s.length() > 0) {
                    this._fBuffer.insert(0, s);
                }
                c = this.nextChar();
            }
        } while (this._fSkipWhiteSpace && this._fWasWhiteSpace && c == 32);
        this._fWasWhiteSpace = c == 32 || c == 13 || c == 10;
        return c;
    }

    @Override
    public boolean ready() throws IOException {
        return this._fReader.ready();
    }

    @Override
    public void close() throws IOException {
        this._fReader.close();
    }

    @Override
    public void reset() throws IOException {
        this._fReader.reset();
        this._fWasWhiteSpace = true;
        this._fCharAfterWhiteSpace = -1;
        this._fBuffer.setLength(0);
        this._fIndex = 0;
    }

    protected final void setSkipWhitespace(boolean state) {
        this._fSkipWhiteSpace = state;
    }

    protected final boolean isSkippingWhitespace() {
        return this._fSkipWhiteSpace;
    }
}

