/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.samples;

import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.samples.SampleWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProjectNamesPage
extends WizardPage {
    private final SampleWizard wizard;
    private Composite container;

    public ProjectNamesPage(SampleWizard wizard) {
        super("projects");
        this.wizard = wizard;
        this.setTitle(PDEUIMessages.ProjectNamesPage_title);
        this.setDescription(PDEUIMessages.ProjectNamesPage_desc);
    }

    public void setVisible(boolean visible) {
        this.setPageComplete(this.wizard.getSelection() != null);
        if (this.container != null) {
            this.updateEntries();
        }
        super.setVisible(visible);
    }

    void updateEntries() {
        IConfigurationElement selection = this.wizard.getSelection();
        if (selection != null) {
            this.setMessage(null);
            IConfigurationElement[] projects = selection.getChildren("project");
            Control[] children = this.container.getChildren();
            if (projects.length == 1 && children.length == 2) {
                Text text = (Text)children[1];
                text.setText(projects[0].getAttribute("name"));
                this.validateEntries();
                return;
            }
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
            if (projects.length == 1) {
                this.createEntry(PDEUIMessages.ProjectNamesPage_projectName, projects[0].getAttribute("name"));
            } else {
                i = 0;
                while (i < projects.length) {
                    String label = NLS.bind((String)PDEUIMessages.ProjectNamesPage_multiProjectName, (Object)("" + (i + 1)));
                    this.createEntry(label, projects[i].getAttribute("name"));
                    ++i;
                }
            }
            this.container.layout();
            this.validateEntries();
        } else {
            this.setMessage(PDEUIMessages.ProjectNamesPage_noSampleFound, 2);
        }
    }

    public String[] getProjectNames() {
        Control[] children = this.container.getChildren();
        String[] names = new String[children.length / 2];
        int index = 0;
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Text) {
                String name = ((Text)children[i]).getText();
                names[index++] = name;
            }
            ++i;
        }
        return names;
    }

    private void createEntry(String labelName, String projectName) {
        Label label = new Label(this.container, 0);
        label.setText(labelName);
        label.setLayoutData((Object)new GridData(4));
        Text text = new Text(this.container, 2052);
        text.setText(projectName);
        text.addModifyListener(e -> this.validateEntries());
        text.setLayoutData((Object)new GridData(768));
    }

    private void validateEntries() {
        Control[] children = this.container.getChildren();
        boolean empty = false;
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Text) {
                String name = ((Text)children[i]).getText();
                if (name.length() == 0) {
                    empty = true;
                    break;
                }
                IStatus nameStatus = PDEPlugin.getWorkspace().validateName(name, 4);
                if (!nameStatus.isOK()) {
                    this.setErrorMessage(nameStatus.getMessage());
                    this.setPageComplete(false);
                    return;
                }
                set.add(name);
            }
            ++i;
        }
        if (empty) {
            this.setErrorMessage(PDEUIMessages.ProjectNamesPage_emptyName);
            this.setPageComplete(false);
        } else {
            int nfields = children.length / 2;
            int nnames = set.size();
            if (nfields > nnames) {
                this.setErrorMessage(PDEUIMessages.ProjectNamesPage_duplicateNames);
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
                this.setErrorMessage(null);
            }
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        this.setControl((Control)this.container);
        this.updateEntries();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.container, "org.eclipse.pde.doc.user.project_names_page");
    }
}

