/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ApplyStyleAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class ApplyStyleMenuAction
extends MenuUpdateAction {
    public static final String ID = "apply style menu";

    public ApplyStyleMenuAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
    }

    @Override
    protected List getItems() {
        ArrayList<ApplyStyleAction> actionList = new ArrayList<ApplyStyleAction>();
        StyleHandle currentStyle = this.getStyleHandle();
        ApplyStyleAction reset = new ApplyStyleAction(null);
        reset.setSelection(this.getSelection());
        reset.setChecked(currentStyle == null);
        actionList.add(reset);
        actionList.add(null);
        Iterator iterator = DEUtil.getStyles();
        if (iterator != null) {
            while (iterator.hasNext()) {
                SharedStyleHandle handle = (SharedStyleHandle)iterator.next();
                if (handle.isPredefined()) continue;
                ApplyStyleAction action = new ApplyStyleAction(handle);
                action.setSelection(this.getSelection());
                action.setChecked(currentStyle == handle);
                actionList.add(action);
            }
        }
        return actionList;
    }

    private StyleHandle getStyleHandle() {
        Object firstElement;
        IStructuredSelection selection = InsertInLayoutUtil.editPart2Model(this.getSelection());
        if (!selection.isEmpty() && (firstElement = DNDUtil.unwrapToModel((Object)selection.getFirstElement())) instanceof DesignElementHandle) {
            if (firstElement instanceof RowHandle || firstElement instanceof ColumnHandle) {
                selection = InsertInLayoutUtil.editPart2Model(TableUtil.filletCellInSelectionEditorpart(this.getSelection()));
            }
            List modelList = DNDUtil.unwrapToModel((List)selection.toList());
            SharedStyleHandle style = ((DesignElementHandle)firstElement).getStyle();
            for (Object obj : modelList) {
                if (obj instanceof DesignElementHandle && ((DesignElementHandle)obj).getStyle() == style) continue;
                return null;
            }
            return style;
        }
        return null;
    }
}

