/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.exception;

import com.ibm.icu.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class BirtException
extends Exception {
    private static final long serialVersionUID = -2152858415308815725L;
    protected final String sResourceKey;
    protected final Object[] oaMessageArguments;
    protected final transient ResourceBundle rb;
    protected String pluginId;
    protected int severity = 4;
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int CANCEL = 8;

    public BirtException(String message) {
        this.sResourceKey = message;
        this.rb = null;
        this.oaMessageArguments = null;
    }

    @Deprecated
    public BirtException(String errorCode, ResourceBundle bundle) {
        this.sResourceKey = errorCode;
        this.rb = bundle;
        this.oaMessageArguments = null;
    }

    @Deprecated
    public BirtException(String errorCode, ResourceBundle bundle, Throwable cause) {
        super(cause);
        this.sResourceKey = errorCode;
        this.rb = bundle;
        this.oaMessageArguments = null;
    }

    @Deprecated
    public BirtException(String errorCode, Object[] args, ResourceBundle bundle, Throwable cause) {
        super(cause);
        this.sResourceKey = errorCode;
        this.oaMessageArguments = args;
        this.rb = bundle;
    }

    @Deprecated
    public BirtException(String errorCode, Object arg0, ResourceBundle bundle, Throwable cause) {
        super(cause);
        this.sResourceKey = errorCode;
        this.rb = bundle;
        this.oaMessageArguments = new Object[]{arg0};
    }

    @Deprecated
    public BirtException(String errorCode, Object[] args, ResourceBundle bundle) {
        this.sResourceKey = errorCode;
        this.oaMessageArguments = args;
        this.rb = bundle;
    }

    @Deprecated
    public BirtException(String errorCode, Object arg0, ResourceBundle bundle) {
        this.sResourceKey = errorCode;
        this.rb = bundle;
        this.oaMessageArguments = new Object[]{arg0};
    }

    @Deprecated
    public BirtException(String errorCode, Object arg0) {
        this.sResourceKey = errorCode;
        this.oaMessageArguments = new Object[]{arg0};
        this.rb = null;
    }

    @Deprecated
    public BirtException(String errorCode, Object[] args, Throwable cause) {
        super(cause);
        this.sResourceKey = errorCode;
        this.oaMessageArguments = args;
        this.rb = null;
    }

    public BirtException(String pluginId, String errorCode, ResourceBundle bundle) {
        this.pluginId = pluginId;
        this.sResourceKey = errorCode;
        this.rb = bundle;
        this.oaMessageArguments = null;
    }

    public BirtException() {
        this.sResourceKey = null;
        this.rb = null;
        this.oaMessageArguments = null;
    }

    public BirtException(String pluginId, String errorCode, ResourceBundle bundle, Throwable cause) {
        super(cause);
        this.pluginId = pluginId;
        this.sResourceKey = errorCode;
        this.rb = bundle;
        this.oaMessageArguments = null;
    }

    public BirtException(String pluginId, String errorCode, Object[] args, ResourceBundle bundle, Throwable cause) {
        super(cause);
        this.pluginId = pluginId;
        this.sResourceKey = errorCode;
        this.oaMessageArguments = args;
        this.rb = bundle;
    }

    public BirtException(String pluginId, String errorCode, Object arg0, ResourceBundle bundle, Throwable cause) {
        super(cause);
        this.pluginId = pluginId;
        this.sResourceKey = errorCode;
        this.rb = bundle;
        this.oaMessageArguments = new Object[]{arg0};
    }

    public BirtException(String pluginId, String errorCode, Object[] args, ResourceBundle bundle) {
        this.pluginId = pluginId;
        this.sResourceKey = errorCode;
        this.oaMessageArguments = args;
        this.rb = bundle;
    }

    public BirtException(String pluginId, String errorCode, Object arg0, ResourceBundle bundle) {
        this.pluginId = pluginId;
        this.sResourceKey = errorCode;
        this.rb = bundle;
        this.oaMessageArguments = new Object[]{arg0};
    }

    public BirtException(String pluginId, String errorCode, Object arg0) {
        this.pluginId = pluginId;
        this.sResourceKey = errorCode;
        this.oaMessageArguments = new Object[]{arg0};
        this.rb = null;
    }

    public BirtException(String pluginId, String errorCode, Object[] args, Throwable cause) {
        super(cause);
        this.pluginId = pluginId;
        this.sResourceKey = errorCode;
        this.oaMessageArguments = args;
        this.rb = null;
    }

    public String getErrorCode() {
        return this.sResourceKey;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(this.sResourceKey);
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(this.sResourceKey);
    }

    protected String getLocalizedMessage(String errorCode) {
        String localizedMessage;
        Locale locale = null;
        if (this.rb == null) {
            localizedMessage = errorCode;
        } else {
            locale = this.rb.getLocale();
            try {
                localizedMessage = this.rb.getString(errorCode);
            }
            catch (Exception e) {
                localizedMessage = errorCode;
            }
        }
        try {
            MessageFormat form = new MessageFormat(localizedMessage, locale == null ? Locale.getDefault() : locale);
            return form.format((Object)this.oaMessageArguments);
        }
        catch (Throwable ex) {
            return localizedMessage;
        }
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        assert (severity == 0 || severity == 4 || severity == 2 || severity == 1 || severity == 8);
        this.severity = severity;
    }
}

