/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.templating;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.stream.StreamSupport;
import org.bndtools.templating.FolderResource;
import org.bndtools.templating.Resource;
import org.bndtools.templating.URLResource;
import org.eclipse.pde.bnd.ui.templating.BuiltInTemplate;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BuiltInServiceTemplate
extends BuiltInTemplate {
    private final Bundle bundle = FrameworkUtil.getBundle(BuiltInServiceTemplate.class);

    public BuiltInServiceTemplate(String name, String basePath) {
        super(name, "stringtemplate");
        Enumeration entries = this.bundle.findEntries(basePath, "*", true);
        while (entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            String resourcePath = url.getPath().substring(basePath.length() + 1);
            if (!resourcePath.endsWith("/")) {
                this.addInputResource(resourcePath, (Resource)new URLResource(url, "UTF-8"));
                continue;
            }
            String[] stringArray = (String[])StreamSupport.stream(Paths.get(resourcePath, new String[0]).spliterator(), false).map(Path::toString).toArray(String[]::new);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.addInputResource(path, (Resource)new FolderResource());
                ++n2;
            }
        }
    }
}

