/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.ui.impl;

import java.io.IOException;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryModel;
import org.eclipse.birt.data.oda.mongodb.ui.i18n.Messages;
import org.eclipse.birt.data.oda.mongodb.ui.util.CommandExpressionUtil;
import org.eclipse.birt.data.oda.mongodb.ui.util.UIHelper;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MongoDBExpressionBuilder
extends StatusDialog {
    private static final String EMPTY_STRING = "";
    private String dialogTitle = Messages.getString("MongoDBExpressionBuilder.dialogTitle.default");
    protected String expression;
    private Button validateSyntaxBtn;
    private Button importBtn;
    private Button exportBtn;
    private Text exprText;

    public MongoDBExpressionBuilder(Shell parent) {
        super(parent);
        this.initDialogTitle();
    }

    protected void initDialogTitle() {
        this.setTitle(this.dialogTitle);
    }

    public void create() {
        super.create();
        Point pt = this.getShell().computeSize(-1, -1);
        pt.x = Math.max(pt.x, 450);
        pt.y = Math.max(pt.y, 350);
        this.getShell().setSize(pt);
        this.validateStatus();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 20;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label exprTextLabel = new Label(composite, 0);
        exprTextLabel.setText(Messages.getString("MongoDBExpressionBuilder.ExprssionText.label"));
        GridData gd = new GridData();
        gd.horizontalIndent = 6;
        exprTextLabel.setLayoutData((Object)gd);
        this.createValidateSyntaxButton(composite);
        this.createExprEditorArea(composite);
        this.createDialogHelper(composite);
        this.initDialogControls();
        return composite;
    }

    protected void createDialogHelper(Composite composite) {
    }

    private void createExprEditorArea(Composite composite) {
        Composite editorArea = new Composite(composite, 0);
        editorArea.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        editorArea.setLayoutData((Object)gd);
        this.exprText = new Text(editorArea, 2818);
        this.exprText.setLayoutData((Object)new GridData(1808));
        this.exprText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDBExpressionBuilder.this.expression = MongoDBExpressionBuilder.this.exprText.getText().trim();
                MongoDBExpressionBuilder.this.validateSyntaxBtn.setEnabled(MongoDBExpressionBuilder.this.expression.length() > 0);
                MongoDBExpressionBuilder.this.exportBtn.setEnabled(MongoDBExpressionBuilder.this.expression.length() > 0);
                MongoDBExpressionBuilder.this.validateStatus();
            }
        });
        Composite btnArea = new Composite(editorArea, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.verticalSpacing = 20;
        btnArea.setLayout((Layout)layout);
        btnArea.setLayoutData((Object)new GridData());
        this.importBtn = new Button(btnArea, 8);
        this.importBtn.setText(Messages.getString("MongoDBExpressionBuilder.Button.import"));
        this.importBtn.setToolTipText(Messages.getString("MongoDBExpressionBuilder.Button.tooltip.import"));
        this.importBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBExpressionBuilder.this.doImportCommandExpression();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.exportBtn = new Button(btnArea, 8);
        this.exportBtn.setText(Messages.getString("MongoDBExpressionBuilder.Button.export"));
        this.exportBtn.setToolTipText(Messages.getString("MongoDBExpressionBuilder.Button.tooltip.export"));
        this.exportBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(MongoDBExpressionBuilder.this.getShell(), 8196);
                dialog.setFilterExtensions(new String[]{"*.*"});
                dialog.setOverwrite(true);
                String fileName = dialog.open();
                if (fileName != null) {
                    MongoDBExpressionBuilder.this.handleExportToFile(fileName);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createValidateSyntaxButton(Composite btnArea) {
        this.validateSyntaxBtn = new Button(btnArea, 8);
        try {
            this.validateSyntaxBtn.setImage(UIHelper.getSyntaxValidationImage());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        GridData btnGd = new GridData();
        if (!Platform.getOS().equals("macosx")) {
            btnGd.widthHint = 20;
            btnGd.heightHint = 20;
        }
        this.validateSyntaxBtn.setLayoutData((Object)btnGd);
        this.validateSyntaxBtn.setToolTipText(Messages.getString("MongoDBExpressionBuilder.Button.tooltip.ValidateSyntax"));
        this.validateSyntaxBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MongoDBExpressionBuilder.this.validateExpressionSyntax();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void handleExportToFile(String fileName) {
        try {
            CommandExpressionUtil.exportToFile(fileName, this.expression);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void initDialogControls() {
        if (this.expression == null) {
            this.expression = EMPTY_STRING;
        }
        this.exprText.setText(this.expression);
        this.validateSyntaxBtn.setEnabled(this.expression.length() > 0);
        this.exportBtn.setEnabled(this.expression.length() > 0);
        this.resetButtonsWidth();
    }

    private void resetButtonsWidth() {
        int width = this.getMaxWidth((Control)this.importBtn, 60);
        width = this.getMaxWidth((Control)this.exportBtn, width);
        width = this.getMaxWidth((Control)this.validateSyntaxBtn, width) + 10;
        GridData btnGd = new GridData();
        btnGd.widthHint = width;
        this.importBtn.setLayoutData((Object)btnGd);
        this.exportBtn.setLayoutData((Object)btnGd);
    }

    private int getMaxWidth(Control control, int width) {
        int size = control.computeSize((int)-1, (int)-1).x;
        return size > width ? size : width;
    }

    private void doImportCommandExpression() {
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setFilterExtensions(new String[]{"*.*"});
        String fileName = dialog.open();
        if (fileName != null) {
            try {
                this.expression = CommandExpressionUtil.getCommandExpressionText(fileName);
                this.exprText.setText(this.expression);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void validateStatus() {
    }

    protected Status getMiscStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.ui", severity, message, null);
    }

    protected Status getOKStatus() {
        return this.getMiscStatus(0, EMPTY_STRING);
    }

    protected void validateExpressionSyntax() {
        String msgDialogTitle = Messages.getString("MongoDBExpressionBuilder.InfoDialog.title.validateSyntax");
        try {
            this.doValidateExpressionSyntax();
            String infoMsg = Messages.getString("MongoDBExpressionBuilder.Expression.DialogMessage.ValidateSyntax.IsValid");
            MessageDialog.openInformation((Shell)this.getShell(), (String)msgDialogTitle, (String)infoMsg);
        }
        catch (OdaException e1) {
            String errorMsg = UIHelper.getUserErrorMessage("MongoDBExpressionBuilder.Expression.DialogMessage.ValidateSyntax.Invalid", (Exception)((Object)e1));
            ExceptionHandler.showException((Shell)this.getShell(), (String)msgDialogTitle, (String)errorMsg, (Throwable)e1);
        }
    }

    protected void doValidateExpressionSyntax() throws OdaException {
        QueryModel.validateQuerySyntax((String)this.expression);
    }

    protected void setExpressionText(String expr) {
        this.expression = expr;
    }

    protected String getExprText() {
        return this.expression;
    }
}

