/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.ConnectionException;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.IControlConnectionManager;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.IDBItem;
import org.eclipse.datatools.sqltools.core.dbitem.IItemWithCode;
import org.eclipse.datatools.sqltools.core.internal.dbitem.SQLObjectItem;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.internal.core.ControlConnectionManager;
import org.eclipse.datatools.sqltools.internal.core.Messages;
import org.eclipse.datatools.sqltools.sql.reference.IDatatype;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.EList;

public class AbstractControlConnection
implements IControlConnection {
    protected Set _skipConnections = new HashSet();
    protected DatabaseIdentifier _databaseIdentifier;
    protected String _dbUserName = null;
    private Map _procInfoCache = new HashMap();
    protected ControlConnectionManager _manager;
    private SQLToolsManagedConnectionListener _managedConnectionListener;

    public AbstractControlConnection(IControlConnectionManager manager, DatabaseIdentifier databaseIdentifier) {
        Assert.isTrue((boolean)(manager instanceof ControlConnectionManager));
        this._manager = (ControlConnectionManager)manager;
        this._databaseIdentifier = databaseIdentifier;
        try {
            IConnectionProfile profile = ProfileUtil.getProfile(databaseIdentifier.getProfileName());
            IManagedConnection managedConn = profile.getManagedConnection("java.sql.Connection");
            this._managedConnectionListener = new SQLToolsManagedConnectionListener();
            managedConn.addConnectionListener((IManagedConnectionListener)this._managedConnectionListener);
        }
        catch (Exception e) {
            EditorCorePlugin.getDefault().log(e);
        }
    }

    public IControlConnectionManager getManager() {
        return this._manager;
    }

    @Override
    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public void profileRenamed(String name) {
        IControlConnection controlConnection = (IControlConnection)this._manager._controlConnectionMap.get(this._databaseIdentifier);
        this._manager._controlConnectionMap.remove(this._databaseIdentifier);
        this._databaseIdentifier.setProfileName(name);
        this._manager._controlConnectionMap.put(this._databaseIdentifier, controlConnection);
        this._manager.fireRefreshed(this);
    }

    public String getDatabaseName() {
        return this._databaseIdentifier.getDBname();
    }

    @Override
    public String getDbUsername() throws SQLException {
        if (this._dbUserName == null) {
            this._dbUserName = this.getReusableConnection().getMetaData().getUserName();
        }
        return this._dbUserName;
    }

    @Override
    public boolean isTextHidden(DatabaseIdentifier databaseIdentifier, String dbObjectName, int dbObjectType) {
        return false;
    }

    public void fireChange() {
        this._manager.fireRefreshed(this);
    }

    protected void dispose() {
        try {
            IConnectionProfile profile = ProfileUtil.getProfile(this._databaseIdentifier.getProfileName());
            IManagedConnection managedConn = profile.getManagedConnection("java.sql.Connection");
            managedConn.removeConnectionListener((IManagedConnectionListener)this._managedConnectionListener);
        }
        catch (NoSuchProfileException noSuchProfileException) {
        }
        catch (Exception e) {
            EditorCorePlugin.getDefault().log(e);
        }
    }

    @Override
    public boolean okToDisconnect() {
        return true;
    }

    protected void aboutToDisconnect() {
    }

    @Override
    public boolean disconnect() {
        return this.disconnect(false);
    }

    @Override
    public boolean disconnect(boolean force) {
        this.dispose();
        this._manager.remove(this);
        return true;
    }

    @Override
    public void executeDDL(String[] src) throws SQLException {
        Connection con = this.getReusableConnection();
        try (Statement stmt = con.createStatement();){
            int i = 0;
            while (i < src.length) {
                stmt.executeUpdate(src[i]);
                ++i;
            }
            this.refresh();
        }
    }

    @Override
    public ProcIdentifier[] getAllProcs() throws SQLException {
        Database db = ProfileUtil.getDatabase(this._databaseIdentifier);
        ArrayList<ProcIdentifier> procs = new ArrayList<ProcIdentifier>();
        if (db != null) {
            EList schemas = ModelUtil.getSchemas(db, this._databaseIdentifier.getDBname());
            for (Schema schema : schemas) {
                EList tables = schema.getTables();
                for (Table table : tables) {
                    EList triggers = table.getTriggers();
                    for (Trigger trigger : triggers) {
                        procs.add(SQLDevToolsUtil.getProcIdentifier(this._databaseIdentifier, (SQLObject)trigger));
                    }
                }
                EList routines = schema.getRoutines();
                for (Routine routine : routines) {
                    procs.add(SQLDevToolsUtil.getProcIdentifier(this._databaseIdentifier, (SQLObject)routine));
                }
            }
            EList events = db.getEvents();
            for (Event event : events) {
                procs.add(SQLDevToolsUtil.getProcIdentifier(this._databaseIdentifier, (SQLObject)event));
            }
        }
        return procs.toArray(new ProcIdentifier[procs.size()]);
    }

    @Override
    public String getProcSource(ProcIdentifier proc) throws SQLException {
        IDBItem item = this.getDBItem(proc);
        if (item instanceof IItemWithCode) {
            return ((IItemWithCode)((Object)item)).getCode();
        }
        throw new SQLException(Messages.AbstractControlConnection_invalid_store_procedure_description);
    }

    @Override
    public void saveRoutine(ProcIdentifier proc, String code) throws SQLException {
        IDBItem item = this.getDBItem(proc);
        if (!(item instanceof IItemWithCode)) {
            throw new SQLException(Messages.AbstractControlConnection_invalid_store_procedure_description);
        }
        ((IItemWithCode)((Object)item)).save(code);
        this._manager.fireRefreshed(this, proc);
        ModelUtil.findProceduralObject(proc, true);
    }

    @Override
    public IDBItem getDBItem(ProcIdentifier procIdentifier) {
        IDBItem item = (IDBItem)this._procInfoCache.get(procIdentifier);
        if (item == null && (item = this.createDBItem(procIdentifier)) != null) {
            this._procInfoCache.put(procIdentifier, item);
        }
        return item;
    }

    protected ProcIdentifier findSPUDF(String owner, String name) {
        for (ProcIdentifier proc : this._procInfoCache.keySet()) {
            if (proc.getType() != 0 && proc.getType() != 1 || !proc.getOwnerName().equals(owner) || !proc.getProcName().equals(name)) continue;
            return proc;
        }
        return null;
    }

    protected Map getDBItemCache() {
        return this._procInfoCache;
    }

    protected IDBItem createDBItem(ProcIdentifier proc) {
        SQLObject obj = ModelUtil.findProceduralObject(proc);
        if (obj != null) {
            return new SQLObjectItem(proc, obj, this);
        }
        return null;
    }

    @Override
    public void refresh() {
        for (IDBItem item : this._procInfoCache.values()) {
            item.dispose();
        }
        this._procInfoCache.clear();
    }

    @Override
    public void refresh(ProcIdentifier procIdentifier) {
        IDBItem item = (IDBItem)this._procInfoCache.get(procIdentifier);
        if (item != null) {
            item.dispose();
        }
        this._procInfoCache.remove(procIdentifier);
    }

    @Override
    public String convertToInternalConnId(String externalId, String exteranlName) throws ConnectionException {
        return externalId;
    }

    @Override
    public Connection createConnection(String[] connId) throws SQLException, CoreException, NoSuchProfileException {
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName(this.getDatabaseIdentifier().getProfileName());
        ConnectionService conService = f.getConnectionService();
        Connection con = conService.createConnection(this.getDatabaseIdentifier().getProfileName(), this.getDatabaseIdentifier().getDBname());
        if (connId != null && connId.length == 1) {
            connId[0] = "0";
        }
        return con;
    }

    @Override
    public Connection getReusableConnection() {
        try {
            return ProfileUtil.getReusableConnection(this._databaseIdentifier);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void registerSkip(int connid) {
        Integer id = connid;
        this._skipConnections.add(id);
    }

    public void unregisterSkip(int connid) {
        this._skipConnections.remove(connid);
    }

    protected boolean shouldSkip(int connid) {
        return this._skipConnections.contains(connid);
    }

    protected IDatatype getUserDataType(String typeName) throws SQLException {
        Database db = ProfileUtil.getDatabase(this._databaseIdentifier);
        String user = ProfileUtil.getProfileUserName(this._databaseIdentifier, false);
        DatabaseDefinition dbdef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
        for (Schema schema : db.getSchemas()) {
            if (!schema.getName().equals(user)) continue;
            EList tables = schema.getUserDefinedTypes();
            for (UserDefinedType type : tables) {
                if (!type.getName().equals(typeName)) continue;
                return ModelUtil.map(dbdef, (DataType)type, user);
            }
        }
        return null;
    }

    @Override
    public boolean supportsDebugging() {
        return false;
    }

    @Override
    public IDatatype getTypeByNameStr(String nameStr) throws Exception {
        Database db = ProfileUtil.getDatabase(this._databaseIdentifier);
        String user = ProfileUtil.getProfileUserName(this._databaseIdentifier, false);
        DatabaseDefinition dbdef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
        PredefinedDataType pretype = DataTypeHelper.getPredefinedDataTypeForNamedType((String)nameStr);
        if (pretype != null) {
            return ModelUtil.map(dbdef, (DataType)pretype, user);
        }
        return this.getUserDataType(nameStr);
    }

    public class SQLToolsManagedConnectionListener
    implements IManagedConnectionListener {
        public void opened(ConnectEvent event) {
        }

        public void modified(ConnectEvent event) {
        }

        public boolean okToClose(ConnectEvent event) {
            return AbstractControlConnection.this.okToDisconnect();
        }

        public void aboutToClose(ConnectEvent event) {
            AbstractControlConnection.this.aboutToDisconnect();
        }

        public void closed(ConnectEvent event) {
            AbstractControlConnection.this.disconnect(true);
        }
    }
}

