/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.OrderedInfixExpression;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class StandardComparisonFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<StandardComparisonFixOperation> operations = new ArrayList<StandardComparisonFixOperation>();
        StandardComparisonFinder finder = new StandardComparisonFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new StandardComparisonFixCore(FixMessages.StandardComparisonFix_compare_to_zero, compilationUnit, ops);
    }

    protected StandardComparisonFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class StandardComparisonFinder
    extends ASTVisitor {
        private List<StandardComparisonFixOperation> fResult;

        public StandardComparisonFinder(List<StandardComparisonFixOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(InfixExpression visited) {
            IMethodBinding methodDeclaration;
            ITypeBinding declaringClass;
            IMethodBinding comparisonMethodBinding;
            MethodInvocation comparisonMI;
            OrderedInfixExpression<MethodInvocation, Expression> orderedCondition = ASTNodes.orderedInfix((Expression)visited, MethodInvocation.class, Expression.class);
            if (orderedCondition != null && Arrays.asList(InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS).contains(orderedCondition.getOperator()) && (comparisonMI = orderedCondition.getFirstOperand()) != null && (comparisonMethodBinding = comparisonMI.resolveMethodBinding()) != null && (declaringClass = (methodDeclaration = comparisonMethodBinding.getMethodDeclaration()).getDeclaringClass()) != null) {
                Long literalValue;
                boolean knownComparison = false;
                if (comparisonMethodBinding.getName().equals("compareTo") && this.isFromClass(declaringClass, "java.lang.Comparable") || comparisonMethodBinding.getName().equals("compareToIgnoreCase") && this.isFromClass(declaringClass, "java.lang.String") || comparisonMethodBinding.getName().equals("compare") && this.isFromClass(declaringClass, "java.util.Comparator")) {
                    knownComparison = true;
                }
                if (knownComparison && (literalValue = ASTNodes.getIntegerLiteral(orderedCondition.getSecondOperand())) != null && literalValue.compareTo(0L) != 0 && comparisonMI.getExpression() != null && !ASTNodes.is(comparisonMI.getExpression(), ThisExpression.class)) {
                    if (literalValue.compareTo(0L) < 0) {
                        if (InfixExpression.Operator.EQUALS.equals(orderedCondition.getOperator())) {
                            this.fResult.add(new StandardComparisonFixOperation(visited, comparisonMI, InfixExpression.Operator.LESS));
                        } else {
                            this.fResult.add(new StandardComparisonFixOperation(visited, comparisonMI, InfixExpression.Operator.GREATER_EQUALS));
                        }
                    } else if (InfixExpression.Operator.EQUALS.equals(orderedCondition.getOperator())) {
                        this.fResult.add(new StandardComparisonFixOperation(visited, comparisonMI, InfixExpression.Operator.GREATER));
                    } else {
                        this.fResult.add(new StandardComparisonFixOperation(visited, comparisonMI, InfixExpression.Operator.LESS_EQUALS));
                    }
                    return false;
                }
            }
            return true;
        }

        private boolean isFromClass(ITypeBinding declaringClass, String name) {
            ITypeBinding[] interfaces;
            if (declaringClass == null) {
                return false;
            }
            if (declaringClass.getErasure().getQualifiedName().equals(name)) {
                return true;
            }
            ITypeBinding[] iTypeBindingArray = interfaces = declaringClass.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding anInterface = iTypeBindingArray[n2];
                if (this.isFromClass(anInterface, name)) {
                    return true;
                }
                ++n2;
            }
            ITypeBinding superClass = declaringClass.getSuperclass();
            return this.isFromClass(superClass, name);
        }
    }

    public static class StandardComparisonFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final InfixExpression visited;
        private final MethodInvocation comparisonMethod;
        private final InfixExpression.Operator operator;

        public StandardComparisonFixOperation(InfixExpression visited, MethodInvocation comparisonMethod, InfixExpression.Operator operator) {
            this.visited = visited;
            this.comparisonMethod = comparisonMethod;
            this.operator = operator;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.StandardComparisonCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            InfixExpression newInfixExpression = ast.newInfixExpression();
            newInfixExpression.setLeftOperand((Expression)ASTNodes.createMoveTarget(rewrite, this.comparisonMethod));
            newInfixExpression.setOperator(this.operator);
            newInfixExpression.setRightOperand((Expression)ast.newNumberLiteral("0"));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newInfixExpression, group);
        }
    }
}

