/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.select;

import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.OrderBySpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.ResultColumn;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLStringHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.SelectGridViewer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;

public class SelectTableElement {
    protected ResultColumn resultColumn;
    protected OrderByValueExpression orderColumn;
    protected QueryValueExpression resultColExpr;
    protected SQLQueryObject selectStatement;
    protected QuerySelect qSelect;
    protected SQLDomainModel domainModel;
    protected Object column;
    protected Object target;
    protected SQLQueryObject statement;
    Object selectedColumn;
    String alias = "";
    String sortType = "";
    String sortOrder = "";

    public SelectTableElement(SQLDomainModel domainModel, Object target, ResultColumn resultCol) {
        this.target = target;
        this.domainModel = domainModel;
        if (target instanceof QuerySelectStatement) {
            this.selectStatement = (QuerySelectStatement)target;
            this.statement = (QueryStatement)target;
        } else if (target instanceof QuerySelect) {
            this.qSelect = (QuerySelect)target;
            this.statement = this.selectStatement = (SQLQueryObject)target;
        }
        this.resultColumn = resultCol;
        if (this.resultColumn != null) {
            TableExpression tableExpr;
            Column tableColumn;
            this.resultColExpr = this.resultColumn.getValueExpr();
            if (this.resultColExpr instanceof ValueExpressionColumn && (tableColumn = TableHelper.getColumnForColumnExpression((TableExpression)(tableExpr = ExpressionHelper.getTableExprForValueExpressionColumn((ValueExpressionColumn)this.resultColExpr)), (ValueExpressionColumn)((ValueExpressionColumn)this.resultColExpr))) != null) {
                this.column = tableColumn;
            }
        }
    }

    public SelectTableElement(SQLDomainModel domainModel, Object target, OrderByValueExpression orderCol) {
        this.target = target;
        this.statement = (QueryStatement)target;
        this.domainModel = domainModel;
        this.selectStatement = (QuerySelectStatement)target;
        this.orderColumn = orderCol;
        if (this.orderColumn != null) {
            TableExpression tableExpr;
            Column tableColumn;
            this.resultColExpr = this.orderColumn.getValueExpr();
            if (this.resultColExpr instanceof ValueExpressionColumn && (tableColumn = TableHelper.getColumnForColumnExpression((TableExpression)(tableExpr = ExpressionHelper.getTableExprForValueExpressionColumn((ValueExpressionColumn)this.resultColExpr)), (ValueExpressionColumn)((ValueExpressionColumn)this.resultColExpr))) != null) {
                this.column = tableColumn;
            }
        }
    }

    public Object getColumn() {
        return this.column;
    }

    public Object getTarget() {
        return this.target;
    }

    public SQLQueryObject getSelectStatement() {
        return this.selectStatement;
    }

    public QueryValueExpression getSQLExpression() {
        QueryValueExpression retVal = null;
        if (this.resultColumn != null) {
            retVal = this.resultColumn.getValueExpr();
        } else if (this.orderColumn != null) {
            retVal = this.orderColumn.getValueExpr();
        }
        return retVal;
    }

    public QueryValueExpression showExpressionBuilder(Object key, boolean isColumn, String sProperty) {
        ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(this.domainModel, this.statement);
        if (key == SQLBuilderConstants.P_STATEMENT_COLUMN) {
            if (sProperty.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || sProperty.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                wizard.setInputExpression(null);
            } else if (sProperty.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                if (this.resultColumn != null || this.orderColumn != null) {
                    wizard.setInputExpression(this.getSQLExpression());
                } else {
                    wizard.setInputExpression(null);
                }
            }
        } else {
            wizard = new ExpressionBuilderWizard(this.domainModel, this.selectStatement);
        }
        wizard.setIsColumn(isColumn);
        ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return wizard.getSQLExpression();
        }
        return null;
    }

    public void modify(Object key, Object propValue) {
        boolean changed = false;
        if (key == SQLBuilderConstants.P_STATEMENT_COLUMN) {
            this.column = propValue;
            if (propValue instanceof String && (((String)propValue).equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || ((String)propValue).equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || ((String)propValue).equals(SQLBuilderConstants.P_REPLACE_EXPRESSION))) {
                QueryValueExpression expr = this.showExpressionBuilder(key, false, (String)propValue);
                if (expr != null) {
                    this.selectedColumn = expr;
                }
            } else {
                this.selectedColumn = propValue instanceof String && ((String)propValue).trim().equals("") ? "" : propValue;
            }
            changed = this.resultColumn == null ? this.createSelectDetail() : this.updateColumn();
        } else if (key == SQLBuilderConstants.P_STATEMENT_ALIAS) {
            changed = this.updateAlias((String)propValue);
        } else if (key == SQLBuilderConstants.P_STATEMENT_OUTPUT) {
            changed = this.updateResultColumn((Boolean)propValue);
        } else if (key == SQLBuilderConstants.P_STATEMENT_SORTTYPE) {
            changed = this.updateSortType((String)propValue);
        } else if (key == SQLBuilderConstants.P_STATEMENT_SORTORDER) {
            changed = this.updateSortOrder((String)propValue);
        }
        if (changed) {
            SelectHelper.refresh(this.selectStatement);
        }
    }

    public String getColumnText(int columnIndex) {
        if (columnIndex == 0) {
            String result = SQLStringHelper.trimBlanks(this.getColumnName());
            return result;
        }
        if (columnIndex == 1 && this.resultColumn != null) {
            if (this.resultColumn.getName() != null) {
                return this.resultColumn.getName();
            }
        } else {
            if (columnIndex == 2) {
                if (this.resultColumn != null) {
                    if (SelectHelper.isResultColumn(this.selectStatement, this.resultColumn)) {
                        return "true";
                    }
                    return "false";
                }
                if (this.orderColumn != null) {
                    if (SelectHelper.getOrderByColIndexFromValueExpr(this.selectStatement, this.orderColumn.getValueExpr()) >= 0) {
                        return "false";
                    }
                    return "true";
                }
                return "true";
            }
            if (columnIndex == 3) {
                if (this.resultColumn == null && this.orderColumn == null || this.selectStatement == null) {
                    return "";
                }
                return this.getSortType();
            }
            if (columnIndex == 4) {
                if (this.selectStatement != null) {
                    return this.getSortOrder();
                }
                return "";
            }
        }
        return "";
    }

    private boolean createSelectDetail() {
        boolean created = false;
        if (this.resultColumn == null && this.selectedColumn != null) {
            if (this.selectedColumn instanceof ValueExpressionColumn) {
                ValueExpressionColumn currColExpr = (ValueExpressionColumn)this.selectedColumn;
                ValueExpressionColumn newColExpr = ExpressionHelper.createValueExpressionColumn(currColExpr);
                this.resultColumn = this.qSelect != null ? SelectHelper.appendResultColumn((SQLQueryObject)this.qSelect, (QueryValueExpression)newColExpr, this.alias) : SelectHelper.appendResultColumn(this.selectStatement, (QueryValueExpression)newColExpr, this.alias);
            } else {
                this.resultColumn = this.qSelect != null ? SelectHelper.appendResultColumn((SQLQueryObject)this.qSelect, (QueryValueExpression)this.selectedColumn, this.alias) : SelectHelper.appendResultColumn(this.selectStatement, (QueryValueExpression)this.selectedColumn, this.alias);
            }
            created = true;
        }
        return created;
    }

    private boolean updateColumn() {
        boolean retVal = false;
        if (this.selectedColumn instanceof QueryValueExpression) {
            QueryValueExpression valExpr = (QueryValueExpression)this.selectedColumn;
            if (this.selectedColumn instanceof ValueExpressionColumn) {
                valExpr = ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)valExpr);
            }
            retVal = SelectHelper.replaceColumnValueExpr(this.selectStatement, this.resultColumn, valExpr);
            if (this.selectStatement instanceof QuerySelectStatement) {
                SelectHelper.replaceColumnValueExprForOrderBy((QuerySelectStatement)this.selectStatement, this.resultColumn, valExpr);
            }
        } else if (this.selectedColumn != null && this.selectedColumn instanceof String && ((String)this.selectedColumn).equals("")) {
            SelectHelper.removeColumnFromResultColumns(this.selectStatement, this.getSQLExpression());
            SelectHelper.removeColumnFromOrderBy(this.selectStatement, this.getSQLExpression());
            retVal = true;
        }
        return retVal;
    }

    private boolean updateAlias(String value) {
        if (this.resultColumn == null) {
            return false;
        }
        SelectHelper.setResultColumnAlias(this.resultColumn, value);
        return true;
    }

    private boolean updateResultColumn(Boolean value) {
        if (this.resultColumn == null && this.orderColumn == null) {
            return false;
        }
        if (value.booleanValue()) {
            if (this.orderColumn != null) {
                this.resultColumn = SelectHelper.appendResultColumn(this.selectStatement, this.orderColumn.getValueExpr(), this.alias);
                this.orderColumn = null;
            }
            if (this.selectStatement instanceof QuerySelectStatement && this.sortType.trim().length() > 0) {
                SelectHelper.appendOrderByColumn((QuerySelectStatement)this.selectStatement, this.resultColumn, this.alias, this.sortType);
            }
        } else {
            this.updateAlias("");
            SelectHelper.removeColumnFromResultColumns(this.selectStatement, this.getSQLExpression());
            if (this.selectStatement instanceof QuerySelectStatement) {
                this.orderColumn = this.sortType.trim().length() > 0 ? SelectHelper.appendOrderByColumn((QuerySelectStatement)this.selectStatement, this.getSQLExpression(), this.sortType) : SelectHelper.appendOrderByColumn((QuerySelectStatement)this.selectStatement, this.getSQLExpression(), "ASC");
            }
            this.resultColumn = null;
        }
        return true;
    }

    private boolean updateSortType(String value) {
        if (this.resultColumn == null && this.orderColumn == null || this.selectStatement instanceof QuerySelect) {
            return false;
        }
        this.sortType = "";
        if (value.equalsIgnoreCase(SelectGridViewer.P_ASCENDING)) {
            this.sortType = "ASC";
        } else if (value.equalsIgnoreCase(SelectGridViewer.P_DESCENDING)) {
            this.sortType = "DESC";
        }
        if (this.sortType.length() > 0) {
            if (this.resultColumn != null) {
                SelectHelper.appendOrderByColumn((QuerySelectStatement)this.selectStatement, this.resultColumn, this.alias, this.sortType);
            } else {
                SelectHelper.appendOrderByColumn((QuerySelectStatement)this.selectStatement, this.getSQLExpression(), this.sortType);
            }
        } else {
            SelectHelper.removeColumnFromOrderBy(this.selectStatement, this.getSQLExpression());
        }
        return true;
    }

    private boolean updateSortOrder(String value) {
        if (this.resultColumn == null && this.orderColumn == null || this.selectStatement instanceof QuerySelect || this.selectStatement == null) {
            return false;
        }
        if (((QuerySelectStatement)this.selectStatement).getOrderByClause() != null) {
            int position = Integer.parseInt(value) - 1;
            boolean moved = SelectHelper.repositionColumnInOrderBy(this.selectStatement, this.getSQLExpression(), position);
            if (!moved) {
                Object orderBy = this.resultColumn != null ? SelectHelper.appendOrderByColumn((QuerySelectStatement)this.selectStatement, this.resultColumn, null, "ASC") : SelectHelper.appendOrderByColumn((QuerySelectStatement)this.selectStatement, this.getSQLExpression(), "ASC");
                SelectHelper.moveOrderByToPosition((OrderBySpecification)orderBy, (List)((QuerySelectStatement)this.selectStatement).getOrderByClause(), position);
            }
            return true;
        }
        return false;
    }

    String getColumnName() {
        String retVal = "";
        if (this.resultColumn == null && this.orderColumn == null) {
            retVal = "";
        } else {
            QueryValueExpression valExpr = this.getSQLExpression();
            if (valExpr != null) {
                if (valExpr instanceof ValueExpressionColumn) {
                    retVal = String.valueOf(TableHelper.getExposedTableName((TableExpression)ExpressionHelper.getTableExprForValueExpressionColumn((ValueExpressionColumn)valExpr))) + "." + valExpr.getName();
                    String sqlVal = valExpr.getSQL();
                    if (sqlVal.length() > retVal.length()) {
                        retVal = sqlVal;
                    }
                } else {
                    retVal = valExpr.getSQL();
                }
            }
        }
        return retVal;
    }

    String getSortType() {
        int currIdx;
        EList orderByClause;
        String result = "";
        if (this.selectStatement instanceof QuerySelectStatement && (orderByClause = ((QuerySelectStatement)this.selectStatement).getOrderByClause()) != null && orderByClause.size() > 0 && (currIdx = SelectHelper.getOrderByColIndexFromValueExpr(this.selectStatement, this.getSQLExpression())) >= 0) {
            OrderBySpecification obSpec = (OrderBySpecification)orderByClause.get(currIdx);
            result = obSpec.getOrderingSpecOption().getValue() == 2 ? Messages._UI_COMBO_SORT_DESCENDING : Messages._UI_COMBO_SORT_ASCENDING;
        }
        return result;
    }

    String getSortOrder() {
        int location;
        EList orderByClause;
        this.sortOrder = "";
        if (this.selectStatement instanceof QuerySelectStatement && (orderByClause = ((QuerySelectStatement)this.selectStatement).getOrderByClause()) != null && orderByClause.size() > 0 && (this.resultColumn != null || this.orderColumn != null) && (location = SelectHelper.getOrderByColIndexFromValueExpr(this.selectStatement, this.getSQLExpression())) != -1) {
            this.sortOrder = Integer.valueOf(location + 1).toString();
        }
        return this.sortOrder;
    }

    public boolean hasColumn() {
        return this.resultColumn != null || this.orderColumn != null || this.resultColExpr != null;
    }
}

