/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.select;

import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.DynamicComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.Modifier;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.RemoveOrderByExpressionAction;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.RemoveSelectColumnAction;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.SelectGridContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.SelectTableElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class SelectGridViewer
extends GridViewer
implements IMenuListener {
    TableColumn c2;
    TableColumn c3;
    TableColumn c4;
    TableColumn c5;
    SelectGridLabelProvider selectGridLabelProvider;
    SortOrderComboBoxCellEditor sortOrderCellEditor;
    DynamicComboBoxCellEditor columnComboBoxCellEditor;
    public static final String P_UNSORTED = Messages._UI_COMBO_SORT_UNSORTED;
    public static final String P_ASCENDING = Messages._UI_COMBO_SORT_ASCENDING;
    public static final String P_DESCENDING = Messages._UI_COMBO_SORT_DESCENDING;
    public static final String P_DEFAULT = Messages._UI_COMBO_SORT_DEFAULT;

    public SelectGridViewer(SQLDomainModel domainModel, Composite parent) {
        super(domainModel, parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.table, "org.eclipse.datatools.sqltools.sqlbuilder.sqds0040");
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_SELECT_ALIAS);
        this.columnComboBoxCellEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        this.c3 = new TableColumn(this.table, 0);
        this.c3.setText(Messages._UI_COLUMN_SELECT_OUTPUT);
        this.c4 = new TableColumn(this.table, 0);
        this.c4.setText(Messages._UI_COLUMN_SELECT_SORT_TYPE);
        this.c5 = new TableColumn(this.table, 0);
        this.c5.setText(Messages._UI_COLUMN_SELECT_SORT_ORDER);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(80));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(60));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(90));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(90));
        this.table.setLayout((Layout)layout);
        String[] columnProperties = new String[]{(String)SQLBuilderConstants.P_STATEMENT_COLUMN, (String)SQLBuilderConstants.P_STATEMENT_ALIAS, (String)SQLBuilderConstants.P_STATEMENT_OUTPUT, (String)SQLBuilderConstants.P_STATEMENT_SORTTYPE, (String)SQLBuilderConstants.P_STATEMENT_SORTORDER};
        this.setColumnProperties(columnProperties);
        this.sortOrderCellEditor = new SortOrderComboBoxCellEditor((Composite)this.table);
        CellEditor[] editors = new CellEditor[]{this.columnComboBoxCellEditor, new AliasCellEditor((Composite)this.table), new OutputCheckboxCellEditor((Composite)this.table), new SortTypeComboBoxCellEditor((Composite)this.table), this.sortOrderCellEditor};
        this.setCellEditors(editors);
        this.setCellModifier(new Modifier());
        SelectGridContentProvider gridContentProvider = new SelectGridContentProvider(domainModel);
        this.setContentProvider((IContentProvider)gridContentProvider);
        this.selectGridLabelProvider = new SelectGridLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)this.selectGridLabelProvider);
    }

    public QueryStatement getCurrentStatement() {
        return this.currentStatement;
    }

    public void refreshCellEditor(int row) {
        QueryValueExpression sqlExpr;
        boolean resultExprExistsExpression = false;
        Object obj = this.getElementAt(row);
        if (obj instanceof SelectTableElement && (sqlExpr = ((SelectTableElement)obj).getSQLExpression()) != null) {
            resultExprExistsExpression = true;
        }
        if (this.getInput() instanceof QueryStatement || this.getInput() instanceof QuerySelect) {
            BuilderUtility.fillColumnComboBox(this.columnComboBoxCellEditor, (SQLQueryObject)this.getInput(), true, resultExprExistsExpression);
        }
        CellEditor[] editors = new CellEditor[]{this.columnComboBoxCellEditor, new AliasCellEditor((Composite)this.table), new OutputCheckboxCellEditor((Composite)this.table), new SortTypeComboBoxCellEditor((Composite)this.table), this.sortOrderCellEditor};
        this.setCellEditors(editors);
    }

    public void menuAboutToShow(IMenuManager menu) {
        RemoveSelectColumnAction removeColumnAction = new RemoveSelectColumnAction(this);
        RemoveOrderByExpressionAction removeOrderByExpressionAction = new RemoveOrderByExpressionAction(this);
        menu.add((IAction)removeColumnAction);
        menu.add((IAction)removeOrderByExpressionAction);
    }

    @Override
    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.setGridTitle();
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    private void setGridTitle() {
    }

    protected void hookEditingSupport(Control control) {
        if (this.getColumnViewerEditor() != null) {
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (e.count != 2) {
                        SelectGridViewer.this.handleMouseUp(e);
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                    SelectGridViewer.this.handleMouseUp(e);
                }
            });
        }
    }

    private void handleMouseUp(MouseEvent e) {
        ViewerCell cell = this.getCell(new Point(e.x, e.y));
        if (cell != null) {
            this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(cell, e));
        }
    }

    public ViewerCell getCell(Point point) {
        ViewerRow row = this.getViewerRow(point);
        if (row != null) {
            return row.getCell(point);
        }
        return null;
    }

    public void setEnabled(boolean enable) {
        this.table.setEnabled(enable);
    }

    class AliasCellEditor
    extends TextCellEditor
    implements FocusListener {
        public AliasCellEditor(Composite parent) {
            super(parent);
            this.text.addFocusListener((FocusListener)this);
        }

        public void focusLost(FocusEvent e) {
            this.fireApplyEditorValue();
        }

        public void focusGained(FocusEvent e) {
        }

        protected void doSetValue(Object value) {
            if (value instanceof SelectTableElement) {
                SelectTableElement ste = (SelectTableElement)value;
                String result = ste.getColumnText(1);
                super.doSetValue((Object)result);
            }
        }
    }

    class OutputCheckboxCellEditor
    extends CheckboxCellEditor {
        public OutputCheckboxCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            if (value instanceof SelectTableElement) {
                SelectTableElement ste = (SelectTableElement)value;
                String result = ste.getColumnText(2);
                super.doSetValue((Object)Boolean.valueOf(result));
            }
        }

        public void activate() {
            super.activate();
            this.deactivate();
            Display.getCurrent().getFocusControl().redraw();
        }
    }

    class SelectGridLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SelectGridLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof SelectTableElement && columnIndex != 2) {
                SelectTableElement selectElement = (SelectTableElement)object;
                return selectElement.getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            SelectTableElement selectElement;
            if (columnIndex == 2 && object instanceof SelectTableElement && (selectElement = (SelectTableElement)object).hasColumn()) {
                String result = selectElement.getColumnText(columnIndex);
                if (result.equals("true")) {
                    return SQLBuilderPlugin.getPlugin().getImage("icons/output_yes.gif");
                }
                return SQLBuilderPlugin.getPlugin().getImage("icons/output_no.gif");
            }
            return null;
        }
    }

    class SortOrderComboBoxCellEditor
    extends ComboBoxCellEditor {
        public SortOrderComboBoxCellEditor(Composite parent) {
            super(parent, null);
        }

        @Override
        protected void doSetValue(Object value) {
            super.doSetValue(value);
        }

        @Override
        protected void refreshComboItems() {
            int orderNumbers;
            EList sqlOrderByClause;
            String sortOrder;
            Object obj;
            boolean orderByExpressionsExist = false;
            int row = SelectGridViewer.this.getTable().getSelectionIndex();
            boolean hasOrder = false;
            if (row >= 0 && (obj = SelectGridViewer.this.getElementAt(row)) instanceof SelectTableElement && (sortOrder = ((SelectTableElement)obj).getSortOrder()) != null && sortOrder != "") {
                hasOrder = true;
            }
            if (SelectGridViewer.this.getCurrentStatement() instanceof QuerySelectStatement && (sqlOrderByClause = ((QuerySelectStatement)SelectGridViewer.this.getCurrentStatement()).getOrderByClause()) != null && !sqlOrderByClause.isEmpty() && (orderNumbers = sqlOrderByClause.size()) >= 0) {
                orderByExpressionsExist = true;
                if (!hasOrder) {
                    ++orderNumbers;
                }
                LabelValuePair[] sortOrderItems = new LabelValuePair[orderNumbers];
                int i = 0;
                while (i < orderNumbers) {
                    String item = Integer.valueOf(i + 1).toString();
                    sortOrderItems[i] = new LabelValuePair(item, item);
                    ++i;
                }
                SelectGridViewer.this.sortOrderCellEditor.createItems(sortOrderItems);
            }
            if (!orderByExpressionsExist) {
                LabelValuePair[] sortOrderItems = new LabelValuePair[1];
                String item = Integer.valueOf(1).toString();
                sortOrderItems[0] = new LabelValuePair(item, item);
                SelectGridViewer.this.sortOrderCellEditor.createItems(sortOrderItems);
            }
        }
    }

    class SortTypeComboBoxCellEditor
    extends ComboBoxCellEditor {
        public SortTypeComboBoxCellEditor(Composite parent) {
            super(parent, new LabelValuePair[3]);
            LabelValuePair[] items = this.getLabelValuePairs();
            items[0] = new LabelValuePair(P_ASCENDING, P_ASCENDING);
            items[1] = new LabelValuePair(P_DESCENDING, P_DESCENDING);
            items[2] = new LabelValuePair("", "");
        }
    }
}

