/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.osgi.ServerClasspathContributor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageAdminServiceListener
implements ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(PackageAdminServiceListener.class);
    private final BundleContext _bootBundleContext;
    private final Map<String, BundleActivator> _activatedFragments = new HashMap<String, BundleActivator>();
    private final BundleActivator _bootBundleActivator;
    private PackageAdmin _packageAdmin;

    public PackageAdminServiceListener(BundleActivator activator, BundleContext context) throws Exception {
        this._bootBundleActivator = activator;
        this._bootBundleContext = context;
        ServiceReference sr = this._bootBundleContext.getServiceReference(PackageAdmin.class.getName());
        if (sr != null) {
            this._packageAdmin = (PackageAdmin)this._bootBundleContext.getService(sr);
        }
        this.invokeFragmentActivators();
        this._bootBundleContext.addServiceListener((ServiceListener)this, "(objectclass=" + PackageAdmin.class.getName() + ")");
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            try {
                this.invokeFragmentActivators();
            }
            catch (Exception e) {
                LOG.warn("Error invoking fragment activators", (Throwable)e);
            }
        }
    }

    private void invokeFragmentActivators() {
        Bundle[] fragments = this._packageAdmin.getFragments(this._bootBundleContext.getBundle());
        if (fragments == null) {
            return;
        }
        for (Bundle frag : fragments) {
            try {
                if (this._activatedFragments.containsKey(frag.getSymbolicName())) continue;
                String fragmentActivator = frag.getSymbolicName() + ".FragmentActivator";
                Class<?> c = Class.forName(fragmentActivator);
                BundleActivator bActivator = (BundleActivator)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this._activatedFragments.put(frag.getSymbolicName(), bActivator);
                bActivator.start(this._bootBundleContext);
                if (!(bActivator instanceof ServerClasspathContributor.Source)) continue;
                ServerClasspathContributor.Source source = (ServerClasspathContributor.Source)bActivator;
                BundleActivator bundleActivator = this._bootBundleActivator;
                if (!(bundleActivator instanceof ServerClasspathContributor.Registry)) continue;
                ServerClasspathContributor.Registry registry = (ServerClasspathContributor.Registry)bundleActivator;
                source.registerServerClasspathContributors(registry);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                LOG.info("Unable to start fragment: {}", (Object)frag, (Object)e);
            }
        }
    }

    public void stop() {
        for (Map.Entry<String, BundleActivator> fragmentActivator : this._activatedFragments.entrySet()) {
            try {
                if (fragmentActivator instanceof ServerClasspathContributor.Source) {
                    ServerClasspathContributor.Source source = (ServerClasspathContributor.Source)((Object)fragmentActivator);
                    BundleActivator bundleActivator = this._bootBundleActivator;
                    if (bundleActivator instanceof ServerClasspathContributor.Registry) {
                        ServerClasspathContributor.Registry registry = (ServerClasspathContributor.Registry)bundleActivator;
                        source.unregisterServerClasspathContributors(registry);
                    }
                }
                fragmentActivator.getValue().stop(this._bootBundleContext);
            }
            catch (Exception e) {
                LOG.warn("Unable to stop fragment {}", (Object)fragmentActivator.getKey(), (Object)e);
            }
        }
        this._activatedFragments.clear();
        this._bootBundleContext.removeServiceListener((ServiceListener)this);
    }
}

