/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.CompoundInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;
import org.eclipse.osgi.util.NLS;

public class PushStaticFieldVariable
extends CompoundInstruction {
    private final String fFieldName;
    private final String fQualifiedTypeName;

    public PushStaticFieldVariable(String fieldName, String qualifiedTypeName, int start) {
        super(start);
        this.fFieldName = fieldName;
        this.fQualifiedTypeName = qualifiedTypeName;
    }

    @Override
    public void execute() throws CoreException {
        IJavaType receiver = this.getType(this.fQualifiedTypeName);
        IJavaFieldVariable field = null;
        if (receiver instanceof IJavaInterfaceType) {
            field = ((IJavaInterfaceType)receiver).getField(this.fFieldName);
        } else if (receiver instanceof IJavaClassType) {
            field = ((IJavaClassType)receiver).getField(this.fFieldName);
        }
        if (field == null) {
            String message = NLS.bind((String)InstructionsEvaluationMessages.PushStaticFieldVariable_Cannot_find_the_field__0__in__1__1, (Object)this.fFieldName, (Object)this.fQualifiedTypeName);
            throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, message, null));
        }
        this.push(field);
    }

    public String toString() {
        return NLS.bind((String)InstructionsEvaluationMessages.PushStaticFieldVariable_push_static_field__0__2, (Object)this.fFieldName);
    }
}

