/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BTreeMaxScan;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.btree.index.B2IUndo;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class B2IMaxScan
extends BTreeMaxScan {
    private ConglomerateController base_cc_for_locking;

    B2IMaxScan() {
    }

    @Override
    public void close() throws StandardException {
        super.close();
        if (this.base_cc_for_locking != null) {
            this.base_cc_for_locking.close();
            this.base_cc_for_locking = null;
        }
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        boolean ret_val = super.closeForEndTransaction(closeHeldScan);
        SanityManager.ASSERT(ret_val, "B2IMaxScan never should be held across a commit.");
        if (this.base_cc_for_locking != null) {
            this.base_cc_for_locking.close();
            this.base_cc_for_locking = null;
        }
        return ret_val;
    }

    public void init(TransactionManager xact_manager, Transaction rawtran, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level, boolean open_for_locking, FormatableBitSet scanColumnList, B2I conglomerate, B2IUndo undo) throws StandardException {
        int base_open_mode = open_mode | 0x40;
        this.base_cc_for_locking = xact_manager.openConglomerate(conglomerate.baseConglomerateId, false, base_open_mode, lock_level, isolation_level);
        BTreeLockingPolicy b2i_locking_policy = conglomerate.getBtreeLockingPolicy(rawtran, lock_level, open_mode, isolation_level, this.base_cc_for_locking, this);
        super.init(xact_manager, rawtran, false, open_mode, lock_level, b2i_locking_policy, scanColumnList, null, 0, null, null, 0, conglomerate, undo, null, null);
    }
}

