/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

class TempTableInfo {
    private TableDescriptor td;
    private int declaredInSavepointLevel;
    private int droppededInSavepointLevel;
    private int dataModifiedInSavepointLevel;

    TempTableInfo(TableDescriptor td, int declaredInSavepointLevel) {
        this.td = td;
        this.declaredInSavepointLevel = declaredInSavepointLevel;
        this.droppededInSavepointLevel = -1;
        this.dataModifiedInSavepointLevel = -1;
    }

    TableDescriptor getTableDescriptor() {
        return this.td;
    }

    void setTableDescriptor(TableDescriptor td) {
        this.td = td;
    }

    boolean matches(String tableName) {
        return this.td.getName().equals(tableName) && this.droppededInSavepointLevel == -1;
    }

    int getModifiedInSavepointLevel() {
        return this.dataModifiedInSavepointLevel;
    }

    void setModifiedInSavepointLevel(int dataModifiedInSavepointLevel) {
        this.dataModifiedInSavepointLevel = dataModifiedInSavepointLevel;
    }

    int getDeclaredInSavepointLevel() {
        return this.declaredInSavepointLevel;
    }

    void setDeclaredInSavepointLevel(int declaredInSavepointLevel) {
        this.declaredInSavepointLevel = declaredInSavepointLevel;
    }

    int getDroppedInSavepointLevel() {
        return this.droppededInSavepointLevel;
    }

    public void setDroppedInSavepointLevel(int droppededInSavepointLevel) {
        this.droppededInSavepointLevel = droppededInSavepointLevel;
    }
}

