/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class TableOperatorNode
extends FromTable {
    ResultSetNode leftResultSet;
    ResultSetNode rightResultSet;
    Optimizer leftOptimizer;
    Optimizer rightOptimizer;
    private boolean leftModifyAccessPathsDone;
    private boolean rightModifyAccessPathsDone;

    TableOperatorNode(ResultSetNode leftResultSet, ResultSetNode rightResultSet, Properties tableProperties, ContextManager cm) throws StandardException {
        super(null, tableProperties, cm);
        this.leftResultSet = leftResultSet;
        this.rightResultSet = rightResultSet;
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList rcl) throws StandardException {
        this.leftResultSet.bindUntypedNullsToResultColumns(rcl);
        this.rightResultSet.bindUntypedNullsToResultColumns(rcl);
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        boolean callModifyAccessPaths = false;
        if (this.leftResultSet instanceof FromTable) {
            if (this.leftOptimizer != null) {
                this.leftOptimizer.modifyAccessPaths();
                this.leftResultSet = (ResultSetNode)((Object)this.leftOptimizer.getOptimizable(0));
            } else {
                this.leftResultSet = (ResultSetNode)((Object)((FromTable)this.leftResultSet).modifyAccessPath(outerTables));
            }
            this.leftModifyAccessPathsDone = true;
        } else {
            callModifyAccessPaths = true;
        }
        if (this.rightResultSet instanceof FromTable) {
            if (this.rightOptimizer != null) {
                this.rightOptimizer.modifyAccessPaths();
                this.rightResultSet = (ResultSetNode)((Object)this.rightOptimizer.getOptimizable(0));
            } else {
                this.rightResultSet = (ResultSetNode)((Object)((FromTable)this.rightResultSet).modifyAccessPath(outerTables));
            }
            this.rightModifyAccessPathsDone = true;
        } else {
            callModifyAccessPaths = true;
        }
        if (callModifyAccessPaths) {
            return (Optimizable)((Object)this.modifyAccessPaths());
        }
        return this;
    }

    @Override
    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.leftResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.leftResultSet)).verifyProperties(dDictionary);
        }
        if (this.rightResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.rightResultSet)).verifyProperties(dDictionary);
        }
        super.verifyProperties(dDictionary);
    }

    @Override
    public void updateBestPlanMap(short action, Object planKey) throws StandardException {
        super.updateBestPlanMap(action, planKey);
        if (this.leftResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.leftResultSet)).updateBestPlanMap(action, planKey);
        } else if (this.leftResultSet.getOptimizerImpl() != null) {
            this.leftResultSet.getOptimizerImpl().updateBestPlanMaps(action, planKey);
        }
        if (this.rightResultSet instanceof Optimizable) {
            ((Optimizable)((Object)this.rightResultSet)).updateBestPlanMap(action, planKey);
        } else if (this.rightResultSet.getOptimizerImpl() != null) {
            this.rightResultSet.getOptimizerImpl().updateBestPlanMaps(action, planKey);
        }
    }

    @Override
    public String toString() {
        return "nestedInParens: false\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftResultSet != null) {
            this.printLabel(depth, "leftResultSet: ");
            this.leftResultSet.treePrint(depth + 1);
        }
        if (this.rightResultSet != null) {
            this.printLabel(depth, "rightResultSet: ");
            this.rightResultSet.treePrint(depth + 1);
        }
    }

    ResultSetNode getLeftResultSet() {
        return this.leftResultSet;
    }

    ResultSetNode getRightResultSet() {
        return this.rightResultSet;
    }

    ResultSetNode getLeftmostResultSet() {
        if (this.leftResultSet instanceof TableOperatorNode) {
            return ((TableOperatorNode)this.leftResultSet).getLeftmostResultSet();
        }
        return this.leftResultSet;
    }

    void setLeftmostResultSet(ResultSetNode newLeftResultSet) {
        if (this.leftResultSet instanceof TableOperatorNode) {
            ((TableOperatorNode)this.leftResultSet).setLeftmostResultSet(newLeftResultSet);
        } else {
            this.leftResultSet = newLeftResultSet;
        }
    }

    @Override
    void setLevel(int level) {
        super.setLevel(level);
        if (this.leftResultSet instanceof FromTable) {
            ((FromTable)this.leftResultSet).setLevel(level);
        }
        if (this.rightResultSet instanceof FromTable) {
            ((FromTable)this.rightResultSet).setLevel(level);
        }
    }

    @Override
    String getExposedName() {
        return null;
    }

    void setNestedInParens(boolean nestedInParens) {
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        this.leftResultSet = this.leftResultSet.bindNonVTITables(dataDictionary, fromListParam);
        this.rightResultSet = this.rightResultSet.bindNonVTITables(dataDictionary, fromListParam);
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    @Override
    ResultSetNode bindVTITables(FromList fromListParam) throws StandardException {
        this.leftResultSet = this.leftResultSet.bindVTITables(fromListParam);
        this.rightResultSet = this.rightResultSet.bindVTITables(fromListParam);
        return this;
    }

    @Override
    void bindExpressions(FromList fromListParam) throws StandardException {
        if (!(this instanceof UnionNode) || !((UnionNode)this).tableConstructor()) {
            this.leftResultSet.rejectParameters();
            this.rightResultSet.rejectParameters();
        }
        this.leftResultSet.bindExpressions(fromListParam);
        this.rightResultSet.bindExpressions(fromListParam);
    }

    @Override
    void rejectParameters() throws StandardException {
        this.leftResultSet.rejectParameters();
        this.rightResultSet.rejectParameters();
    }

    @Override
    void bindExpressionsWithTables(FromList fromListParam) throws StandardException {
        if (!(this instanceof UnionNode) || !((UnionNode)this).tableConstructor()) {
            this.leftResultSet.rejectParameters();
            this.rightResultSet.rejectParameters();
        }
        this.leftResultSet.bindExpressionsWithTables(fromListParam);
        this.rightResultSet.bindExpressionsWithTables(fromListParam);
    }

    @Override
    void bindResultColumns(FromList fromListParam) throws StandardException {
        this.leftResultSet.bindResultColumns(fromListParam);
        this.rightResultSet.bindResultColumns(fromListParam);
    }

    @Override
    void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        this.leftResultSet.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
        this.rightResultSet.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
    }

    @Override
    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        FromTable result = this.leftResultSet.getFromTableByName(name, schemaName, exactMatch);
        if (result == null) {
            result = this.rightResultSet.getFromTableByName(name, schemaName, exactMatch);
        }
        return result;
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.leftResultSet = this.leftResultSet.preprocess(numTables, gbl, fromList);
        if (this.leftResultSet instanceof FromSubquery) {
            this.leftResultSet = ((FromSubquery)this.leftResultSet).extractSubquery(numTables);
        }
        this.rightResultSet = this.rightResultSet.preprocess(numTables, gbl, fromList);
        if (this.rightResultSet instanceof FromSubquery) {
            this.rightResultSet = ((FromSubquery)this.rightResultSet).extractSubquery(numTables);
        }
        this.setReferencedTableMap((JBitSet)this.leftResultSet.getReferencedTableMap().clone());
        this.getReferencedTableMap().or(this.rightResultSet.getReferencedTableMap());
        this.getReferencedTableMap().set(this.tableNumber);
        if (this.isFlattenableJoinNode()) {
            return this;
        }
        this.projectResultColumns();
        return this.genProjectRestrict(numTables);
    }

    @Override
    void projectResultColumns() throws StandardException {
        this.getResultColumns().doProjection();
    }

    void setReferencedColumns() {
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double outerRows) throws StandardException {
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.leftResultSet = this.leftResultSet.optimize(dataDictionary, predicateList, outerRows);
        this.rightResultSet = this.rightResultSet.optimize(dataDictionary, predicateList, outerRows);
        this.getCostEstimate().setCost(this.leftResultSet.getCostEstimate().getEstimatedCost(), this.leftResultSet.getCostEstimate().rowCount(), this.leftResultSet.getCostEstimate().singleScanRowCount() + this.rightResultSet.getCostEstimate().singleScanRowCount());
        this.getCostEstimate().add(this.rightResultSet.getCostEstimate(), this.getCostEstimate());
        return this;
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        SetOperatorNode setOp;
        if (!this.leftModifyAccessPathsDone) {
            if (this.leftOptimizer != null) {
                this.leftOptimizer.modifyAccessPaths();
                this.leftResultSet = (ResultSetNode)((Object)this.leftOptimizer.getOptimizable(0));
            } else if (this instanceof SetOperatorNode) {
                setOp = (SetOperatorNode)this;
                this.leftResultSet = this.leftResultSet.modifyAccessPaths(setOp.getLeftOptPredicateList());
            } else {
                this.leftResultSet = this.leftResultSet.modifyAccessPaths();
            }
        }
        if (!this.rightModifyAccessPathsDone) {
            if (this.rightOptimizer != null) {
                this.rightOptimizer.modifyAccessPaths();
                this.rightResultSet = (ResultSetNode)((Object)this.rightOptimizer.getOptimizable(0));
            } else if (this instanceof SetOperatorNode) {
                setOp = (SetOperatorNode)this;
                this.rightResultSet = this.rightResultSet.modifyAccessPaths(setOp.getRightOptPredicateList());
            } else {
                this.rightResultSet = this.rightResultSet.modifyAccessPaths();
            }
        }
        return this;
    }

    @Override
    boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return this.leftResultSet.referencesTarget(name, baseTable) || this.rightResultSet.referencesTarget(name, baseTable);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.leftResultSet.referencesSessionSchema() || this.rightResultSet.referencesSessionSchema();
    }

    protected ResultSetNode optimizeSource(Optimizer optimizer, ResultSetNode sourceResultSet, PredicateList predList, CostEstimate outerCost) throws StandardException {
        ResultSetNode retval;
        if (sourceResultSet instanceof FromTable) {
            FromList optList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), (FromTable)sourceResultSet, this.getContextManager());
            if (predList == null) {
                predList = new PredicateList(this.getContextManager());
            }
            LanguageConnectionContext lcc = this.getLanguageConnectionContext();
            OptimizerFactory optimizerFactory = lcc.getOptimizerFactory();
            optimizer = optimizerFactory.getOptimizer(optList, predList, this.getDataDictionary(), null, this.getCompilerContext().getNumTables(), null, lcc);
            optimizer.prepForNextRound();
            if (sourceResultSet == this.leftResultSet) {
                this.leftOptimizer = optimizer;
            } else if (sourceResultSet == this.rightResultSet) {
                this.rightOptimizer = optimizer;
            } else {
                SanityManager.THROWASSERT("Result set being optimized is neither left nor right");
            }
            optimizer.setOuterRows(outerCost.rowCount());
            while (optimizer.getNextPermutation()) {
                while (optimizer.getNextDecoratedPermutation()) {
                    optimizer.costPermutation();
                }
            }
            retval = sourceResultSet;
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceEndQueryBlock();
            }
        } else {
            retval = sourceResultSet.optimize(this.getDataDictionary(), predList, outerCost.rowCount());
        }
        return retval;
    }

    @Override
    void decrementLevel(int decrement) {
        this.leftResultSet.decrementLevel(decrement);
        this.rightResultSet.decrementLevel(decrement);
    }

    @Override
    void adjustForSortElimination() {
        this.leftResultSet.adjustForSortElimination();
        this.rightResultSet.adjustForSortElimination();
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering rowOrdering) throws StandardException {
        this.leftResultSet.adjustForSortElimination(rowOrdering);
        this.rightResultSet.adjustForSortElimination(rowOrdering);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.leftResultSet != null) {
            this.leftResultSet = (ResultSetNode)this.leftResultSet.accept(v);
        }
        if (this.rightResultSet != null) {
            this.rightResultSet = (ResultSetNode)this.rightResultSet.accept(v);
        }
    }

    @Override
    boolean needsSpecialRCLBinding() {
        return true;
    }
}

