/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class ExtractOperatorNode
extends UnaryOperatorNode {
    private static final String[] fieldName = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND"};
    private static final String[] fieldMethod = new String[]{"getYear", "getMonth", "getDate", "getHours", "getMinutes", "getSeconds"};
    private int extractField;

    ExtractOperatorNode(int field, ValueNode operand, ContextManager cm) throws StandardException {
        super(operand, "EXTRACT " + fieldName[field], fieldMethod[field], cm);
        this.extractField = field;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregates);
        TypeId opTypeId = this.operand.getTypeId();
        int operandType = opTypeId.getJDBCTypeId();
        if (opTypeId.isStringTypeId()) {
            TypeCompiler tc = this.operand.getTypeCompiler();
            int castType = this.extractField < 3 ? 91 : 92;
            this.operand = new CastNode(this.operand, DataTypeDescriptor.getBuiltInDataTypeDescriptor(castType, true, tc.getCastToCharWidth(this.operand.getTypeServices())), this.getContextManager());
            ((CastNode)this.operand).bindCastNodeOnly();
            opTypeId = this.operand.getTypeId();
            operandType = opTypeId.getJDBCTypeId();
        }
        if (operandType != 91 && operandType != 92 && operandType != 93) {
            throw StandardException.newException("42X25", "EXTRACT " + fieldName[this.extractField], opTypeId.getSQLTypeName());
        }
        if (operandType == 91 && this.extractField > 2) {
            throw StandardException.newException("42X25", "EXTRACT " + fieldName[this.extractField], opTypeId.getSQLTypeName());
        }
        if (operandType == 92 && this.extractField < 3) {
            throw StandardException.newException("42X25", "EXTRACT " + fieldName[this.extractField], opTypeId.getSQLTypeName());
        }
        if (operandType == 93 && this.extractField == 5) {
            this.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), this.operand.getTypeServices().isNullable()));
        } else {
            this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.operand.getTypeServices().isNullable()));
        }
        return this;
    }

    @Override
    public String toString() {
        return "fieldName: " + fieldName[this.extractField] + "\n" + super.toString();
    }
}

