/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.timer;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.timer.TimerFactory;
import org.apache.derby.shared.common.error.StandardException;

public class SingletonTimerFactory
implements TimerFactory,
ModuleControl {
    private final Timer singletonTimer;
    private final AtomicInteger cancelCount = new AtomicInteger();
    private StringBuilder warnings = new StringBuilder();

    public SingletonTimerFactory() {
        ClassLoader savecl = this.getContextClassLoader();
        if (savecl != null) {
            this.setContextClassLoader(null);
        }
        this.singletonTimer = new Timer(true);
        if (savecl != null) {
            this.setContextClassLoader(savecl);
        }
    }

    @Override
    public void schedule(TimerTask task, long delay) {
        this.singletonTimer.schedule(task, delay);
    }

    @Override
    public void cancel(TimerTask task) {
        task.cancel();
        if (this.cancelCount.incrementAndGet() % 1000 == 0) {
            this.singletonTimer.purge();
        }
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
    }

    @Override
    public void stop() {
        this.singletonTimer.cancel();
    }

    private ClassLoader getContextClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == this.getClass().getClassLoader() || cl == Thread.class.getClassLoader()) {
            return null;
        }
        return cl;
    }

    private void setContextClassLoader(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
    }

    public String getWarnings() {
        String result = this.warnings.toString();
        this.warnings = null;
        return "".equals(result) ? null : result;
    }
}

