/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Timestamp;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public class TriggerDescriptor
extends UniqueSQLObjectDescriptor
implements Provider,
Dependent,
Formatable {
    public static final int SYSTRIGGERS_STATE_FIELD = 8;
    public static final int TRIGGER_EVENT_UPDATE = 1;
    public static final int TRIGGER_EVENT_DELETE = 2;
    public static final int TRIGGER_EVENT_INSERT = 4;
    private UUID id;
    private String name;
    private String oldReferencingName;
    private String newReferencingName;
    private String triggerDefinition;
    private SchemaDescriptor sd;
    private int eventMask;
    private boolean isBefore;
    private boolean isRow;
    private boolean referencingOld;
    private boolean referencingNew;
    private TableDescriptor td;
    private UUID actionSPSId;
    private SPSDescriptor actionSPS;
    private UUID whenSPSId;
    private SPSDescriptor whenSPS;
    private boolean isEnabled;
    private int[] referencedCols;
    private int[] referencedColsInTriggerAction;
    private Timestamp creationTimestamp;
    private UUID triggerSchemaId;
    private UUID triggerTableId;
    private String whenClauseText;

    public TriggerDescriptor() {
    }

    TriggerDescriptor(DataDictionary dataDictionary, SchemaDescriptor sd, UUID id, String name, int eventMask, boolean isBefore, boolean isRow, boolean isEnabled, TableDescriptor td, UUID whenSPSId, UUID actionSPSId, Timestamp creationTimestamp, int[] referencedCols, int[] referencedColsInTriggerAction, String triggerDefinition, boolean referencingOld, boolean referencingNew, String oldReferencingName, String newReferencingName, String whenClauseText) {
        super(dataDictionary);
        this.id = id;
        this.sd = sd;
        this.name = name;
        this.eventMask = eventMask;
        this.isBefore = isBefore;
        this.isRow = isRow;
        this.td = td;
        this.actionSPSId = actionSPSId;
        this.whenSPSId = whenSPSId;
        this.isEnabled = isEnabled;
        this.referencedCols = referencedCols;
        this.setReferencedColsInTriggerAction(referencedColsInTriggerAction);
        this.creationTimestamp = DataTypeUtilities.clone(creationTimestamp);
        this.triggerDefinition = triggerDefinition;
        this.referencingOld = referencingOld;
        this.referencingNew = referencingNew;
        this.oldReferencingName = oldReferencingName;
        this.newReferencingName = newReferencingName;
        this.whenClauseText = whenClauseText;
        this.triggerSchemaId = sd.getUUID();
        this.triggerTableId = td.getUUID();
    }

    @Override
    public UUID getUUID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UUID getTableId() {
        return this.triggerTableId;
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        if (this.sd == null) {
            this.sd = this.getDataDictionary().getSchemaDescriptor(this.triggerSchemaId, null);
        }
        return this.sd;
    }

    public boolean listensForEvent(int event) {
        return (event & this.eventMask) == event;
    }

    public int getTriggerEventMask() {
        return this.eventMask;
    }

    public Timestamp getCreationTimestamp() {
        return DataTypeUtilities.clone(this.creationTimestamp);
    }

    public boolean isBeforeTrigger() {
        return this.isBefore;
    }

    public boolean isRowTrigger() {
        return this.isRow;
    }

    public UUID getActionId() {
        return this.actionSPSId;
    }

    public SPSDescriptor getActionSPS(LanguageConnectionContext lcc) throws StandardException {
        return this.getSPS(lcc, false);
    }

    private SPSDescriptor getSPS(LanguageConnectionContext lcc, boolean isWhenClause) throws StandardException {
        boolean usesReferencingClause;
        boolean in10_9_orHigherVersion;
        String originalSQL;
        DataDictionary dd = this.getDataDictionary();
        SPSDescriptor sps = isWhenClause ? this.whenSPS : this.actionSPS;
        UUID spsId = isWhenClause ? this.whenSPSId : this.actionSPSId;
        String string = originalSQL = isWhenClause ? this.whenClauseText : this.triggerDefinition;
        if (sps == null) {
            lcc.beginNestedTransaction(true);
            sps = dd.getSPSDescriptor(spsId);
            lcc.commitNestedTransaction();
        }
        boolean bl = (in10_9_orHigherVersion = dd.checkVersion(210, null)) ? this.referencedColsInTriggerAction != null : (usesReferencingClause = this.referencingOld || this.referencingNew);
        if ((!sps.isValid() || sps.getPreparedStatement() == null) && this.isRow && usesReferencingClause) {
            CompilerContext newCC = lcc.pushCompilerContext(dd.getSchemaDescriptor(sps.getCompSchemaId(), null));
            Parser pa = newCC.getParser();
            Visitable stmtnode = isWhenClause ? pa.parseSearchCondition(originalSQL) : pa.parseStatement(originalSQL);
            lcc.popCompilerContext(newCC);
            int[] cols = dd.examineTriggerNodeAndCols(stmtnode, this.oldReferencingName, this.newReferencingName, originalSQL, this.referencedCols, this.referencedColsInTriggerAction, 0, this.getTableDescriptor(), -1, false, null);
            Object newText = dd.getTriggerActionString(stmtnode, this.oldReferencingName, this.newReferencingName, originalSQL, this.referencedCols, this.referencedColsInTriggerAction, 0, this.getTableDescriptor(), -1, false, null, cols);
            if (isWhenClause) {
                newText = "VALUES " + (String)newText;
            }
            sps.setText((String)newText);
        }
        return sps;
    }

    public UUID getWhenClauseId() {
        return this.whenSPSId;
    }

    public String getWhenClauseText() {
        return this.whenClauseText;
    }

    public SPSDescriptor getWhenClauseSPS(LanguageConnectionContext lcc) throws StandardException {
        if (this.whenSPSId == null) {
            return null;
        }
        return this.getSPS(lcc, true);
    }

    public TableDescriptor getTableDescriptor() throws StandardException {
        if (this.td == null) {
            this.td = this.getDataDictionary().getTableDescriptor(this.triggerTableId);
        }
        return this.td;
    }

    public int[] getReferencedCols() {
        return ArrayUtil.copy(this.referencedCols);
    }

    public void setReferencedCols(int[] newCols) {
        this.referencedCols = ArrayUtil.copy(newCols);
    }

    public int[] getReferencedColsInTriggerAction() {
        return ArrayUtil.copy(this.referencedColsInTriggerAction);
    }

    public void setReferencedColsInTriggerAction(int[] referencedColsInTriggerAction) {
        this.referencedColsInTriggerAction = ArrayUtil.copy(referencedColsInTriggerAction);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled() {
        this.isEnabled = true;
    }

    public void setDisabled() {
        this.isEnabled = false;
    }

    public boolean needsToFire(int stmtType, int[] modifiedCols) throws StandardException {
        if (stmtType != 1 && stmtType != 2 && stmtType != 3 && stmtType != 4) {
            SanityManager.THROWASSERT("invalid statement type " + stmtType);
        }
        if (!this.isEnabled) {
            return false;
        }
        if (stmtType == 1) {
            return (this.eventMask & 4) == this.eventMask;
        }
        if (stmtType == 4) {
            return (this.eventMask & 2) == this.eventMask;
        }
        if (stmtType == 2) {
            throw StandardException.newException("42Z08", this.getTableDescriptor().getQualifiedName(), this.name);
        }
        return (this.eventMask & 1) == this.eventMask && ConstraintDescriptor.doColumnsIntersect(modifiedCols, this.referencedCols);
    }

    public String getTriggerDefinition() {
        return this.triggerDefinition;
    }

    public boolean getReferencingOld() {
        return this.referencingOld;
    }

    public boolean getReferencingNew() {
        return this.referencingNew;
    }

    public String getOldReferencingName() {
        return this.oldReferencingName;
    }

    public String getNewReferencingName() {
        return this.newReferencingName;
    }

    public String toString() {
        return "TRIGGER: " + this.name;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(320);
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public UUID getObjectID() {
        return this.id;
    }

    @Override
    public String getClassType() {
        return "Trigger";
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 1: 
            case 6: 
            case 9: 
            case 13: 
            case 34: 
            case 43: 
            case 45: {
                DependencyManager dm = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y25.S", dm.getActionString(action), p.getObjectName(), "TRIGGER", this.name);
            }
        }
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 14: {
                DependencyManager dm = this.getDataDictionary().getDependencyManager();
                dm.invalidateFor(this, 11, lcc);
                break;
            }
            case 44: 
            case 47: {
                this.drop(lcc);
                lcc.getLastActivation().addWarning(StandardException.newWarning("01502", this.getObjectName()));
                break;
            }
        }
    }

    public void drop(LanguageConnectionContext lcc) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dm.invalidateFor(this, 27, lcc);
        dd.dropTriggerDescriptor(this, tc);
        dm.clearDependencies(lcc, this);
        SPSDescriptor spsd = dd.getSPSDescriptor(this.getActionId());
        dm.invalidateFor(spsd, 27, lcc);
        dm.clearDependencies(lcc, spsd);
        dd.dropSPSDescriptor(spsd, tc);
        if (this.getWhenClauseId() != null) {
            spsd = dd.getSPSDescriptor(this.getWhenClauseId());
            dm.invalidateFor(spsd, 27, lcc);
            dm.clearDependencies(lcc, spsd);
            dd.dropSPSDescriptor(spsd, tc);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.id = (UUID)in.readObject();
        this.name = (String)in.readObject();
        this.triggerSchemaId = (UUID)in.readObject();
        this.triggerTableId = (UUID)in.readObject();
        this.eventMask = in.readInt();
        this.isBefore = in.readBoolean();
        this.isRow = in.readBoolean();
        this.isEnabled = in.readBoolean();
        this.whenSPSId = (UUID)in.readObject();
        this.actionSPSId = (UUID)in.readObject();
        int length = in.readInt();
        if (length != 0) {
            this.referencedCols = new int[length];
            for (i = 0; i < length; ++i) {
                this.referencedCols[i] = in.readInt();
            }
        }
        if ((length = in.readInt()) != 0) {
            this.referencedColsInTriggerAction = new int[length];
            for (i = 0; i < length; ++i) {
                this.referencedColsInTriggerAction[i] = in.readInt();
            }
        }
        this.triggerDefinition = (String)in.readObject();
        this.referencingOld = in.readBoolean();
        this.referencingNew = in.readBoolean();
        this.oldReferencingName = (String)in.readObject();
        this.newReferencingName = (String)in.readObject();
        this.whenClauseText = (String)in.readObject();
    }

    @Override
    protected DataDictionary getDataDictionary() {
        DataDictionary dd = super.getDataDictionary();
        if (dd == null) {
            LanguageConnectionContext lcc = (LanguageConnectionContext)TriggerDescriptor.getContext("LanguageConnectionContext");
            dd = lcc.getDataDictionary();
            this.setDataDictionary(dd);
        }
        return dd;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        SanityManager.ASSERT(this.triggerSchemaId != null, "triggerSchemaId expected to be non-null");
        SanityManager.ASSERT(this.triggerTableId != null, "triggerTableId expected to be non-null");
        out.writeObject(this.id);
        out.writeObject(this.name);
        out.writeObject(this.triggerSchemaId);
        out.writeObject(this.triggerTableId);
        out.writeInt(this.eventMask);
        out.writeBoolean(this.isBefore);
        out.writeBoolean(this.isRow);
        out.writeBoolean(this.isEnabled);
        out.writeObject(this.whenSPSId);
        out.writeObject(this.actionSPSId);
        if (this.referencedCols == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.referencedCols.length);
            for (i = 0; i < this.referencedCols.length; ++i) {
                out.writeInt(this.referencedCols[i]);
            }
        }
        if (this.referencedColsInTriggerAction == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.referencedColsInTriggerAction.length);
            for (i = 0; i < this.referencedColsInTriggerAction.length; ++i) {
                out.writeInt(this.referencedColsInTriggerAction[i]);
            }
        }
        out.writeObject(this.triggerDefinition);
        out.writeBoolean(this.referencingOld);
        out.writeBoolean(this.referencingNew);
        out.writeObject(this.oldReferencingName);
        out.writeObject(this.newReferencingName);
        out.writeObject(this.whenClauseText);
    }

    @Override
    public int getTypeFormatId() {
        return 316;
    }

    @Override
    public String getDescriptorType() {
        return "Trigger";
    }

    @Override
    public String getDescriptorName() {
        return this.name;
    }

    private static Context getContext(String contextID) {
        return ContextService.getContext(contextID);
    }
}

